/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.annotation;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionFactory;
import org.apache.pdfbox.pdmodel.interactive.action.PDAnnotationAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceCharacteristicsDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;

public class PDAnnotationWidget
extends PDAnnotation {
    public static final String SUB_TYPE = "Widget";

    public PDAnnotationWidget() {
        this.getDictionary().setName(COSName.SUBTYPE, SUB_TYPE);
    }

    public PDAnnotationWidget(COSDictionary field) {
        super(field);
        this.getDictionary().setName(COSName.SUBTYPE, SUB_TYPE);
    }

    public String getHighlightingMode() {
        return this.getDictionary().getNameAsString(COSName.H, "I");
    }

    public void setHighlightingMode(String highlightingMode) {
        if (!(highlightingMode == null || "N".equals(highlightingMode) || "I".equals(highlightingMode) || "O".equals(highlightingMode) || "P".equals(highlightingMode) || "T".equals(highlightingMode))) {
            throw new IllegalArgumentException("Valid values for highlighting mode are 'N', 'N', 'O', 'P' or 'T'");
        }
        this.getDictionary().setName(COSName.H, highlightingMode);
    }

    public PDAppearanceCharacteristicsDictionary getAppearanceCharacteristics() {
        COSBase mk = this.getDictionary().getDictionaryObject(COSName.MK);
        if (mk instanceof COSDictionary) {
            return new PDAppearanceCharacteristicsDictionary((COSDictionary)mk);
        }
        return null;
    }

    public void setAppearanceCharacteristics(PDAppearanceCharacteristicsDictionary appearanceCharacteristics) {
        this.getDictionary().setItem(COSName.MK, (COSObjectable)appearanceCharacteristics);
    }

    public PDAction getAction() {
        COSDictionary action = (COSDictionary)this.getDictionary().getDictionaryObject(COSName.A);
        return PDActionFactory.createAction(action);
    }

    public void setAction(PDAction action) {
        this.getDictionary().setItem(COSName.A, (COSObjectable)action);
    }

    public PDAnnotationAdditionalActions getActions() {
        COSDictionary aa = (COSDictionary)this.getDictionary().getDictionaryObject("AA");
        PDAnnotationAdditionalActions retval = null;
        if (aa != null) {
            retval = new PDAnnotationAdditionalActions(aa);
        }
        return retval;
    }

    public void setActions(PDAnnotationAdditionalActions actions) {
        this.getDictionary().setItem("AA", (COSObjectable)actions);
    }

    public void setBorderStyle(PDBorderStyleDictionary bs) {
        this.getDictionary().setItem("BS", (COSObjectable)bs);
    }

    public PDBorderStyleDictionary getBorderStyle() {
        COSDictionary bs = (COSDictionary)this.getDictionary().getItem(COSName.BS);
        if (bs != null) {
            return new PDBorderStyleDictionary(bs);
        }
        return null;
    }
}

