/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.shading;

import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.apache.pdfbox.util.Matrix;

public abstract class ShadingContext {
    private static final Log LOG = LogFactory.getLog(ShadingContext.class);
    protected final PDShading shading;
    protected final Rectangle deviceBounds;
    protected PDColorSpace shadingColorSpace;
    protected PDRectangle bboxRect;
    protected float minBBoxX;
    protected float minBBoxY;
    protected float maxBBoxX;
    protected float maxBBoxY;
    protected ColorModel outputColorModel;
    protected float[] background;
    protected int rgbBackground;

    public ShadingContext(PDShading shading, ColorModel cm, AffineTransform xform, Matrix matrix, Rectangle deviceBounds) throws IOException {
        COSArray bg;
        this.shading = shading;
        this.deviceBounds = deviceBounds;
        this.shadingColorSpace = shading.getColorSpace();
        ColorSpace outputCS = ColorSpace.getInstance(1000);
        this.outputColorModel = new ComponentColorModel(outputCS, true, false, 3, 0);
        this.bboxRect = shading.getBBox();
        if (this.bboxRect != null) {
            this.transformBBox(matrix, xform);
        }
        if ((bg = shading.getBackground()) != null) {
            this.background = bg.toFloatArray();
            this.rgbBackground = this.convertToRGB(this.background);
        }
    }

    private void transformBBox(Matrix matrix, AffineTransform xform) {
        float[] bboxTab = new float[]{this.bboxRect.getLowerLeftX(), this.bboxRect.getLowerLeftY(), this.bboxRect.getUpperRightX(), this.bboxRect.getUpperRightY()};
        matrix.createAffineTransform().transform(bboxTab, 0, bboxTab, 0, 2);
        xform.transform(bboxTab, 0, bboxTab, 0, 2);
        this.minBBoxX = Math.min(bboxTab[0], bboxTab[2]);
        this.minBBoxY = Math.min(bboxTab[1], bboxTab[3]);
        this.maxBBoxX = Math.max(bboxTab[0], bboxTab[2]);
        this.maxBBoxY = Math.max(bboxTab[1], bboxTab[3]);
        if (this.minBBoxX >= this.maxBBoxX || this.minBBoxY >= this.maxBBoxY) {
            LOG.warn((Object)"empty BBox is ignored");
            this.bboxRect = null;
        }
    }

    protected final int convertToRGB(float[] values) throws IOException {
        float[] rgbValues = this.shadingColorSpace.toRGB(values);
        int normRGBValues = (int)(rgbValues[0] * 255.0f);
        normRGBValues |= (int)(rgbValues[1] * 255.0f) << 8;
        return normRGBValues |= (int)(rgbValues[2] * 255.0f) << 16;
    }
}

