/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.listener.InMemoryExtendedOperationHandler;
import com.unboundid.ldap.listener.InMemoryRequestHandler;
import com.unboundid.ldap.listener.ListenerMessages;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.matchingrules.OctetStringMatchingRule;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.extensions.PasswordModifyExtendedRequest;
import com.unboundid.ldap.sdk.extensions.PasswordModifyExtendedResult;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PasswordModifyExtendedOperationHandler
extends InMemoryExtendedOperationHandler {
    @Override
    public String getExtendedOperationHandlerName() {
        return "Password Modify";
    }

    @Override
    public List<String> getSupportedExtendedRequestOIDs() {
        return Arrays.asList("1.3.6.1.4.1.4203.1.11.1");
    }

    @Override
    public ExtendedResult processExtendedOperation(InMemoryRequestHandler handler, int messageID, ExtendedRequest request) {
        ASN1OctetString genPW;
        byte[] pwBytes;
        DN targetDN;
        PasswordModifyExtendedRequest pwModRequest;
        for (Control c : request.getControls()) {
            if (!c.isCritical()) continue;
            return new ExtendedResult(messageID, ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, ListenerMessages.ERR_PW_MOD_EXTOP_UNSUPPORTED_CONTROL.get(c.getOID()), null, null, null, null, null);
        }
        try {
            pwModRequest = new PasswordModifyExtendedRequest(request);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            return new ExtendedResult(messageID, le.getResultCode(), le.getDiagnosticMessage(), le.getMatchedDN(), le.getReferralURLs(), null, null, null);
        }
        String userIdentity = pwModRequest.getUserIdentity();
        byte[] oldPWBytes = pwModRequest.getOldPasswordBytes();
        byte[] newPWBytes = pwModRequest.getNewPasswordBytes();
        if (userIdentity == null) {
            targetDN = handler.getAuthenticatedDN();
        } else {
            DN authDN;
            try {
                authDN = new DN(userIdentity, handler.getSchema());
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                try {
                    authDN = handler.getDNForAuthzID(userIdentity);
                }
                catch (LDAPException le2) {
                    Debug.debugException(le2);
                    return new PasswordModifyExtendedResult(messageID, ResultCode.INVALID_DN_SYNTAX, ListenerMessages.ERR_PW_MOD_EXTOP_CANNOT_PARSE_USER_IDENTITY.get(userIdentity), null, null, null, null);
                }
            }
            targetDN = authDN;
        }
        if (targetDN == null || targetDN.isNullDN()) {
            return new PasswordModifyExtendedResult(messageID, ResultCode.UNWILLING_TO_PERFORM, ListenerMessages.ERR_PW_MOD_NO_IDENTITY.get(), null, null, null, null);
        }
        ReadOnlyEntry userEntry = handler.getEntry(targetDN);
        if (userEntry == null) {
            return new PasswordModifyExtendedResult(messageID, ResultCode.UNWILLING_TO_PERFORM, ListenerMessages.ERR_PW_MOD_EXTOP_CANNOT_GET_USER_ENTRY.get(targetDN.toString()), null, null, null, null);
        }
        if (oldPWBytes == null) {
            if (handler.getAuthenticatedDN().isNullDN()) {
                return new PasswordModifyExtendedResult(messageID, ResultCode.UNWILLING_TO_PERFORM, ListenerMessages.ERR_PW_MOD_EXTOP_NO_AUTHENTICATION.get(), null, null, null, null);
            }
        } else if (!userEntry.hasAttributeValue("userPassword", oldPWBytes, (MatchingRule)OctetStringMatchingRule.getInstance())) {
            return new PasswordModifyExtendedResult(messageID, ResultCode.INVALID_CREDENTIALS, null, null, null, null, null);
        }
        if (newPWBytes == null) {
            SecureRandom random = new SecureRandom();
            byte[] pwAlphabet = StaticUtils.getBytes("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789");
            pwBytes = new byte[8];
            for (int i = 0; i < pwBytes.length; ++i) {
                pwBytes[i] = pwAlphabet[random.nextInt(pwAlphabet.length)];
            }
            genPW = new ASN1OctetString(pwBytes);
        } else {
            genPW = null;
            pwBytes = newPWBytes;
        }
        try {
            handler.modifyEntry(userEntry.getDN(), Arrays.asList(new Modification(ModificationType.REPLACE, "userPassword", pwBytes)));
            return new PasswordModifyExtendedResult(messageID, ResultCode.SUCCESS, null, null, null, genPW, null);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            return new PasswordModifyExtendedResult(messageID, le.getResultCode(), ListenerMessages.ERR_PW_MOD_EXTOP_CANNOT_CHANGE_PW.get(userEntry.getDN(), le.getMessage()), null, null, null, null);
        }
    }
}

