/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.util;

import com.franciaflex.faxtomail.ui.swing.util.AbstractToolbarPopupUI;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.runtime.SwingUtil;

public abstract class AbstractToolbarPopupButton<UI extends AbstractToolbarPopupUI>
extends JToggleButton {
    private static final long serialVersionUID = 1L;
    protected final UI popup;
    protected boolean popupMoving;

    public AbstractToolbarPopupButton() {
        ImageIcon actionIcon = SwingUtil.createActionIcon((String)this.getActionIcon());
        this.setIcon(actionIcon);
        this.setDisabledIcon(actionIcon);
        this.popup = this.createNewPopup();
        ((Window)this.popup).addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                AbstractToolbarPopupButton.this.setSelected(true);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                AbstractToolbarPopupButton.this.setSelected(false);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                AbstractToolbarPopupButton.this.setSelected(false);
            }
        });
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (AbstractToolbarPopupButton.this.isSelected()) {
                    if (!((Component)AbstractToolbarPopupButton.this.popup).isVisible()) {
                        ((AbstractToolbarPopupUI)AbstractToolbarPopupButton.this.popup).openEditor(AbstractToolbarPopupButton.this);
                    }
                } else {
                    ((AbstractToolbarPopupUI)AbstractToolbarPopupButton.this.popup).closeEditor();
                }
            }
        });
        this.addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void ancestorMoved(HierarchyEvent e) {
                if (((Window)AbstractToolbarPopupButton.this.popup).isShowing()) {
                    Point point = new Point(AbstractToolbarPopupButton.this.getLocationOnScreen());
                    point.translate(-((Component)AbstractToolbarPopupButton.this.popup).getWidth() + AbstractToolbarPopupButton.this.getWidth(), AbstractToolbarPopupButton.this.getHeight());
                    AbstractToolbarPopupButton.this.popupMoving = true;
                    try {
                        ((Window)AbstractToolbarPopupButton.this.popup).setLocation(point);
                    }
                    finally {
                        AbstractToolbarPopupButton.this.popupMoving = false;
                    }
                }
            }
        });
    }

    protected abstract String getActionIcon();

    protected abstract UI createNewPopup();

    public void onCloseUI() {
        this.setSelected(false);
    }
}

