/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.util;

import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.MailField;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jaxx.runtime.SwingUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.table.ColumnIdentifier;

public class DemandeTableModel
extends AbstractTableModel {
    private static final Log log = LogFactory.getLog(DemandeTableModel.class);
    public static final Map<MailField, ColumnIdentifier<Email>> COLUMN_IDENTIFIERS = new HashMap<MailField, ColumnIdentifier<Email>>(){
        {
            this.put(MailField.SENDER, ColumnIdentifier.newReadOnlyId((String)"sender", (String)I18n.n((String)"faxtomail.demandeList.table.header.sender", (Object[])new Object[0]), (String)I18n.n((String)"faxtomail.demandeList.table.header.sender.tip", (Object[])new Object[0])));
            this.put(MailField.OBJECT, ColumnIdentifier.newReadOnlyId((String)"object", (String)I18n.n((String)"faxtomail.demandeList.table.header.object", (Object[])new Object[0]), (String)I18n.n((String)"faxtomail.demandeList.table.header.object.tip", (Object[])new Object[0])));
            this.put(MailField.RECEPTION_DATE, ColumnIdentifier.newReadOnlyId((String)"receptionDate", (String)I18n.n((String)"faxtomail.demandeList.table.header.receptionDate", (Object[])new Object[0]), (String)I18n.n((String)"faxtomail.demandeList.table.header.receptionDate.tip", (Object[])new Object[0])));
            this.put(MailField.RECIPIENT, ColumnIdentifier.newReadOnlyId((String)"recipient", (String)I18n.n((String)"faxtomail.demandeList.table.header.recipient", (Object[])new Object[0]), (String)I18n.n((String)"faxtomail.demandeList.table.header.recipient.tip", (Object[])new Object[0])));
            this.put(MailField.CLIENT_CODE, ColumnIdentifier.newReadOnlyId((String)"clientCode", (String)I18n.n((String)"faxtomail.demandeList.table.header.client", (Object[])new Object[0]), (String)I18n.n((String)"faxtomail.demandeList.table.header.client.tip", (Object[])new Object[0])));
            this.put(MailField.CLIENT_BRAND, ColumnIdentifier.newReadOnlyId((String)"clientBrand", (String)I18n.n((String)"faxtomail.demandeList.table.header.brand", (Object[])new Object[0]), (String)I18n.n((String)"faxtomail.demandeList.table.header.brand.tip", (Object[])new Object[0])));
            this.put(MailField.DEMAND_STATUS, ColumnIdentifier.newReadOnlyId((String)"demandStatus", (String)I18n.n((String)"faxtomail.demandeList.table.header.status", (Object[])new Object[0]), (String)I18n.n((String)"faxtomail.demandeList.table.header.status.tip", (Object[])new Object[0])));
            this.put(MailField.DEMAND_TYPE, ColumnIdentifier.newReadOnlyId((String)"demandType", (String)I18n.n((String)"faxtomail.demandeList.table.header.type", (Object[])new Object[0]), (String)I18n.n((String)"faxtomail.demandeList.table.header.type.tip", (Object[])new Object[0])));
            this.put(MailField.EDI_RETURN, ColumnIdentifier.newReadOnlyId((String)"ediError", (String)I18n.n((String)"faxtomail.demandeList.table.header.ediCodeNumber", (Object[])new Object[0]), (String)I18n.n((String)"faxtomail.demandeList.table.header.ediCodeNumber.tip", (Object[])new Object[0])));
            this.put(MailField.WAITING_STATE, ColumnIdentifier.newReadOnlyId((String)"waitingState", (String)I18n.n((String)"faxtomail.demandeList.table.header.waitingState", (Object[])new Object[0]), (String)I18n.n((String)"faxtomail.demandeList.table.header.waitingState.tip", (Object[])new Object[0])));
            this.put(MailField.TAKEN_BY, ColumnIdentifier.newReadOnlyId((String)"takenBy", (String)I18n.n((String)"faxtomail.demandeList.table.header.user", (Object[])new Object[0]), (String)I18n.n((String)"faxtomail.demandeList.table.header.user.tip", (Object[])new Object[0])));
            this.put(MailField.PRIORITY, ColumnIdentifier.newId((String)"priority", (String)I18n.n((String)"faxtomail.demandeList.table.header.priority", (Object[])new Object[0]), (String)I18n.n((String)"faxtomail.demandeList.table.header.priority.tip", (Object[])new Object[0])));
            this.put(MailField.PROJECT_REFERENCE, ColumnIdentifier.newReadOnlyId((String)"projectReference", (String)I18n.n((String)"faxtomail.demandeList.table.header.projectReference", (Object[])new Object[0]), (String)I18n.n((String)"faxtomail.demandeList.table.header.projectReference.tip", (Object[])new Object[0])));
            this.put(MailField.COMPANY_REFERENCE, ColumnIdentifier.newReadOnlyId((String)"companyReference", (String)I18n.n((String)"faxtomail.demandeList.table.header.companyReference", (Object[])new Object[0]), (String)I18n.n((String)"faxtomail.demandeList.table.header.companyReference.tip", (Object[])new Object[0])));
            this.put(MailField.REFERENCE, ColumnIdentifier.newReadOnlyId((String)"reference", (String)I18n.n((String)"faxtomail.demandeList.table.header.reference", (Object[])new Object[0]), (String)I18n.n((String)"faxtomail.demandeList.table.header.reference.tip", (Object[])new Object[0])));
            this.put(MailField.RANGE_ROW, ColumnIdentifier.newReadOnlyId((String)"rangeRow", (String)I18n.n((String)"faxtomail.demandeList.table.header.range", (Object[])new Object[0]), (String)I18n.n((String)"faxtomail.demandeList.table.header.range.tip", (Object[])new Object[0])));
            this.put(MailField.PF_NB, ColumnIdentifier.newReadOnlyId((String)"pfNb", (String)I18n.n((String)"faxtomail.demandeList.table.header.pfNb", (Object[])new Object[0]), (String)I18n.n((String)"faxtomail.demandeList.table.header.pfNb.tip", (Object[])new Object[0])));
            this.put(MailField.SAV_NB, ColumnIdentifier.newReadOnlyId((String)"savNb", (String)I18n.n((String)"faxtomail.demandeList.table.header.savNb", (Object[])new Object[0]), (String)I18n.n((String)"faxtomail.demandeList.table.header.savNb.tip", (Object[])new Object[0])));
            this.put(MailField.QUOTATION_NB, ColumnIdentifier.newReadOnlyId((String)"quotationNb", (String)I18n.n((String)"faxtomail.demandeList.table.header.quotationNb", (Object[])new Object[0]), (String)I18n.n((String)"faxtomail.demandeList.table.header.quotationNb.tip", (Object[])new Object[0])));
            this.put(MailField.REPLIES, ColumnIdentifier.newId((String)"replies", (String)I18n.n((String)"faxtomail.demandeList.table.header.replies", (Object[])new Object[0]), (String)I18n.n((String)"faxtomail.demandeList.table.header.replies.tip", (Object[])new Object[0])));
            this.put(MailField.ATTACHMENT, ColumnIdentifier.newId((String)"attachment", (String)I18n.n((String)"faxtomail.demandeList.table.header.attachment", (Object[])new Object[0]), (String)I18n.n((String)"faxtomail.demandeList.table.header.attachment.tip", (Object[])new Object[0])));
            this.put(MailField.GROUP, ColumnIdentifier.newId((String)"groupedDemandes", (String)I18n.n((String)"faxtomail.demandeList.table.header.emailGroup", (Object[])new Object[0]), (String)I18n.n((String)"faxtomail.demandeList.table.header.emailGroup.tip", (Object[])new Object[0])));
            this.put(MailField.LAST_ATTACHMENT_OPENING_IN_THIS_FOLDER_USER, ColumnIdentifier.newId((String)"lastAttachmentOpener", (String)I18n.n((String)"faxtomail.demandeList.table.header.lastAttachmentOpeningUser", (Object[])new Object[0]), (String)I18n.n((String)"faxtomail.demandeList.table.header.lastAttachmentOpeningUser.tip", (Object[])new Object[0])));
            this.put(MailField.COMMENT, ColumnIdentifier.newId((String)"comment", (String)I18n.n((String)"faxtomail.demandeList.table.header.comment", (Object[])new Object[0]), (String)I18n.n((String)"faxtomail.demandeList.table.header.comment.tip", (Object[])new Object[0])));
        }
    };
    protected List<DemandeUIModel> rows;
    protected Set<ColumnIdentifier<?>> noneEditableCols;
    protected final List<ColumnIdentifier<DemandeUIModel>> identifiers;

    public DemandeTableModel(TableColumnModelExt columnModel, MailField ... editableProperties) {
        this.identifiers = Lists.newArrayListWithCapacity((int)columnModel.getColumnCount());
        for (TableColumn tc : columnModel.getColumns(true)) {
            this.identifiers.add((ColumnIdentifier<DemandeUIModel>)((ColumnIdentifier)tc.getIdentifier()));
        }
        ArrayList<ColumnIdentifier<Email>> nonEditableColumns = new ArrayList<ColumnIdentifier<Email>>(COLUMN_IDENTIFIERS.values());
        for (MailField editableProperty : editableProperties) {
            nonEditableColumns.remove(COLUMN_IDENTIFIERS.get(editableProperty));
        }
        this.setNoneEditableCols(nonEditableColumns.toArray(new ColumnIdentifier[nonEditableColumns.size()]));
    }

    public DemandeUIModel createNewRow() {
        return new DemandeUIModel();
    }

    public final List<DemandeUIModel> getRows() {
        return this.rows;
    }

    public final void setRows(List<DemandeUIModel> data) {
        Preconditions.checkNotNull(data, (Object)"Data list can not be null.");
        this.rows = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Set " + data.size() + " row(s) in table model " + this));
        }
        this.rows = data;
        this.onRowsChanged(data);
        this.fireTableDataChanged();
    }

    public final void addNewRow() {
        DemandeUIModel newValue = this.createNewRow();
        this.addNewRow(newValue);
    }

    public final void addNewRow(DemandeUIModel newValue) {
        this.addNewRow(this.getRowCount(), newValue);
    }

    public final void addNewRow(int rowIndex, DemandeUIModel newValue) {
        Preconditions.checkNotNull((Object)newValue, (Object)"Row can not be null.");
        List<DemandeUIModel> data = this.getRows();
        Preconditions.checkNotNull(data, (Object)"Data list can not be null.");
        data.add(rowIndex, newValue);
        this.onRowAdded(rowIndex, newValue);
        this.fireTableRowsInserted(rowIndex, rowIndex);
    }

    public final void fireTableRowsInserted(DemandeUIModel newValue) {
        Preconditions.checkNotNull((Object)newValue, (Object)"Row can not be null.");
        int rowIndex = this.getRowIndex(newValue);
        this.fireTableRowsInserted(rowIndex, rowIndex);
    }

    public final int updateRow(DemandeUIModel row) {
        Preconditions.checkNotNull((Object)row, (Object)"Row can not be null.");
        List<DemandeUIModel> data = this.getRows();
        Preconditions.checkNotNull(data, (Object)"Data list can not be null.");
        int rowIndex = data.indexOf(row);
        this.fireTableRowsUpdated(rowIndex, rowIndex);
        return rowIndex;
    }

    public final DemandeUIModel removeRow(int rowIndex) {
        SwingUtil.ensureRowIndex((TableModel)this, (int)rowIndex);
        List<DemandeUIModel> data = this.getRows();
        DemandeUIModel result = data.remove(rowIndex);
        this.fireTableRowsDeleted(rowIndex, rowIndex);
        return result;
    }

    protected void onRowsChanged(List<DemandeUIModel> data) {
    }

    protected void onRowAdded(int rowIndex, DemandeUIModel newValue) {
    }

    public final int getRowIndex(DemandeUIModel row) {
        int result = this.rows == null ? -1 : this.rows.indexOf(row);
        return result;
    }

    public final DemandeUIModel getEntry(int rowIndex) {
        SwingUtil.ensureRowIndex((TableModel)this, (int)rowIndex);
        int rowCount = this.getRowCount();
        if (rowIndex > rowCount) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Error getting entry " + rowIndex + " int table model with " + rowCount + " items"));
            }
            return null;
        }
        List<DemandeUIModel> data = this.getRows();
        DemandeUIModel result = data == null ? null : data.get(rowIndex);
        return result;
    }

    public final void setNoneEditableCols(ColumnIdentifier<?> ... noneEditableCols) {
        this.noneEditableCols = Sets.newHashSet((Object[])noneEditableCols);
    }

    @Override
    public final int getRowCount() {
        return this.rows == null ? 0 : this.rows.size();
    }

    @Override
    public final int getColumnCount() {
        return this.identifiers.size();
    }

    @Override
    public final Object getValueAt(int rowIndex, int columnIndex) {
        DemandeUIModel entry = this.getEntry(rowIndex);
        ColumnIdentifier<DemandeUIModel> identifier = this.getIdentifier(columnIndex);
        Object result = identifier.getValue((Object)entry);
        return result;
    }

    @Override
    public final void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setValueAt " + aValue));
        }
        DemandeUIModel entry = this.getEntry(rowIndex);
        ColumnIdentifier<DemandeUIModel> identifier = this.getIdentifier(columnIndex);
        this.setValueAt(aValue, rowIndex, columnIndex, identifier, entry);
    }

    @Override
    public final boolean isCellEditable(int rowIndex, int columnIndex) {
        ColumnIdentifier<DemandeUIModel> identifier = this.getIdentifier(columnIndex);
        return this.isCellEditable(rowIndex, columnIndex, identifier);
    }

    protected void setValueAt(Object aValue, int rowIndex, int columnIndex, ColumnIdentifier<DemandeUIModel> propertyName, DemandeUIModel entry) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setValueAt " + aValue));
        }
        propertyName.setValue((Object)entry, aValue);
    }

    protected boolean isCellEditable(int rowIndex, int columnIndex, ColumnIdentifier<DemandeUIModel> propertyName) {
        DemandeUIModel entry = this.getEntry(rowIndex);
        boolean result = (COLUMN_IDENTIFIERS.get(MailField.ATTACHMENT).equals(propertyName) || COLUMN_IDENTIFIERS.get(MailField.REPLIES).equals(propertyName) || entry.isEditable()) && !this.noneEditableCols.contains(propertyName);
        return result;
    }

    public final void fireTableCellUpdated(int rowIndex, ColumnIdentifier<DemandeUIModel> ... identifiers) {
        for (ColumnIdentifier<DemandeUIModel> identifier : identifiers) {
            int columnIndex = this.identifiers.indexOf(identifier);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    public final void fireTableRowUpdatedShell(Set<DemandeUIModel> shell) {
        int minRowIndex1 = this.getColumnCount();
        int maxRowIndex1 = 0;
        for (DemandeUIModel r : shell) {
            int rowIndex1 = this.getRowIndex(r);
            minRowIndex1 = Math.min(minRowIndex1, rowIndex1);
            maxRowIndex1 = Math.max(maxRowIndex1, rowIndex1);
        }
        this.fireTableRowsUpdated(minRowIndex1, maxRowIndex1);
    }

    protected void collectShell(DemandeUIModel row, Set<DemandeUIModel> collectedRows) {
        collectedRows.add(row);
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.getIdentifier(columnIndex).getPropertyName();
    }

    protected ColumnIdentifier<DemandeUIModel> getIdentifier(int columnIndex) {
        ColumnIdentifier<DemandeUIModel> identifier = this.identifiers.get(columnIndex);
        return identifier;
    }

    public int getColumnIndex(final String propertyName) {
        return Iterables.indexOf(this.identifiers, (Predicate)new Predicate<ColumnIdentifier<DemandeUIModel>>(){

            public boolean apply(ColumnIdentifier<DemandeUIModel> input) {
                return ObjectUtils.equals((Object)propertyName, (Object)input.getPropertyName());
            }
        });
    }

    public Pair<Integer, Integer> getCell(DemandeUIModel row, String propertyName) {
        int rowIndex = this.getRowIndex(row);
        int columnIndex = this.getColumnIndex(propertyName);
        Pair cell = Pair.of((Object)rowIndex, (Object)columnIndex);
        return cell;
    }

    public void moveUp(DemandeUIModel row) {
        int rowIndex = this.getRowIndex(row);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will move up row of index: " + rowIndex));
        }
        this.rows.remove(rowIndex);
        this.rows.add(rowIndex - 1, row);
        this.fireTableRowsUpdated(rowIndex - 1, rowIndex);
    }

    public void moveDown(DemandeUIModel row) {
        int rowIndex = this.getRowIndex(row);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will move down row of index: " + rowIndex));
        }
        this.rows.remove(rowIndex);
        this.rows.add(rowIndex + 1, row);
        this.fireTableRowsUpdated(rowIndex, rowIndex + 1);
    }

    public boolean isFirstRow(DemandeUIModel row) {
        int rowIndex = this.getRowIndex(row);
        return rowIndex == 0;
    }

    public boolean isLastRow(DemandeUIModel row) {
        int rowIndex = this.getRowIndex(row);
        return rowIndex == this.getRowCount() - 1;
    }
}

