/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.event.TableColumnModelExtListener;
import org.jdesktop.swingx.plaf.ComponentAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.TableHeaderAddon;
import org.jdesktop.swingx.sort.SortController;
import org.jdesktop.swingx.table.TableColumnExt;

public class JXTableHeader
extends JTableHeader
implements TableColumnModelExtListener {
    private static final Logger LOG = Logger.getLogger(JXTableHeader.class.getName());
    private transient PropertyChangeListener tablePropertyChangeListener;
    private boolean resortsOnDoubleClick;
    private MouseInputListener headerListener;

    public JXTableHeader() {
    }

    public JXTableHeader(TableColumnModel columnModel) {
        super(columnModel);
    }

    @Override
    public void setTable(JTable table) {
        this.uninstallTable();
        super.setTable(table);
        this.installTable();
        if (this.getXTable() != null) {
            this.installHeaderListener();
        } else {
            this.uninstallHeaderListener();
        }
    }

    protected void installTable() {
        this.updateEnabledFromTable();
        if (this.getTable() == null) {
            return;
        }
        this.getTable().addPropertyChangeListener(this.getTablePropertyChangeListener());
    }

    protected void updateEnabledFromTable() {
        this.setEnabled(this.getTable() != null ? this.getTable().isEnabled() : true);
    }

    protected void uninstallTable() {
        if (this.getTable() == null) {
            return;
        }
        this.getTable().removePropertyChangeListener(this.getTablePropertyChangeListener());
    }

    @Override
    public void columnPropertyChange(PropertyChangeEvent event) {
        if (this.isColumnEvent(event)) {
            return;
        }
        this.resizeAndRepaint();
    }

    protected boolean isColumnEvent(PropertyChangeEvent event) {
        return "width".equals(event.getPropertyName()) || "preferredWidth".equals(event.getPropertyName()) || "visible".equals(event.getPropertyName());
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        String columnToolTipText = this.getColumnToolTipText(event);
        return columnToolTipText != null ? columnToolTipText : super.getToolTipText(event);
    }

    protected String getColumnToolTipText(MouseEvent event) {
        if (this.getXTable() == null) {
            return null;
        }
        int column = this.columnAtPoint(event.getPoint());
        if (column < 0) {
            return null;
        }
        TableColumnExt columnExt = this.getXTable().getColumnExt(column);
        return columnExt != null ? columnExt.getToolTipText() : null;
    }

    public JXTable getXTable() {
        if (!(this.getTable() instanceof JXTable)) {
            return null;
        }
        return (JXTable)this.getTable();
    }

    public boolean getResortsOnDoubleClick() {
        return this.getXTable() != null && this.resortsOnDoubleClick;
    }

    public void setResortsOnDoubleClick(boolean resortsOnDoubleClick) {
        boolean old = this.getResortsOnDoubleClick();
        this.resortsOnDoubleClick = resortsOnDoubleClick;
        this.firePropertyChange("resortsOnDoubleClick", old, this.getResortsOnDoubleClick());
    }

    public TableCellRenderer getCellRenderer(int columnIndex) {
        TableCellRenderer renderer = this.getColumnModel().getColumn(columnIndex).getHeaderRenderer();
        return renderer != null ? renderer : this.getDefaultRenderer();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension pref = super.getPreferredSize();
        pref = this.getPreferredSize(pref);
        pref.height = this.getMinimumHeight(pref.height);
        return pref;
    }

    protected Dimension getPreferredSize(Dimension pref) {
        int height = pref.height;
        for (int i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
            TableCellRenderer renderer = this.getCellRenderer(i);
            Component comp = renderer.getTableCellRendererComponent(this.table, this.getColumnModel().getColumn(i).getHeaderValue(), false, false, -1, i);
            height = Math.max(height, comp.getPreferredSize().height);
        }
        pref.height = height;
        return pref;
    }

    protected int getMinimumHeight(int height) {
        if (height == 0) {
            TableCellRenderer renderer = this.getDefaultRenderer();
            Component comp = renderer.getTableCellRendererComponent(this.getTable(), "dummy", false, false, -1, -1);
            height = comp.getPreferredSize().height;
        }
        return height;
    }

    @Override
    public void setDraggedColumn(TableColumn column) {
        if (this.getDraggedColumn() == column) {
            return;
        }
        TableColumn old = this.getDraggedColumn();
        super.setDraggedColumn(column);
        this.firePropertyChange("draggedColumn", old, this.getDraggedColumn());
    }

    @Override
    public void setResizingColumn(TableColumn aColumn) {
        if (this.getResizingColumn() == aColumn) {
            return;
        }
        TableColumn old = this.getResizingColumn();
        super.setResizingColumn(aColumn);
        this.firePropertyChange("resizingColumn", old, this.getResizingColumn());
    }

    @Override
    public void setDraggedDistance(int distance) {
        int old = this.getDraggedDistance();
        super.setDraggedDistance(distance);
        this.firePropertyChange("draggedDistance", old, this.getDraggedDistance());
        if (!this.getAutoscrolls() || this.getXTable() == null) {
            return;
        }
        TableColumn column = this.getDraggedColumn();
        if (column != null) {
            this.getXTable().scrollColumnToVisible(this.getViewIndexForColumn(column));
        }
    }

    @Override
    public TableColumn getDraggedColumn() {
        return this.isVisible(this.draggedColumn) ? this.draggedColumn : null;
    }

    private boolean isVisible(TableColumn column) {
        return this.getViewIndexForColumn(column) >= 0;
    }

    private int getViewIndexForColumn(TableColumn aColumn) {
        if (aColumn == null) {
            return -1;
        }
        TableColumnModel cm = this.getColumnModel();
        for (int column = 0; column < cm.getColumnCount(); ++column) {
            if (cm.getColumn(column) != aColumn) continue;
            return column;
        }
        return -1;
    }

    protected PropertyChangeListener getTablePropertyChangeListener() {
        if (this.tablePropertyChangeListener == null) {
            this.tablePropertyChangeListener = this.createTablePropertyChangeListener();
        }
        return this.tablePropertyChangeListener;
    }

    protected PropertyChangeListener createTablePropertyChangeListener() {
        PropertyChangeListener l = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("enabled".equals(evt.getPropertyName())) {
                    JXTableHeader.this.updateEnabledFromTable();
                }
            }
        };
        return l;
    }

    protected void installHeaderListener() {
        if (this.headerListener == null) {
            this.headerListener = new HeaderListener();
            this.addMouseListener(this.headerListener);
            this.addMouseMotionListener(this.headerListener);
        }
    }

    protected void uninstallHeaderListener() {
        if (this.headerListener != null) {
            this.removeMouseListener(this.headerListener);
            this.removeMouseMotionListener(this.headerListener);
            this.headerListener = null;
        }
    }

    static {
        LookAndFeelAddons.contribute((ComponentAddon)new TableHeaderAddon());
    }

    private class HeaderListener
    implements MouseInputListener,
    Serializable {
        private TableColumn cachedResizingColumn;
        private SortOrder[] cachedSortOrderCycle;
        private int sortColumn = -1;

        private HeaderListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.shouldIgnore(e)) {
                return;
            }
            this.doResize(e);
            this.doDoubleSort(e);
            this.uncacheResizingColumn();
        }

        private void doDoubleSort(MouseEvent e) {
            if (!this.hasCachedSortColumn() || e.getClickCount() % 2 == 1) {
                return;
            }
            JXTableHeader.this.getXTable().toggleSortOrder(this.sortColumn);
            this.uncacheSortColumn();
        }

        private boolean hasCachedSortColumn() {
            return this.sortColumn >= 0;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.resetToggleSortOrder(e);
            if (this.shouldIgnore(e)) {
                return;
            }
            this.cacheResizingColumn(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.shouldIgnore(e)) {
                return;
            }
            this.cacheResizingColumn(e);
            this.cacheSortColumn(e);
            if (this.isInResizeRegion(e) && e.getClickCount() % 2 == 1) {
                this.disableToggleSortOrder(e);
            }
        }

        private void cacheSortColumn(MouseEvent e) {
            if (!this.canCacheSortColumn(e)) {
                this.uncacheSortColumn();
            }
            if (e.getClickCount() % 2 == 1) {
                int primarySortIndex;
                int column = JXTableHeader.this.columnAtPoint(e.getPoint());
                if (column >= 0 && (primarySortIndex = JXTableHeader.this.getXTable().getSortedColumnIndex()) == column) {
                    column = -1;
                }
                this.sortColumn = column;
            }
        }

        private void uncacheSortColumn() {
            this.sortColumn = -1;
        }

        private boolean canCacheSortColumn(MouseEvent e) {
            return this.hasSortController() && !this.isInResizeRegion(e) && JXTableHeader.this.getResortsOnDoubleClick();
        }

        private boolean shouldIgnore(MouseEvent e) {
            return !SwingUtilities.isLeftMouseButton(e) || !JXTableHeader.this.table.isEnabled();
        }

        private void doResize(MouseEvent e) {
            if (e.getClickCount() != 2) {
                return;
            }
            int column = JXTableHeader.this.getViewIndexForColumn(this.cachedResizingColumn);
            if (column >= 0) {
                JXTableHeader.this.getXTable().packColumn(column, 5);
            }
        }

        private void disableToggleSortOrder(MouseEvent e) {
            if (!this.hasSortController()) {
                return;
            }
            SortController controller = (SortController)((Object)JXTableHeader.this.getXTable().getRowSorter());
            this.cachedSortOrderCycle = controller.getSortOrderCycle();
            controller.setSortOrderCycle(new SortOrder[0]);
        }

        private boolean hasSortController() {
            return JXTableHeader.this.getXTable().getRowSorter() instanceof SortController;
        }

        private void resetToggleSortOrder(MouseEvent e) {
            if (this.cachedSortOrderCycle == null) {
                return;
            }
            ((SortController)((Object)JXTableHeader.this.getXTable().getRowSorter())).setSortOrderCycle(this.cachedSortOrderCycle);
            this.cachedSortOrderCycle = null;
        }

        private void cacheResizingColumn(MouseEvent e) {
            TableColumn column = JXTableHeader.this.getResizingColumn();
            if (column != null) {
                this.cachedResizingColumn = column;
            }
        }

        private void uncacheResizingColumn() {
            this.cachedResizingColumn = null;
        }

        private boolean isInResizeRegion(MouseEvent e) {
            return this.cachedResizingColumn != null;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.uncacheSortColumn();
            this.uncacheResizingColumn();
            this.resetToggleSortOrder(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.uncacheSortColumn();
            this.uncacheResizingColumn();
            this.resetToggleSortOrder(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.uncacheSortColumn();
            this.resetToggleSortOrder(e);
        }
    }
}

