/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.util;

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.DemandStatus;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.HasLabel;
import com.franciaflex.faxtomail.persistence.entities.HistoryType;
import com.franciaflex.faxtomail.persistence.entities.MailField;
import com.franciaflex.faxtomail.persistence.entities.Priority;
import com.franciaflex.faxtomail.persistence.entities.RangeRow;
import com.franciaflex.faxtomail.persistence.entities.Reply;
import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.actions.ShowDemandeAction;
import com.franciaflex.faxtomail.ui.swing.content.attachment.AttachmentCellEditor;
import com.franciaflex.faxtomail.ui.swing.content.attachment.AttachmentCellRenderer;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.replies.RepliesCellEditor;
import com.franciaflex.faxtomail.ui.swing.content.demande.replies.RepliesCellRenderer;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailUIHandler;
import com.franciaflex.faxtomail.ui.swing.util.DemandeTableModel;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.decorator.Decorator;
import org.nuiton.jaxx.application.swing.action.AbstractApplicationAction;
import org.nuiton.jaxx.application.swing.table.AbstractApplicationTableModel;
import org.nuiton.validator.NuitonValidatorFactory;
import org.nuiton.validator.NuitonValidatorResult;
import org.nuiton.validator.NuitonValidatorScope;

public abstract class AbstractFaxToMailDemandListHandler<M, UI extends FaxToMailUI<M, ?>>
extends AbstractFaxToMailUIHandler<M, UI> {
    private static final Log log = LogFactory.getLog(AbstractFaxToMailDemandListHandler.class);

    public void initDemandeTable(final JXTable table, boolean sortable) {
        this.populateColumnModel(table, sortable);
        table.getTableHeader().setReorderingAllowed(false);
        Highlighter highlighter = new Highlighter(){

            public Component highlight(Component renderer, ComponentAdapter adapter) {
                Font font;
                boolean highlight;
                int viewRow = adapter.row;
                int modelRow = adapter.convertRowIndexToModel(viewRow);
                DemandeUIModel row = (DemandeUIModel)((AbstractApplicationTableModel)table.getModel()).getEntry(modelRow);
                boolean bl = highlight = row.getTakenBy() == null;
                if (highlight) {
                    font = renderer.getFont();
                    renderer.setFont(font.deriveFont(1));
                }
                boolean bl2 = highlight = row.getArchiveDate() != null;
                if (highlight) {
                    font = renderer.getFont();
                    renderer.setFont(font.deriveFont(2));
                    renderer.setForeground(adapter.isSelected() ? Color.WHITE : new Color(96, 96, 96));
                }
                return renderer;
            }

            public void addChangeListener(ChangeListener l) {
            }

            public void removeChangeListener(ChangeListener l) {
            }

            public ChangeListener[] getChangeListeners() {
                return new ChangeListener[0];
            }
        };
        table.addHighlighter(highlighter);
        HighlightPredicate rowIsInvalidPredicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                int viewRow = adapter.row;
                int modelRow = adapter.convertRowIndexToModel(viewRow);
                DemandeUIModel row = (DemandeUIModel)((AbstractApplicationTableModel)table.getModel()).getEntry(modelRow);
                return !row.isValid() && row.getTakenBy() != null;
            }
        };
        Color color = new Color(255, 51, 51);
        table.addHighlighter((Highlighter)new ColorHighlighter(rowIsInvalidPredicate, color, Color.WHITE, color.darker(), Color.WHITE));
        table.addMouseListener(this.getDataTableMouseListener());
    }

    protected abstract List<MailField> getColumns();

    public String populateColumnModel(JXTable table, boolean sortable) {
        ArrayList columns = this.getColumns();
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        if (CollectionUtils.isEmpty(columns)) {
            columns = Lists.newArrayList((Object[])MailField.getTableFields());
        }
        for (MailField columnName : columns) {
            TableCellRenderer tableCellRenderer;
            if (MailField.PRIORITY.equals((Object)columnName)) {
                this.addComboDataColumnToModel((TableColumnModel)columnModel, DemandeTableModel.COLUMN_IDENTIFIERS.get(columnName), this.getDecorator(Priority.class, null), this.getContext().getReferentielService().getAllPriority()).setSortable(sortable);
                continue;
            }
            if (MailField.ATTACHMENT.equals((Object)columnName)) {
                this.addColumnToModel((TableColumnModel)columnModel, AttachmentCellEditor.newEditor((FaxToMailUI)this.ui), AttachmentCellRenderer.newRender(this.getDecorator(Attachment.class, null)), DemandeTableModel.COLUMN_IDENTIFIERS.get(columnName)).setSortable(sortable);
                continue;
            }
            if (MailField.REPLIES.equals((Object)columnName)) {
                this.addColumnToModel((TableColumnModel)columnModel, RepliesCellEditor.newEditor((FaxToMailUI)this.ui), RepliesCellRenderer.newRender(this.getDecorator(Reply.class, null)), DemandeTableModel.COLUMN_IDENTIFIERS.get(columnName)).setSortable(sortable);
                continue;
            }
            switch (columnName) {
                case RECEPTION_DATE: {
                    tableCellRenderer = this.newTableCellRender(Date.class);
                    break;
                }
                case PF_NB: {
                    tableCellRenderer = new QuantityTableCellRenderer(new Function<RangeRow, Integer>(){

                        public Integer apply(RangeRow input) {
                            return input.getProductQuantity();
                        }
                    });
                    break;
                }
                case SAV_NB: {
                    tableCellRenderer = new QuantityTableCellRenderer(new Function<RangeRow, Integer>(){

                        public Integer apply(RangeRow input) {
                            return input.getSavQuantity();
                        }
                    });
                    break;
                }
                case DEMAND_STATUS: {
                    tableCellRenderer = this.newTableCellRender(DemandStatus.class);
                    break;
                }
                case DEMAND_TYPE: 
                case ETAT_ATTENTE: {
                    tableCellRenderer = this.newTableCellRender(HasLabel.class);
                    break;
                }
                case TAKEN_BY: 
                case LAST_ATTACHMENT_OPENING_IN_THIS_FOLDER_USER: {
                    tableCellRenderer = this.newTableCellRender(FaxToMailUser.class);
                    break;
                }
                default: {
                    tableCellRenderer = this.newTableCellRender((Decorator)new Decorator<Object>(Object.class){

                        public String toString(Object bean) {
                            return bean == null ? "" : bean.toString();
                        }
                    });
                }
            }
            this.addColumnToModel((TableColumnModel)columnModel, null, tableCellRenderer, DemandeTableModel.COLUMN_IDENTIFIERS.get(columnName)).setSortable(sortable);
        }
        DemandeTableModel tableModel = new DemandeTableModel((TableColumnModelExt)columnModel, this.getEditableTableProperties());
        table.setModel((TableModel)((Object)tableModel));
        table.setColumnModel((TableColumnModel)columnModel);
        return StringUtils.join((Iterable)columns, (String)"-");
    }

    protected MouseListener getDataTableMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    JXTable table = (JXTable)evt.getSource();
                    int rowIndex = table.getSelectedRow();
                    if (rowIndex < 0 || rowIndex >= table.getRowCount()) {
                        return;
                    }
                    rowIndex = table.convertRowIndexToModel(rowIndex);
                    AbstractApplicationTableModel tableModel = (AbstractApplicationTableModel)table.getModel();
                    DemandeUIModel selectedEmail = (DemandeUIModel)tableModel.getEntry(rowIndex);
                    AbstractFaxToMailDemandListHandler.this.onDoubleClickOnDemande(selectedEmail);
                    FaxToMailUIContext context = AbstractFaxToMailDemandListHandler.this.getContext();
                    Email email = context.getEmailService().addToHistory(selectedEmail.getTopiaId(), HistoryType.OPENING, context.getCurrentUser(), new Date(), new String[0]);
                    selectedEmail.fromEntity(email);
                    AbstractFaxToMailDemandListHandler.this.openDemand(selectedEmail);
                }
            }
        };
    }

    public void autoSelectRowInTable(MouseEvent e, JPopupMenu popup) {
        boolean rightClick = SwingUtilities.isRightMouseButton(e);
        if (rightClick) {
            Point p = e.getPoint();
            JXTable source = (JXTable)e.getSource();
            int[] selectedRows = source.getSelectedRows();
            int rowIndex = source.rowAtPoint(p);
            if (rowIndex == -1 || !ArrayUtils.contains((int[])selectedRows, (int)rowIndex)) {
                source.clearSelection();
            }
        }
        super.autoSelectRowInTable(e, popup);
    }

    protected abstract MailField[] getEditableTableProperties();

    protected void onDoubleClickOnDemande(DemandeUIModel selectedEmail) {
    }

    protected void openDemand(DemandeUIModel selectedEmail) {
        FaxToMailUIContext context = this.getContext();
        context.setCurrentEmail(selectedEmail);
        context.getActionEngine().runAction((AbstractApplicationAction)new ShowDemandeAction(context.getMainUI().getHandler()));
    }

    public boolean isDemandeValid(DemandeUIModel d) {
        NuitonValidatorResult result = NuitonValidatorFactory.newValidator(DemandeUIModel.class, (NuitonValidatorScope[])new NuitonValidatorScope[0]).validate((Object)d);
        return result.isValid();
    }

    public class QuantityTableCellRenderer
    extends DefaultTableCellRenderer {
        protected Function<RangeRow, Integer> getQuantityFunction;

        public QuantityTableCellRenderer(Function<RangeRow, Integer> getQuantityFunction) {
            this.getQuantityFunction = getQuantityFunction;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasfocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasfocus, row, column);
            AbstractApplicationTableModel tableModel = (AbstractApplicationTableModel)table.getModel();
            int rowInModel = table.convertRowIndexToModel(row);
            DemandeUIModel demande = (DemandeUIModel)tableModel.getEntry(rowInModel);
            String tooltipText = null;
            ArrayList<String> ranges = new ArrayList<String>();
            Collection<RangeRow> rangeRows = demande.getRangeRow();
            for (RangeRow rangeRow : rangeRows) {
                Integer qty = (Integer)this.getQuantityFunction.apply((Object)rangeRow);
                if (qty == null || qty <= 0) continue;
                ranges.add(rangeRow.getRange().getLabel() + " : " + qty);
            }
            if (!ranges.isEmpty()) {
                tooltipText = "<html><body>" + StringUtils.join(ranges, (String)"<br/>") + "</body></html>";
            }
            this.setToolTipText(tooltipText);
            return this;
        }
    }
}

