/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.attachment;

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.persistence.entities.AttachmentImpl;
import com.franciaflex.faxtomail.ui.swing.content.MainUI;
import com.franciaflex.faxtomail.ui.swing.content.attachment.AttachmentEditorUI;
import com.franciaflex.faxtomail.ui.swing.content.attachment.AttachmentEditorUIModel;
import com.franciaflex.faxtomail.ui.swing.content.attachment.AttachmentItem;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorUI;
import com.franciaflex.faxtomail.ui.swing.util.AbstractToolbarPopupHandler;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections4.CollectionUtils;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.FileUtil;

public class AttachmentEditorUIHandler
extends AbstractToolbarPopupHandler<AttachmentEditorUIModel, AttachmentEditorUI> {
    public static final List<String> EDITABLE_EXTENSIONS = Lists.newArrayList((Object[])new String[]{"PDF", "PNG", "JPG", "JPEG", "GIF", "TIF", "BMP", "TXT"});

    @Override
    public void afterInit(AttachmentEditorUI ui) {
        ui.getFile().setDialogOwner((JDialog)ui);
        super.afterInit(ui);
        this.initTable(ui.getAttachments());
        ((AttachmentEditorUIModel)((Object)this.getModel())).addPropertyChangeListener("attachment", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AbstractTableModel tableModel = (AbstractTableModel)((AttachmentEditorUI)AttachmentEditorUIHandler.this.getUI()).getAttachments().getModel();
                tableModel.fireTableDataChanged();
            }
        });
    }

    protected void initTable(JXTable table) {
        AbstractTableModel attachmentTableModel = new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return CollectionUtils.size(((AttachmentEditorUIModel)((Object)AttachmentEditorUIHandler.this.getModel())).getAttachment());
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return Iterables.get(((AttachmentEditorUIModel)((Object)AttachmentEditorUIHandler.this.getModel())).getAttachment(), (int)rowIndex);
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return true;
            }
        };
        attachmentTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ((AttachmentEditorUI)AttachmentEditorUIHandler.this.getUI()).pack();
            }
        });
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        TableColumn column = new TableColumn();
        column.setCellRenderer(new AttachmentItemRenderer());
        column.setCellEditor(new AttachmentItemEditor());
        columnModel.addColumn(column);
        table.setModel((TableModel)attachmentTableModel);
        table.setColumnModel((TableColumnModel)columnModel);
        table.addHighlighter(HighlighterFactory.createAlternateStriping());
    }

    protected JComponent getComponentToFocus() {
        return ((AttachmentEditorUI)this.getUI()).getFile();
    }

    public void onCloseUI() {
    }

    public SwingValidator<AttachmentEditorUIModel> getValidator() {
        return null;
    }

    public void addAttachment() {
        AttachmentImpl attachment = new AttachmentImpl();
        attachment.setAddedByUser(true);
        File file = ((AttachmentEditorUI)this.ui).getFile().getSelectedFile();
        if (file != null) {
            try {
                FileInputStream is = new FileInputStream(file);
                AttachmentFile attachmentFile = this.getContext().getEmailService().getAttachmentFileFromStream((InputStream)is);
                attachmentFile.setFilename(file.getName());
                attachment.setOriginalFile(attachmentFile);
            }
            catch (Exception e) {
                this.getContext().getErrorHelper().showErrorDialog(I18n.t((String)"swing.error.cannot.copy.file", (Object[])new Object[0]), (Throwable)e);
            }
            ((AttachmentEditorUIModel)((Object)this.getModel())).addAttachment((Attachment)attachment);
            this.resetFields();
        }
    }

    protected void resetFields() {
        ((AttachmentEditorUI)this.ui).getFile().setSelectedFilePath(null);
    }

    public void openAttachment(Attachment attachment) {
        ((AttachmentEditorUIModel)((Object)this.getModel())).fireAttachmentOpened(attachment, true);
        File file = attachment.getOriginalFile().getFile();
        Desktop desktop = FaxToMailUIUtil.getDesktopForOpen();
        try {
            desktop.open(file);
        }
        catch (IOException e) {
            this.getContext().getErrorHelper().showErrorDialog(I18n.t((String)"swing.error.cannot.open.file", (Object[])new Object[0]));
        }
    }

    public void editAttachment(Attachment attachment) {
        AttachmentEditorUIModel model = (AttachmentEditorUIModel)((Object)this.getModel());
        AttachmentFile attachmentFile = attachment.getEditedFile();
        if (attachmentFile == null) {
            model.fireAttachmentOpened(attachment, true);
            attachmentFile = attachment.getOriginalFile();
        } else {
            model.fireAttachmentOpened(attachment, false);
        }
        File file = attachmentFile.getFile();
        if (model.isEditable()) {
            String extension = FileUtil.extension((String)attachmentFile.getFilename(), (String[])new String[0]);
            if (model.isEditable() && EDITABLE_EXTENSIONS.contains(extension.toUpperCase())) {
                MainUI mainUI = this.getContext().getMainUI();
                mainUI.setCursor(Cursor.getPredefinedCursor(3));
                PDFEditorUI dialogContent = new PDFEditorUI((FaxToMailUI)this.ui);
                dialogContent.getModel().fromEntity(attachment);
                mainUI.setCursor(Cursor.getDefaultCursor());
                this.openDialog(dialogContent, file.getName(), mainUI.getSize());
                dialogContent.getModel().toEntity(attachment);
            } else {
                Desktop desktop = FaxToMailUIUtil.getDesktopForOpen();
                try {
                    desktop.open(file);
                }
                catch (IOException e) {
                    this.getContext().getErrorHelper().showErrorDialog(I18n.t((String)"swing.error.cannot.open.file", (Object[])new Object[0]));
                }
            }
        } else {
            Desktop desktop = FaxToMailUIUtil.getDesktopForBrowse();
            try {
                desktop.open(file);
            }
            catch (IOException e) {
                this.getContext().getErrorHelper().showErrorDialog(I18n.t((String)"swing.error.cannot.open.file", (Object[])new Object[0]));
            }
        }
    }

    public void removeAttachment(AttachmentItem attachmentItem) {
        Attachment attachment = attachmentItem.getAttachment();
        boolean hackDialog = ((AttachmentEditorUI)this.ui).isAlwaysOnTop();
        if (hackDialog) {
            ((AttachmentEditorUI)this.ui).setAlwaysOnTop(false);
        }
        int answer = JOptionPane.showConfirmDialog((Component)this.ui, I18n.t((String)"faxtomail.attachmentEditor.deleteAttachment.message", (Object[])new Object[]{attachment.getOriginalFile().getFilename()}), I18n.t((String)"faxtomail.attachmentEditor.deleteAttachment.title", (Object[])new Object[0]), 0);
        if (hackDialog) {
            ((AttachmentEditorUI)this.ui).setAlwaysOnTop(true);
        }
        if (answer == 0) {
            ((AttachmentEditorUI)this.ui).getAttachments().getCellEditor().stopCellEditing();
            ((AttachmentEditorUIModel)((Object)this.getModel())).removeAttachment(attachment);
            ((AttachmentEditorUI)this.ui).pack();
        }
    }

    public boolean isAttachmentEditable(Attachment attachment) {
        String extension = FileUtil.extension((String)attachment.getOriginalFile().getFilename(), (String[])new String[0]);
        return EDITABLE_EXTENSIONS.contains(extension.toUpperCase());
    }

    public boolean isAttachmentRemovable(Attachment attachment) {
        return attachment != null && attachment.getTopiaId() == null;
    }

    protected class AttachmentItemEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        protected AttachmentItem attachmentItem = new AttachmentItem();

        public AttachmentItemEditor() {
            this.attachmentItem.setHandler(AttachmentEditorUIHandler.this);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Attachment attachment = (Attachment)value;
            this.attachmentItem.setAttachment(attachment);
            if (attachment != null) {
                JLabel label = this.attachmentItem.getAttachmentNameLabel();
                String actionIconName = Boolean.TRUE.equals(attachment.getAddedByUser()) ? "user" : "email";
                ImageIcon icon = SwingUtil.createActionIcon((String)actionIconName);
                label.setIcon(icon);
            }
            this.attachmentItem.setEditable(((AttachmentEditorUIModel)((Object)AttachmentEditorUIHandler.this.getModel())).isEditable());
            return this.attachmentItem;
        }

        @Override
        public Object getCellEditorValue() {
            return this.attachmentItem.getAttachment();
        }
    }

    protected class AttachmentItemRenderer
    extends AttachmentItem
    implements TableCellRenderer {
        public AttachmentItemRenderer() {
            this.setHandler(AttachmentEditorUIHandler.this);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Attachment attachment = (Attachment)value;
            this.setAttachment(attachment);
            if (attachment != null) {
                JLabel label = this.getAttachmentNameLabel();
                String actionIconName = Boolean.TRUE.equals(attachment.getAddedByUser()) ? "user" : "email";
                ImageIcon icon = SwingUtil.createActionIcon((String)actionIconName);
                label.setIcon(icon);
            }
            this.setEditable(((AttachmentEditorUIModel)((Object)AttachmentEditorUIHandler.this.getModel())).isEditable());
            return this;
        }
    }
}

