/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing;

import com.franciaflex.faxtomail.FaxToMailConfiguration;
import com.franciaflex.faxtomail.persistence.RessourceClassLoader;
import com.franciaflex.faxtomail.persistence.entities.Configuration;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailTopiaApplicationContext;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailTopiaPersistenceContext;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.services.DecoratorService;
import com.franciaflex.faxtomail.services.FaxToMailServiceContext;
import com.franciaflex.faxtomail.services.service.ConfigurationService;
import com.franciaflex.faxtomail.services.service.EmailService;
import com.franciaflex.faxtomail.services.service.InitFaxToMailService;
import com.franciaflex.faxtomail.services.service.MailFolderService;
import com.franciaflex.faxtomail.services.service.ReferentielService;
import com.franciaflex.faxtomail.services.service.UserService;
import com.franciaflex.faxtomail.services.service.ValidationService;
import com.franciaflex.faxtomail.ui.swing.FaxToMailActionFactory;
import com.franciaflex.faxtomail.ui.swing.FaxToMailScreen;
import com.franciaflex.faxtomail.ui.swing.content.MainUI;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.search.SearchUIModel;
import com.franciaflex.faxtomail.ui.swing.util.UIMessageNotifier;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.session.BeanDoubleListState;
import jaxx.runtime.swing.session.BeanFilterableComboBoxState;
import jaxx.runtime.swing.session.SwingSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.beans.AbstractBean;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.init.ClassPathI18nInitializer;
import org.nuiton.i18n.init.I18nInitializer;
import org.nuiton.jaxx.application.ApplicationConfiguration;
import org.nuiton.jaxx.application.swing.ApplicationUIContext;
import org.nuiton.jaxx.application.swing.action.ApplicationActionEngine;
import org.nuiton.jaxx.application.swing.action.ApplicationActionFactory;
import org.nuiton.jaxx.application.swing.action.ApplicationActionUI;
import org.nuiton.jaxx.application.swing.util.ApplicationErrorHelper;
import org.nuiton.util.converter.ConverterUtil;

public class FaxToMailUIContext
extends AbstractBean
implements Closeable,
UIMessageNotifier,
ApplicationUIContext {
    private static final Log log = LogFactory.getLog(FaxToMailUIContext.class);
    public static final String PROPERTY_SCREEN = "screen";
    public static final String PROPERTY_LOCALE = "locale";
    public static final Set<String> PROPERTIES_TO_SAVE = Sets.newHashSet((Object[])new String[]{"locale"});
    public static final String PROPERTY_BUSY = "busy";
    public static final String PROPERTY_HIDE_BODY = "hideBody";
    private static FaxToMailUIContext applicationContext;
    protected final FaxToMailConfiguration config;
    protected final RessourceClassLoader resourceLoader;
    protected final FaxToMailServiceContext serviceContext;
    protected final SwingSession swingSession;
    protected final ApplicationErrorHelper errorHelper;
    protected FaxToMailScreen screen;
    protected Locale locale;
    protected boolean busy;
    protected boolean hideBody;
    protected final Set<UIMessageNotifier> messageNotifiers;
    private MainUI mainUI;
    private ApplicationActionUI actionUI;
    private JFrame secondaryFrame;
    private boolean dbExist;
    private boolean dbLoaded;
    private final ApplicationActionFactory faxToMailActionFactory;
    private final ApplicationActionEngine faxToMailActionEngine;
    protected Configuration faxToMailConfiguration;
    protected FaxToMailUser currentUser;
    protected MailFolder currentMailFolder;
    protected DemandeUIModel currentEmail;
    protected List<MailFolder> expandedFolders = new ArrayList<MailFolder>();
    protected SearchUIModel search;

    public static FaxToMailUIContext newContext(FaxToMailConfiguration config) {
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkState((applicationContext == null ? 1 : 0) != 0, (Object)"Application context was already opened!");
        applicationContext = new FaxToMailUIContext(config);
        return applicationContext;
    }

    public static FaxToMailUIContext getApplicationContext() {
        return applicationContext;
    }

    public ApplicationErrorHelper getErrorHelper() {
        return FaxToMailUIContext.applicationContext.errorHelper;
    }

    public String getI18nPrefix() {
        return "faxtomail.property.";
    }

    public String getDateFormat() {
        return this.getConfig().getDateFormat();
    }

    protected FaxToMailUIContext(FaxToMailConfiguration config) {
        this.config = config;
        this.resourceLoader = new RessourceClassLoader(Thread.currentThread().getContextClassLoader());
        this.serviceContext = new FaxToMailServiceContext();
        FaxToMailTopiaApplicationContext topiaApplicationContext = new FaxToMailTopiaApplicationContext(config.getTopiaProperties());
        FaxToMailTopiaPersistenceContext persistenceContext = topiaApplicationContext.newPersistenceContext();
        this.serviceContext.setPersistenceContext(persistenceContext);
        this.serviceContext.setApplicationConfig(config);
        InitFaxToMailService initExtranetService = (InitFaxToMailService)this.serviceContext.newService(InitFaxToMailService.class);
        initExtranetService.init();
        HashMap additionalStates = Maps.newHashMap();
        additionalStates.put(BeanFilterableComboBox.class, new BeanFilterableComboBoxState());
        additionalStates.put(BeanDoubleList.class, new BeanDoubleListState());
        this.swingSession = SwingSession.newSession((File)this.getConfig().getUIConfigFile(), (boolean)false, (Map)additionalStates);
        this.errorHelper = new ApplicationErrorHelper(this){

            public void showWarningDialog(String message) {
                JOptionPane.showMessageDialog((Component)this.context.getActionUI(), "<html><body>" + message + "</body></html>", I18n.t((String)"application.error.ui.business.warning", (Object[])new Object[0]), 2);
            }

            public void showErrorDialog(String message, Throwable cause) {
                super.showErrorDialog(message, cause);
            }
        };
        UIMessageNotifier logMessageNotifier = new UIMessageNotifier(){

            @Override
            public void showInformationMessage(String message) {
                if (StringUtils.isNotBlank((CharSequence)message)) {
                    message = message.replaceAll("\\<strong\\>", "");
                    message = message.replaceAll("\\<.strong\\>", "");
                    message = message.replaceAll("\\<li\\>", "");
                    message = message.replaceAll("\\<.li\\>", "");
                    message = message.replaceAll("\\<ul\\>", "");
                    message = message.replaceAll("\\<.ul\\>", "");
                    if (log.isInfoEnabled()) {
                        log.info((Object)message);
                    }
                }
            }
        };
        this.messageNotifiers = Sets.newHashSet();
        this.addMessageNotifier(logMessageNotifier);
        this.faxToMailActionFactory = new FaxToMailActionFactory();
        this.faxToMailActionEngine = new ApplicationActionEngine(this.faxToMailActionFactory);
    }

    public ApplicationConfiguration getConfiguration() {
        return this.config;
    }

    public Component getBodyUI() {
        MainUI mainUI = this.getMainUI();
        return mainUI == null ? null : mainUI.getBody();
    }

    public Component getStatusUI() {
        MainUI mainUI = this.getMainUI();
        return mainUI == null ? null : mainUI.getStatus();
    }

    public void init() {
        this.config.prepareDirectories();
        Thread.currentThread().setContextClassLoader((ClassLoader)this.getResourceLoader());
        ConverterUtil.deregister();
        ConverterUtil.initConverters();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Close context on shutdown");
                }
                FaxToMailUIContext.this.close();
            }
        }));
        Locale i18nLocale = this.config.getI18nLocale();
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Starts i18n with locale [%s]", i18nLocale));
        }
        I18n.init((I18nInitializer)new ClassPathI18nInitializer(), (Locale)i18nLocale);
        FaxToMailUser currentUser = this.getUserService().getUserByLogin("cbaillet");
        this.setCurrentUser(currentUser);
        Configuration config = this.getConfigurationService().getConfiguration();
        this.setFaxToMailConfiguration(config);
        this.setActionUI(new ApplicationActionUI(null, (ApplicationUIContext)this));
    }

    public void open() {
        this.setLocale(this.config.getI18nLocale());
        this.saveContextToConfig();
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (PROPERTIES_TO_SAVE.contains(evt.getPropertyName())) {
                    FaxToMailUIContext.this.saveContextToConfig();
                }
            }
        });
    }

    @Override
    public void close() {
        PropertyChangeListener[] listeners;
        this.messageNotifiers.clear();
        this.setScreen(null);
        for (PropertyChangeListener listener : listeners = this.getPropertyChangeListeners()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Remove listener: " + listener));
            }
            this.removePropertyChangeListener(listener);
        }
        this.setMainUI(null);
        if (this.actionUI != null) {
            this.actionUI.getModel().clear();
        }
        this.setActionUI(null);
    }

    public DecoratorService getDecoratorService() {
        return (DecoratorService)this.serviceContext.newService(DecoratorService.class);
    }

    public ValidationService getValidationService() {
        return (ValidationService)this.serviceContext.newService(ValidationService.class);
    }

    public MailFolderService getMailFolderService() {
        return (MailFolderService)this.serviceContext.newService(MailFolderService.class);
    }

    public UserService getUserService() {
        return (UserService)this.serviceContext.newService(UserService.class);
    }

    public EmailService getEmailService() {
        return (EmailService)this.serviceContext.newService(EmailService.class);
    }

    public ReferentielService getReferentielService() {
        return (ReferentielService)this.serviceContext.newService(ReferentielService.class);
    }

    public ConfigurationService getConfigurationService() {
        return (ConfigurationService)this.serviceContext.newService(ConfigurationService.class);
    }

    public FaxToMailConfiguration getConfig() {
        return this.config;
    }

    protected void saveContextToConfig() {
        this.config.setI18nLocale(this.getLocale());
        this.config.save();
    }

    public MainUI getMainUI() {
        return this.mainUI;
    }

    public void setMainUI(MainUI mainUI) {
        this.mainUI = mainUI;
    }

    public JFrame getSecondaryFrame() {
        return this.secondaryFrame;
    }

    public void setSecondaryFrame(JFrame secondaryFrame) {
        this.secondaryFrame = secondaryFrame;
    }

    public ApplicationActionUI getActionUI() {
        return this.actionUI;
    }

    public ApplicationActionUI getExistingActionUI() {
        while (this.actionUI == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.actionUI;
    }

    public void setActionUI(ApplicationActionUI actionUI) {
        this.actionUI = actionUI;
    }

    public SwingSession getSwingSession() {
        return this.swingSession;
    }

    public FaxToMailScreen getScreen() {
        return this.screen;
    }

    public void setScreen(FaxToMailScreen screen) {
        FaxToMailScreen oldValue = this.getScreen();
        this.screen = screen;
        this.firePropertyChange(PROPERTY_SCREEN, (Object)oldValue, (Object)screen);
    }

    public boolean isBusy() {
        return this.busy;
    }

    public void setBusy(boolean busy) {
        this.busy = busy;
        this.firePropertyChange(PROPERTY_BUSY, null, busy);
    }

    public boolean isHideBody() {
        return this.hideBody;
    }

    public void setHideBody(boolean hideBody) {
        this.hideBody = hideBody;
        this.firePropertyChange(PROPERTY_HIDE_BODY, null, hideBody);
    }

    public Color getColorBlockingLayer() {
        return this.getConfig().getColorBlockingLayer();
    }

    public ApplicationActionFactory getActionFactory() {
        return this.faxToMailActionFactory;
    }

    public ApplicationActionEngine getActionEngine() {
        return this.faxToMailActionEngine;
    }

    public void addMessageNotifier(UIMessageNotifier messageNotifier) {
        this.messageNotifiers.add(messageNotifier);
    }

    public void removeMessageNotifier(UIMessageNotifier messageNotifier) {
        this.messageNotifiers.remove(messageNotifier);
    }

    @Override
    public void showInformationMessage(String message) {
        for (UIMessageNotifier messageNotifier : this.messageNotifiers) {
            messageNotifier.showInformationMessage(message);
        }
    }

    public RessourceClassLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.firePropertyChange(PROPERTY_LOCALE, null, locale);
    }

    public Configuration getFaxToMailConfiguration() {
        return this.faxToMailConfiguration;
    }

    public void setFaxToMailConfiguration(Configuration faxToMailConfiguration) {
        this.faxToMailConfiguration = faxToMailConfiguration;
    }

    public FaxToMailUser getCurrentUser() {
        return this.currentUser;
    }

    public void setCurrentUser(FaxToMailUser currentUser) {
        this.currentUser = currentUser;
    }

    public MailFolder getCurrentMailFolder() {
        return this.currentMailFolder;
    }

    public void setCurrentMailFolder(MailFolder currentMailFolder) {
        this.currentMailFolder = currentMailFolder;
    }

    public DemandeUIModel getCurrentEmail() {
        return this.currentEmail;
    }

    public void setCurrentEmail(DemandeUIModel currentEmail) {
        this.currentEmail = currentEmail;
    }

    public List<MailFolder> getExpandedFolders() {
        return this.expandedFolders;
    }

    public void setExpandedFolders(List<MailFolder> expandedFolders) {
        this.expandedFolders = expandedFolders;
    }

    public SearchUIModel getSearch() {
        return this.search;
    }

    public void setSearch(SearchUIModel search) {
        this.search = search;
    }
}

