/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.services.service;

import com.franciaflex.faxtomail.persistence.entities.EmailTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.EtatAttente;
import com.franciaflex.faxtomail.persistence.entities.MailFilter;
import com.franciaflex.faxtomail.persistence.entities.MailFilterTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.persistence.entities.MailFolderImpl;
import com.franciaflex.faxtomail.persistence.entities.MailFolderTopiaDao;
import com.franciaflex.faxtomail.services.FaxToMailServiceSupport;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntities;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;
import org.nuiton.util.pagination.PaginationParameter;

public class MailFolderService
extends FaxToMailServiceSupport {
    private static final Log log = LogFactory.getLog(MailFolderService.class);

    public MailFolder getFolderForRecipient(String recipient) {
        MailFilterTopiaDao filterTopiaDao = this.getPersistenceContext().getMailFilterDao();
        PaginationParameter tpb = PaginationParameter.of((int)0, (int)-1, (String)"position", (boolean)false);
        String query = "FROM " + MailFilter.class.getCanonicalName() + " WHERE :recipient LIKE " + "expression";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("recipient", recipient);
        List filters = filterTopiaDao.find(query, params, tpb);
        MailFolder result = CollectionUtils.isNotEmpty((Collection)filters) ? ((MailFilter)filters.iterator().next()).getMailFolder() : null;
        return result;
    }

    public List<MailFolder> getAllMailFolders() {
        MailFolderTopiaDao dao = this.getPersistenceContext().getMailFolderDao();
        return new ArrayList<MailFolder>(dao.findAll());
    }

    public List<MailFolder> getRootMailFolders() {
        MailFolderTopiaDao dao = this.getPersistenceContext().getMailFolderDao();
        List result = dao.forParentEquals(null).findAll();
        return result;
    }

    public List<MailFolder> getMailFolders(Collection<String> ids) {
        MailFolderTopiaDao dao = this.getPersistenceContext().getMailFolderDao();
        return new ArrayList<MailFolder>(dao.forTopiaIdIn(ids).findAll());
    }

    public void saveMailFolders(Collection<MailFolder> newMailFolders) {
        MailFolderTopiaDao dao = this.getPersistenceContext().getMailFolderDao();
        List mailFolders = dao.findAll();
        HashMap<String, MailFolder> mailFolderMap = new HashMap<String, MailFolder>((Map<String, MailFolder>)Maps.uniqueIndex((Iterable)mailFolders, (Function)TopiaEntities.getTopiaIdFunction()));
        this.saveMailFolders(dao, mailFolderMap, null, newMailFolders);
        dao.deleteAll(mailFolderMap.values());
        this.getPersistenceContext().commit();
    }

    protected Collection<MailFolder> saveMailFolders(MailFolderTopiaDao dao, Map<String, MailFolder> mailFolderMap, MailFolder parent, Collection<MailFolder> mailFolders) {
        ArrayList result = Lists.newArrayList();
        if (mailFolders == null) {
            return result;
        }
        Binder binderMailFolder = BinderFactory.newBinder(MailFolder.class);
        for (MailFolder mailFolder : mailFolders) {
            Object currentMailFolder = StringUtils.isBlank((CharSequence)mailFolder.getTopiaId()) || mailFolder.getTopiaId().startsWith("new_") ? new MailFolderImpl() : mailFolderMap.remove(mailFolder.getTopiaId());
            binderMailFolder.copyExcluding((Object)mailFolder, currentMailFolder, new String[]{"topiaId", "topiaCreateDate", "topiaVersion", "children", "parent"});
            currentMailFolder.setParent(parent);
            if (!currentMailFolder.isPersisted()) {
                currentMailFolder = (MailFolder)dao.create((TopiaEntity)currentMailFolder);
            }
            Collection<MailFolder> children = this.saveMailFolders(dao, mailFolderMap, (MailFolder)currentMailFolder, mailFolder.getChildren());
            currentMailFolder.setChildren(children);
            dao.update((TopiaEntity)currentMailFolder);
            result.add(currentMailFolder);
        }
        return result;
    }

    public Collection<MailFolder> getFoldersWithEtatAttente(EtatAttente etatAttente) {
        HashSet<MailFolder> result = new HashSet<MailFolder>();
        MailFolderTopiaDao dao = this.getPersistenceContext().getMailFolderDao();
        List roots = dao.forParentEquals(null).findAll();
        for (MailFolder root : roots) {
            result.addAll(this.getFoldersWithEtatAttente(root, new HashSet<EtatAttente>(), etatAttente));
        }
        return result;
    }

    protected Collection<MailFolder> getFoldersWithEtatAttente(MailFolder folder, Collection<EtatAttente> parentEtatAttente, EtatAttente etatAttente) {
        Collection<EtatAttente> etatAttentes = folder.getEtatAttentes();
        if (CollectionUtils.isEmpty((Collection)etatAttentes)) {
            etatAttentes = parentEtatAttente;
        } else {
            parentEtatAttente = etatAttentes;
        }
        HashSet<MailFolder> result = new HashSet<MailFolder>();
        Collection children = folder.getChildren();
        if (children != null) {
            for (MailFolder child : children) {
                result.addAll(this.getFoldersWithEtatAttente(child, parentEtatAttente, etatAttente));
            }
        }
        if (etatAttentes.contains(etatAttente)) {
            result.add(folder);
        }
        return result;
    }

    public Map<String, Long> getMailFoldersUsage() {
        EmailTopiaDao dao = this.getPersistenceContext().getEmailDao();
        Map result = dao.getMailCountByFolder();
        return result;
    }
}

