/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.actions;

import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.ui.swing.FaxToMailScreen;
import com.franciaflex.faxtomail.ui.swing.actions.AbstractChangeScreenAction;
import com.franciaflex.faxtomail.ui.swing.content.MainUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.i18n.I18n;

public class ShowDemandeAction
extends AbstractChangeScreenAction {
    public ShowDemandeAction(MainUIHandler handler) {
        super(handler, true, FaxToMailScreen.DEMANDE);
        this.setActionDescription(I18n.t((String)"faxtomail.action.goto.demand.tip", (Object[])new Object[0]));
    }

    @Override
    public void doAction() throws Exception {
        super.doAction();
        DemandeUIModel currentEmail = this.getContext().getCurrentEmail();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{currentEmail.getTopiaId()})) {
            Email email = this.getContext().getEmailService().getEmailById(currentEmail.getTopiaId());
            currentEmail.setGroupedDemandes(email.getEmailGroup());
        }
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        DemandeUIModel currentEmail = this.getContext().getCurrentEmail();
        FaxToMailUser takenBy = currentEmail.getTakenBy();
        FaxToMailUser currentUser = this.getContext().getCurrentUser();
        if (currentEmail.getArchiveDate() != null) {
            currentEmail.setEditable(false);
        } else if (takenBy != null && !currentUser.equals(takenBy)) {
            String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n.t((String)"faxtomail.alert.alreadyTakenBy.message", (Object[])new Object[]{this.decorate(takenBy)}), I18n.t((String)"faxtomail.alert.alreadyTakenBy.help", (Object[])new Object[0]));
            int result = JOptionPane.showConfirmDialog(((MainUIHandler)this.getHandler()).getTopestUI(), htmlMessage, I18n.t((String)"faxtomail.alert.alreadyTakenBy.title", (Object[])new Object[0]), 1, 3);
            switch (result) {
                case 2: {
                    this.getContext().setScreen(FaxToMailScreen.LIST);
                    break;
                }
                case 1: {
                    currentEmail.setEditable(false);
                    break;
                }
                case 0: {
                    Email email = this.getContext().getEmailService().takeEmail(currentEmail.getTopiaId(), currentUser);
                    currentEmail.fromEntity(email);
                    currentEmail.setEditable(true);
                }
            }
        }
    }
}

