package com.franciaflex.faxtomail.ui.swing.content.search;

/*
 * #%L
 * FaxToMail :: UI
 * $Id: SearchToGroupUIHandler.java 185 2014-06-11 05:32:51Z kmorin $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.2/faxtomail-ui-swing/src/main/java/com/franciaflex/faxtomail/ui/swing/content/search/SearchToGroupUIHandler.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.DemandStatus;
import com.franciaflex.faxtomail.persistence.entities.EmailFilter;
import com.franciaflex.faxtomail.persistence.entities.MailField;
import com.franciaflex.faxtomail.services.service.ReferentielService;
import com.franciaflex.faxtomail.ui.swing.actions.GroupAction;
import com.franciaflex.faxtomail.ui.swing.actions.SearchToGroupAction;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailDemandListHandler;
import com.franciaflex.faxtomail.ui.swing.util.Cancelable;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.nuiton.jaxx.application.swing.table.AbstractApplicationTableModel;

import javax.swing.*;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import java.awt.*;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;

import static org.nuiton.i18n.I18n.t;

/**
 * @author Kevin Morin (Code Lutin)
 * @since x.x
 */
public class SearchToGroupUIHandler extends AbstractFaxToMailDemandListHandler<SearchUIModel, SearchToGroupUI>
                                    implements Cancelable {

    /** Logger. */
    private static final Log log = LogFactory.getLog(SearchToGroupUIHandler.class);

    @Override
    public void beforeInit(SearchToGroupUI ui) {
        super.beforeInit(ui);

        SearchUIModel searchUIModel = getContext().getSearch();
        if (searchUIModel == null) {
            searchUIModel = new SearchUIModel();
//            searchUIModel.setTakenBy(getContext().getCurrentUser());
//            searchUIModel.setModifiedBy(getContext().getCurrentUser());

            Date now = new Date();
            Calendar cal = Calendar.getInstance();
            cal.add(Calendar.MONTH, -2);
            Date twoMonthsAgo = cal.getTime();

//            searchUIModel.setMaxModificationDate(now);
//            searchUIModel.setMinModificationDate(twoMonthsAgo);
            searchUIModel.setMaxReceptionDate(now);
            searchUIModel.setMinReceptionDate(twoMonthsAgo);
            //searchUIModel.setMaxPrintingDate(now);
            //searchUIModel.setMinPrintingDate(twoMonthsAgo);
        }

        getUI().setContextValue(searchUIModel);
    }

    @Override
    protected JComponent getComponentToFocus() {
        return null;
    }

    @Override
    public void afterInit(SearchToGroupUI ui) {
        initUI(ui);

        ReferentielService referentielService = getContext().getReferentielService();

        SearchUIModel model = getModel();
        initBeanFilterableComboBox(ui.getTakenByComboBox(),
                                   getContext().getUserService().getAllUsers(),
                                   model.getTakenBy());
        initBeanFilterableComboBox(ui.getModifiedByComboBox(),
                                   getContext().getUserService().getAllUsers(),
                                   model.getModifiedBy());
        initBeanFilterableComboBox(ui.getArchivedByComboBox(),
                                   getContext().getUserService().getAllUsers(),
                                   model.getArchivedBy());
        initBeanFilterableComboBox(ui.getTransferByComboBox(),
                                   getContext().getUserService().getAllUsers(),
                                   model.getTransferBy());
        initBeanFilterableComboBox(ui.getPrintedByComboBox(),
                                   getContext().getUserService().getAllUsers(),
                                   model.getPrintingBy());
        initBeanFilterableComboBox(ui.getRepliedByComboBox(),
                                   getContext().getUserService().getAllUsers(),
                                   model.getReplyBy());

        initCheckBoxComboBox(ui.getDocTypeComboBox(),
                             referentielService.getAllDemandType(),
                             model.getDemandType(),
                             EmailFilter.PROPERTY_DEMAND_TYPE,
                             true);
        initCheckBoxComboBox(ui.getPriorityComboBox(),
                             referentielService.getAllPriority(),
                             model.getPriority(),
                             EmailFilter.PROPERTY_PRIORITY,
                             true);
        initCheckBoxComboBox(ui.getEtatAttenteComboBox(),
                             referentielService.getAllEtatAttente(),
                             model.getEtatAttente(),
                             EmailFilter.PROPERTY_ETAT_ATTENTE,
                             true);
        initCheckBoxComboBox(ui.getStatusComboBox(),
                             Arrays.asList(DemandStatus.values()),
                             model.getDemandStatus(),
                             EmailFilter.PROPERTY_DEMAND_STATUS,
                             false);
        initCheckBoxComboBox(ui.getGammeComboBox(),
                             referentielService.getAllRange(),
                             model.getGamme(),
                             EmailFilter.PROPERTY_GAMME,
                             false);

        final JXTable dataTable = getUI().getDataTable();
        dataTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

        initDemandeTable(dataTable, true);

        model.addPropertyChangeListener(SearchUIModel.PROPERTY_RESULTS, new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                List<DemandeUIModel> emails = (List<DemandeUIModel>) evt.getNewValue();
                AbstractApplicationTableModel<DemandeUIModel> dataTableModel = (AbstractApplicationTableModel<DemandeUIModel>) dataTable.getModel();
                dataTableModel.setRows(emails);
                showInformationMessage(t("faxtomail.search.resultNb", emails.size()));

                DemandeUIModel currentEmail = getContext().getCurrentEmail();
                if (currentEmail != null) {
                    int row = dataTableModel.getRowIndex(currentEmail);
                    if (row > 0) {
                        dataTable.setRowSelectionInterval(row, row);
                    }
                }
            }
        });

        if (getContext().getSearch() != null) {
            try {
                SearchToGroupAction searchAction = getContext().getActionFactory().createLogicAction(this, SearchToGroupAction.class);
                searchAction.doAction();

            } catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error("error while searching", e);
                }
                getContext().getErrorHelper().showErrorDialog(t("faxtomail.search.action.error"));
            }
        }

        dataTable.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ListSelectionModel selectionModel = (ListSelectionModel) e.getSource();
                    SearchUIModel model = getModel();
                    int selectedIndex = selectionModel.getLeadSelectionIndex();
                    AbstractApplicationTableModel<DemandeUIModel> dataTableModel = (AbstractApplicationTableModel<DemandeUIModel>) dataTable.getModel();
                    DemandeUIModel selectedModel = selectedIndex < 0 ? null : dataTableModel.getEntry(selectedIndex);
                    model.setGroupEnabled(!selectionModel.isSelectionEmpty() && isDemandSelectable(selectedModel));
                }
            }
        });

        HighlightPredicate rowAlreadyInGroupPredicate = new HighlightPredicate() {
            @Override
            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                int viewRow = adapter.row;
                int modelRow = adapter.convertRowIndexToModel(viewRow);
                AbstractApplicationTableModel<DemandeUIModel> dataTableModel = (AbstractApplicationTableModel<DemandeUIModel>) dataTable.getModel();
                DemandeUIModel row = dataTableModel.getEntry(modelRow);
                return !isDemandSelectable(row);
            }
        };
        dataTable.addHighlighter(new ColorHighlighter(rowAlreadyInGroupPredicate, null, Color.GRAY, Color.GRAY, Color.WHITE));

    }

    @Override
    protected List<MailField> getColumns() {
        List<MailField> tableColumns = getContext().getFaxToMailConfiguration().getSearchDisplayColumns();
        return tableColumns;
    }

    protected boolean isDemandSelectable(DemandeUIModel demand) {
        DemandeUIModel currentDemand = getContext().getCurrentEmail();
        return !currentDemand.equals(demand) && !currentDemand.getGroupedDemandes().contains(demand);
    }

    @Override
    protected MouseListener getDataTableMouseListener() {
        return new MouseAdapter() {
            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    group();
                }
            }
        };
    }

    @Override
    protected MailField[] getEditableTableProperties() {
        return new MailField[0];
    }

    @Override
    public void onCloseUI() {
    }

    @Override
    public SwingValidator<SearchUIModel> getValidator() {
        return null;
    }

    @Override
    public void cancel() {
        closeFrame();
    }

    public void group(KeyEvent e) {
        if (e.getKeyCode() == KeyEvent.VK_ENTER) {
            group();
        }
    }

    public void group() {
        if (getModel().isGroupEnabled()) {
            getContext().getActionEngine().runAction(new GroupAction(this));
        }
    }
}
