package com.franciaflex.faxtomail.ui.swing.content.demande;

/*
 * #%L
 * FaxToMail :: UI
 * %%
 * Copyright (C) 2014 Franciaflex
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.AttachmentImpl;
import com.franciaflex.faxtomail.persistence.entities.Client;
import com.franciaflex.faxtomail.persistence.entities.DemandStatus;
import com.franciaflex.faxtomail.persistence.entities.DemandType;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.EmailGroup;
import com.franciaflex.faxtomail.persistence.entities.EmailImpl;
import com.franciaflex.faxtomail.persistence.entities.EtatAttente;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.History;
import com.franciaflex.faxtomail.persistence.entities.HistoryType;
import com.franciaflex.faxtomail.persistence.entities.MailField;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.persistence.entities.Priority;
import com.franciaflex.faxtomail.persistence.entities.RangeRow;
import com.franciaflex.faxtomail.persistence.entities.Reply;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailBeanUIModel;
import com.franciaflex.faxtomail.ui.swing.content.attachment.AttachmentModelAware;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.swing.tab.TabContentModel;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

import static org.nuiton.i18n.I18n.t;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since x.x
 */
public class DemandeUIModel extends AbstractFaxToMailBeanUIModel<Email, DemandeUIModel> implements AttachmentModelAware, TabContentModel {

    private static final Log log = LogFactory.getLog(DemandeUIModel.class);

    public static final String PROPERTY_QUOTATION_NB = "quotationNb";
    public static final String PROPERTY_PF_NB = "pfNb";
    public static final String PROPERTY_SAV_NB = "savNb";
    public static final String PROPERTY_RANGE_PANEL_VISIBLE = "rangePanelVisible";
    public static final String PROPERTY_CLIENT_CODE = "clientCode";
    public static final String PROPERTY_CLIENT_BRAND = "clientBrand";
    public static final String PROPERTY_REFERENCE = "reference";
    public static final String PROPERTY_EDITABLE = "editable";
    public static final String PROPERTY_LAST_ATTACHMENT_OPENING_IN_THIS_FOLDER_USER = "lastAttachmentOpeningInThisFolderUser";
    public static final String PROPERTY_GROUPED_DEMANDES = "groupedDemandes";
    public static final String PROPERTY_VALID_RANGE_ROW_MODELS = "validRangeRowModels";

    protected final Email editObject = new EmailImpl();

    protected final Collection<Attachment> attachments = new ArrayList<Attachment>();

    protected final Collection<DemandeUIModel> groupedDemandes = new ArrayList<DemandeUIModel>();

    protected final Collection<RangeRowModel> validRangeRowModels = new ArrayList<RangeRowModel>();

    protected History firstOpeningHistory;

    protected History lastModificationHistory;

    protected History lastAttachmentOpeningInThisFolderHistory;

    protected int quotationNb;

    protected int pfNb;

    protected int savNb;

    protected String clientCode;

    protected String clientBrand;

    protected boolean editable = true;

    protected String htmlContent;

    protected String plainContent;

    protected String subject;

    protected List<String> toRecipients;

    protected List<String> ccRecipients;

    protected boolean closeable;

    protected static Binder<DemandeUIModel, Email> toBeanBinder =
            BinderFactory.newBinder(DemandeUIModel.class,
                                    Email.class);

    protected static Binder<Email, DemandeUIModel> fromBeanBinder =
            BinderFactory.newBinder(Email.class, DemandeUIModel.class);

    protected static Binder<Attachment, Attachment> fromAttachmentBinder =
            BinderFactory.newBinder(Attachment.class, Attachment.class);

    public DemandeUIModel() {
        super(fromBeanBinder, toBeanBinder);
        addPropertyChangeListener(Email.PROPERTY_HISTORY, new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                findFirstOpeningHistory();
                findLastModificationHistory();
                findLastAttachmentOpeningInThisFolderHistory();
            }
        });

        addPropertyChangeListener(Email.PROPERTY_RANGE_ROW, new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Collection<RangeRow> rangeRows = (Collection<RangeRow>) evt.getNewValue();
                int quotationNb = 0;
                int pfNb = 0;
                int savNb = 0;
                if (rangeRows != null) {
                    for (RangeRow rangeRow : rangeRows) {
                        Integer quotationQuantity = rangeRow.getQuotationQuantity();
                        if (quotationQuantity != null) {
                            quotationNb += quotationQuantity;
                        }

                        Integer productQuantity = rangeRow.getProductQuantity();
                        if (productQuantity != null) {
                            pfNb += productQuantity;
                        }

                        Integer savQuantity = rangeRow.getSavQuantity();
                        if (savQuantity != null) {
                            savNb += savQuantity;
                        }
                    }
                }
                setQuotationNb(quotationNb);
                setPfNb(pfNb);
                setSavNb(savNb);
            }
        });

    }

    @Override
    public void fromEntity(Email entity) {
        fromEntity(entity, true);
    }

    /**
     * Surcharge pour dupliquer correctement les pieces jointes.
     *
     * FIXME echatellier 20140520 c'est pas terrible, mais c'est comme ca :p
     */
    public void fromEntity(Email entity, boolean full) {
        //super.fromEntity(entity);

        fromBeanBinder.copyExcluding(entity, this, Email.PROPERTY_ATTACHMENT);
        // specific attachment copy
        Collection<Attachment> attachmentCopy = new ArrayList<Attachment>();
        if (entity.getAttachment() != null) {
            for (Attachment attachment : entity.getAttachment()) {
                Attachment clone = new AttachmentImpl();
                fromAttachmentBinder.copy(attachment, clone);
                attachmentCopy.add(clone);
            }
        }
        setAttachment(attachmentCopy);
    }

    @Override
    public Email toEntity() {
        Email result = newEntity();
        toBeanBinder.copyExcluding(this, result, Email.PROPERTY_ATTACHMENT);
        return result;
    }

    @Override
    public Email toEntity(Email entity) {
        toBeanBinder.copyExcluding(this, entity, Email.PROPERTY_ATTACHMENT);
        return entity;
    }

    public Boolean getFax() {
        return editObject.getFax();
    }

    public void setFax(Boolean fax) {
        editObject.setFax(fax);
    }

    public String getTopiaId() {
        return editObject.getTopiaId();
    }

    public void setTopiaId(String id) {
        editObject.setTopiaId(id);
    }

    public void setSender(String sender) {
        Object oldValue = getSender();
        editObject.setSender(sender);
        firePropertyChanged(Email.PROPERTY_SENDER, oldValue, sender);
    }

    public String getSender() {
        String sender = editObject.getSender();
        if (sender == null) {
            sender = t("faxtomail.demande.sender.manualCreation");
        }
        return sender;
    }

    public void setRecipient(String recipient) {
        Object oldValue = getRecipient();
        editObject.setRecipient(recipient);
        firePropertyChanged(Email.PROPERTY_RECIPIENT, oldValue, recipient);
    }

    public String getRecipient() {
        return editObject.getRecipient();
    }

    public void setObject(String object) {
        Object oldValue = getObject();
        editObject.setObject(object);
        firePropertyChanged(Email.PROPERTY_OBJECT, oldValue, object);
    }

    public String getObject() {
        return editObject.getObject();
    }

    public String getSubject() {
        if (subject == null) {
            decomposeEmail();
        }
        return subject;
    }

    public String getToRecipients() {
        if (toRecipients == null) {
            decomposeEmail();
        }
        return StringUtils.join(toRecipients, ", ");
    }

    public String getCcRecipients() {
        if (ccRecipients == null) {
            decomposeEmail();
        }
        return StringUtils.join(ccRecipients, ", ");
    }

    public String getPlainContent() {
        if (plainContent == null) {
            decomposeEmail();
        }
        return plainContent;
    }

    public String getHtmlContent() {
        if (htmlContent == null) {
            decomposeEmail();
        }
        return htmlContent;
    }

    public void setOriginalEmail(String originalEmail) {
        editObject.setOriginalEmail(originalEmail);
    }

    public String getOriginalEmail() {
        return editObject.getOriginalEmail();
    }

    public void setClientCode(String clientCode) {
        Object oldValue = getClientCode();
        this.clientCode = clientCode;
        firePropertyChanged(PROPERTY_CLIENT_CODE, oldValue, clientCode);
    }

    public void setClient(Client client) {
        Object oldValue = getClient();
        editObject.setClient(client);
        if (client != null) {
            this.clientCode = client.getCode();
            this.clientBrand = client.getBrand();
        }
        firePropertyChanged(Email.PROPERTY_CLIENT, oldValue, client);
    }

    public Client getClient() {
        return editObject.getClient();
    }

    public String getClientCode() {
        return clientCode;
    }

    public void setClientBrand(String clientBrand) {
        Object oldValue = getClientBrand();
        this.clientBrand = clientBrand;
        firePropertyChanged(PROPERTY_CLIENT_BRAND, oldValue, clientBrand);
    }

    public String getClientBrand() {
        return clientBrand;
    }

    public void setEtatAttente(EtatAttente etatAttente) {
        Object oldValue = getEtatAttente();
        editObject.setEtatAttente(etatAttente);
        firePropertyChanged(Email.PROPERTY_ETAT_ATTENTE, oldValue, etatAttente);
    }

    public EtatAttente getEtatAttente() {
        return editObject.getEtatAttente();
    }

    public void setTakenBy(FaxToMailUser faxToMailUser) {
        Object oldValue = getTakenBy();
        editObject.setTakenBy(faxToMailUser);
        firePropertyChanged(Email.PROPERTY_TAKEN_BY, oldValue, faxToMailUser);
    }

    public FaxToMailUser getTakenBy() {
        return editObject.getTakenBy();
    }

    public Priority getPriority() {
        return editObject.getPriority();
    }

    public void setPriority(Priority priority) {
        Object oldValue = getPriority();
        editObject.setPriority(priority);
        firePropertyChanged(Email.PROPERTY_PRIORITY, oldValue, priority);
    }

    public DemandType getDemandType() {
        return editObject.getDemandType();
    }

    public void setDemandType(DemandType demandType) {
        Object oldValue = getDemandType();
        Object rangePanelVisibleOldValue = isRangePanelVisible();
        editObject.setDemandType(demandType);
        firePropertyChanged(Email.PROPERTY_DEMAND_TYPE, oldValue, demandType);
        firePropertyChanged(DemandeUIModel.PROPERTY_RANGE_PANEL_VISIBLE, rangePanelVisibleOldValue, isRangePanelVisible());
    }

    public boolean isRangePanelVisible() {
        DemandType demandType = getDemandType();
        return demandType != null && demandType.containsFields(MailField.RANGE_ROW);
    }

    public DemandStatus getDemandStatus() {
        return editObject.getDemandStatus();
    }

    public void setDemandStatus(DemandStatus demandStatus) {
        Object oldValue = getDemandStatus();
        editObject.setDemandStatus(demandStatus);
        firePropertyChanged(Email.PROPERTY_DEMAND_STATUS, oldValue, demandStatus);
    }

    public void setReceptionDate(Date receptionDate) {
        Object oldValue = getReceptionDate();
        editObject.setReceptionDate(receptionDate);
        firePropertyChanged(Email.PROPERTY_RECEPTION_DATE, oldValue, receptionDate);
    }

    public Date getReceptionDate() {
        return editObject.getReceptionDate();
    }

    public void setEdiCodeNumber(String ediCodeNumber) {
        Object oldValue = getEdiCodeNumber();
        editObject.setEdiCodeNumber(ediCodeNumber);
        firePropertyChanged(Email.PROPERTY_EDI_CODE_NUMBER, oldValue, ediCodeNumber);
    }

    public String getEdiCodeNumber() {
        return editObject.getEdiCodeNumber();
    }

    public void setProjectReference(String projectReference) {
        Object oldValue = getProjectReference();
        editObject.setProjectReference(projectReference);
        firePropertyChanged(Email.PROPERTY_PROJECT_REFERENCE, oldValue, projectReference);
    }

    public String getProjectReference() {
        return editObject.getProjectReference();
    }

    public void setCompanyReference(String companyReference) {
        Object oldValue = getCompanyReference();
        Object refOldValue = getReference();
        editObject.setCompanyReference(companyReference);
        firePropertyChanged(Email.PROPERTY_COMPANY_REFERENCE, oldValue, companyReference);
        firePropertyChanged(PROPERTY_REFERENCE, refOldValue, getReference());
    }

    public String getCompanyReference() {
        return editObject.getCompanyReference();
    }

    public String getReference() {
        List<String> reference = new ArrayList<String>();
        if (StringUtils.isNotBlank(getCompanyReference())) {
            reference.add(getCompanyReference());
        }
        Collection<RangeRow> rangeRow = getRangeRow();
        if (rangeRow != null) {
            Collection<String> commandNumbers = Collections2.transform(rangeRow, new Function<RangeRow, String>() {
                @Override
                public String apply(RangeRow input) {
                    return input.getCommandNumber();
                }
            });
            Collections2.filter(commandNumbers, new Predicate<String>() {
                @Override
                public boolean apply(String input) {
                    return StringUtils.isNotBlank(input);
                }
            });
            reference.addAll(commandNumbers);
        }
        return StringUtils.join(reference, ", ");
    }

    public void setHistory(Collection<History> history) {
        editObject.setHistory(history);
        firePropertyChanged(Email.PROPERTY_HISTORY, null, history);
    }

    public Collection<History> getHistory() {
        return editObject.getHistory();
    }

    public int sizeHistory() {
        return editObject.sizeHistory();
    }

    public void findFirstOpeningHistory() {
        History result = null;
        Date date = null;
        Collection<History> histories = getHistory();
        if (histories != null) {
            for (History history : histories) {
                if (HistoryType.OPENING.equals(history.getType())) {
                    if (date == null || date.after(history.getModificationDate())) {
                        date = history.getModificationDate();
                        result = history;
                    }
                }
            }
        }
        firstOpeningHistory = result;
    }

    public void findLastModificationHistory() {
        History result = null;
        Date date = null;
        Collection<History> histories = getHistory();
        if (histories != null) {
            for (History history : histories) {
                if (history.getType().isConsideredAsModification()) {
                    if (date == null || date.before(history.getModificationDate())) {
                        date = history.getModificationDate();
                        result = history;
                    }
                }
            }
        }
        lastModificationHistory = result;
    }

    public void findLastAttachmentOpeningInThisFolderHistory() {
        History result = null;
        Collection<History> histories = getHistory();

        if (histories != null) {
            History transmissionHistory = null;
            for (History history : histories) {
                Date modificationDate = history.getModificationDate();
                if (HistoryType.ATTACHMENT_OPENING.equals(history.getType())) {
                    if ((transmissionHistory == null
                                    || transmissionHistory.getModificationDate().before(modificationDate))
                            && (result == null
                                    || result.getModificationDate().before(modificationDate))) {
                        result = history;
                    }

                } else if (HistoryType.TRANSMISSION.equals(history.getType())) {
                    if (transmissionHistory == null
                            || transmissionHistory.getModificationDate().before(modificationDate)) {

                        transmissionHistory = history;
                        if (result != null && result.getModificationDate().before(transmissionHistory.getModificationDate())) {
                            result = null;
                        }
                    }
                }
            }
        }
        lastAttachmentOpeningInThisFolderHistory = result;
    }

    public History getFirstOpeningHistory() {
        return firstOpeningHistory;
    }

    public FaxToMailUser getFirstOpeningUser() {
        History history = getFirstOpeningHistory();
        return history != null ? history.getFaxToMailUser() : null;
    }

    public Date getFirstOpeningDate() {
        History history = getFirstOpeningHistory();
        return history != null ? history.getModificationDate() : null;
    }

    public History getLastModificationHistory() {
        return lastModificationHistory;
    }

    public FaxToMailUser getLastModificationUser() {
        History history = getLastModificationHistory();
        return history != null ? history.getFaxToMailUser() : null;
    }

    public Date getLastModificationDate() {
        History history = getLastModificationHistory();
        return history != null ? history.getModificationDate() : null;
    }

    public History getLastAttachmentOpeningInThisFolderHistory() {
        return lastAttachmentOpeningInThisFolderHistory;
    }

    public FaxToMailUser getLastAttachmentOpeningInThisFolderUser() {
        History history = getLastAttachmentOpeningInThisFolderHistory();
        return history != null ? history.getFaxToMailUser() : null;
    }

    public Date getLastAttachmentOpeningInThisFolderDate() {
        History history = getLastAttachmentOpeningInThisFolderHistory();
        return history != null ? history.getModificationDate() : null;
    }

    @Override
    public Collection<Attachment> getAttachment() {
        return new ArrayList<Attachment>(attachments);
    }

    @Override
    public void addAllAttachment(Collection<Attachment> attachment) {
        Object oldValue = new ArrayList<Attachment>(getAttachment());
        attachments.addAll(attachment);
        firePropertyChange(Email.PROPERTY_ATTACHMENT, oldValue, getAttachment());
    }

    @Override
    public void addAttachment(Attachment attachment) {
        Object oldValue = new ArrayList<Attachment>(getAttachment());
        attachments.add(attachment);
        firePropertyChange(Email.PROPERTY_ATTACHMENT, oldValue, getAttachment());
    }

    @Override
    public void removeAttachment(Attachment attachment) {
        Object oldValue = new ArrayList<Attachment>(getAttachment());
        attachments.remove(attachment);
        firePropertyChange(Email.PROPERTY_ATTACHMENT, oldValue, getAttachment());
    }

    public void setAttachment(Collection<Attachment> attachment) {
        Object oldValue = new ArrayList<Attachment>(getAttachment());
        attachments.clear();
        if (attachment != null) {
            attachments.addAll(attachment);
        }
        firePropertyChange(Email.PROPERTY_ATTACHMENT, oldValue, getAttachment());
    }

    public Collection<RangeRow> getRangeRow() {
        return editObject.getRangeRow();
    }

    public void addRangeRow(RangeRow rangeRow) {
        Object oldValue = null;
        if (getRangeRow() != null) {
            oldValue = new ArrayList<RangeRow>(getRangeRow());
        }
        String refOldValue = getReference();
        editObject.addRangeRow(rangeRow);
        firePropertyChange(Email.PROPERTY_RANGE_ROW, oldValue, getRangeRow());
        firePropertyChanged(PROPERTY_REFERENCE, refOldValue, getReference());
    }

    public void addAllRangeRow(Collection<RangeRow> rangeRow) {
        Object oldValue = null;
        if (getRangeRow() != null) {
            oldValue = new ArrayList<RangeRow>(getRangeRow());
        }
        String refOldValue = getReference();
        editObject.addAllRangeRow(rangeRow);
        firePropertyChange(Email.PROPERTY_RANGE_ROW, oldValue, getRangeRow());
        firePropertyChanged(PROPERTY_REFERENCE, refOldValue, getReference());
    }

    public void removeRangeRow(RangeRow rangeRow) {
        Object oldValue = null;
        if (getRangeRow() != null) {
            oldValue = new ArrayList<RangeRow>(getRangeRow());
        }
        String refOldValue = getReference();
        editObject.removeRangeRow(rangeRow);
        firePropertyChange(Email.PROPERTY_RANGE_ROW, oldValue, getRangeRow());
        firePropertyChanged(PROPERTY_REFERENCE, refOldValue, getReference());
    }

    public void setRangeRow(Collection<RangeRow> rangeRow) {
        Object oldValue = null;
        if (getRangeRow() != null) {
            oldValue = new ArrayList<RangeRow>(getRangeRow());
        }
        if (rangeRow == null) {
            rangeRow = new ArrayList<RangeRow>();
        }
        String refOldValue = getReference();
        editObject.setRangeRow(rangeRow);
        firePropertyChange(Email.PROPERTY_RANGE_ROW, oldValue, getRangeRow());
        firePropertyChanged(PROPERTY_REFERENCE, refOldValue, getReference());
    }

    public MailFolder getMailFolder() {
        return editObject.getMailFolder();
    }

    public void setMailFolder(MailFolder mailFolder) {
        Object oldValue = getMailFolder();
        editObject.setMailFolder(mailFolder);
        firePropertyChanged(Email.PROPERTY_MAIL_FOLDER, oldValue, mailFolder);
    }

    public Date getArchiveDate() {
        return editObject.getArchiveDate();
    }

    public void setArchiveDate(Date archiveDate) {
        Object oldValue = getArchiveDate();
        editObject.setArchiveDate(archiveDate);
        firePropertyChanged(Email.PROPERTY_ARCHIVE_DATE, oldValue, archiveDate);
    }

    public int getQuotationNb() {
        return quotationNb;
    }

    public void setQuotationNb(int quotationNb) {
        Object oldValue = getQuotationNb();
        this.quotationNb = quotationNb;
        firePropertyChange(PROPERTY_QUOTATION_NB, oldValue, quotationNb);
    }

    public int getPfNb() {
        return pfNb;
    }

    public void setPfNb(int pfNb) {
        Object oldValue = getPfNb();
        this.pfNb = pfNb;
        firePropertyChange(PROPERTY_PF_NB, oldValue, pfNb);
    }

    public int getSavNb() {
        return savNb;
    }

    public void setSavNb(int savNb) {
        Object oldValue = getSavNb();
        this.savNb = savNb;
        firePropertyChange(PROPERTY_SAV_NB, oldValue, savNb);
    }

    public boolean isEditable() {
        return editable;
    }

    public void setEditable(boolean editable) {
        Object oldValue = isEditable();
        this.editable = editable;
        firePropertyChange(PROPERTY_EDITABLE, oldValue, editable);
    }

    public void setComment(String comment) {
        Object oldValue = getComment();
        editObject.setComment(comment);
        firePropertyChange(Email.PROPERTY_COMMENT, oldValue, comment);
    }

    public String getComment() {
        return editObject.getComment();
    }

    public void setGroupedDemandes(EmailGroup emailGroup) {
        Object oldValue = new ArrayList<DemandeUIModel>(getGroupedDemandes());
        if (emailGroup != null) {
            groupedDemandes.clear();
            Collection<Email> emails = emailGroup.getEmail();
            if (emails != null) {
                for (Email email : emails) {
                    if (!email.getTopiaId().equals(getTopiaId())) {
                        DemandeUIModel demandeUIModel = new DemandeUIModel();
                        demandeUIModel.fromEntity(email);
                        groupedDemandes.add(demandeUIModel);
                    }
                }
            }
        }
        firePropertyChange(PROPERTY_GROUPED_DEMANDES, oldValue, getGroupedDemandes());
    }

    public void addGroupedDemande(DemandeUIModel demand) {
        Object oldValue = new ArrayList<DemandeUIModel>(getGroupedDemandes());
        groupedDemandes.add(demand);
        firePropertyChange(PROPERTY_GROUPED_DEMANDES, oldValue, getGroupedDemandes());

    }

    public Collection<DemandeUIModel> getGroupedDemandes() {
        return groupedDemandes;
    }

    public int sizeGroupedDemandes() {
        return groupedDemandes.size();
    }

    public void addAllReplies(Collection<Reply> replies) {
        Object oldValue = new ArrayList<Reply>(getReplies());
        editObject.addAllReplies(replies);
        firePropertyChange(Email.PROPERTY_REPLIES, oldValue, getAttachment());
    }

    public void addReplies(Reply reply) {
        Object oldValue = null;
        if (getReplies() != null) {
            oldValue = new ArrayList<Reply>(getReplies());
        }
        editObject.addReplies(reply);
        firePropertyChange(Email.PROPERTY_REPLIES, null, getReplies());
    }

    public void removeReply(Reply reply) {
        Object oldValue = new ArrayList<Reply>(getReplies());
        editObject.removeReplies(reply);
        firePropertyChange(Email.PROPERTY_REPLIES, oldValue, getReplies());
    }

    public void setReplies(Collection<Reply> replies) {
        Object oldValue = null;
        if (getReplies() != null) {
            oldValue = new ArrayList<Reply>(getReplies());
        }
        editObject.setReplies(replies);
        firePropertyChange(Email.PROPERTY_REPLIES, null, getReplies());
    }

    public Collection<Reply> getReplies() {
        return editObject.getReplies();
    }

    public int sizeReplies() {
        return editObject.sizeReplies();
    }


    public Collection<RangeRowModel> getValidRangeRowModels() {
        return validRangeRowModels;
    }

    public void setValidRangeRowModels(Collection<RangeRowModel> validRangeRowModels) {
        Object oldValue = new ArrayList<RangeRowModel>(validRangeRowModels);
        this.validRangeRowModels.clear();
        this.validRangeRowModels.addAll(validRangeRowModels);
        firePropertyChanged(PROPERTY_VALID_RANGE_ROW_MODELS, oldValue, validRangeRowModels);
    }

    public void addValidRangeRow(RangeRowModel row) {
        Object oldValue = new ArrayList<RangeRowModel>(validRangeRowModels);
        validRangeRowModels.add(row);
        firePropertyChanged(PROPERTY_VALID_RANGE_ROW_MODELS, oldValue, validRangeRowModels);
    }

    public void removeValidRangeRow(RangeRowModel row) {
        Object oldValue = new ArrayList<RangeRowModel>(validRangeRowModels);
        validRangeRowModels.remove(row);
        firePropertyChanged(PROPERTY_VALID_RANGE_ROW_MODELS, oldValue, validRangeRowModels);
    }

    public boolean isValid(String field) {
        boolean result = getDemandType() == null;
        if (!result) {
            if (PROPERTY_CLIENT_CODE.equals(field)) {
                result = !getDemandType().containsFields(MailField.CLIENT)
                            || StringUtils.isNotBlank(getClientCode());

            } else if (PROPERTY_VALID_RANGE_ROW_MODELS.equals(field)) {
                result = !getDemandType().containsFields(MailField.RANGE_ROW)
                            || CollectionUtils.isNotEmpty(getValidRangeRowModels());

            } else if (Email.PROPERTY_PROJECT_REFERENCE.equals(field)) {
                result = !getDemandType().containsFields(MailField.PROJECT_REFERENCE)
                            || StringUtils.isNotBlank(getProjectReference());

            } else if (Email.PROPERTY_OBJECT.equals(field)) {
                result = !getDemandType().containsFields(MailField.OBJECT)
                            || StringUtils.isNotBlank(getObject());

            } else if (Email.PROPERTY_COMMENT.equals(field)) {
                result = !getDemandType().containsFields(MailField.COMMENT)
                        || StringUtils.isNotBlank(getComment());

            } else if (Email.PROPERTY_COMPANY_REFERENCE.equals(field)) {
                result = !getDemandType().containsFields(MailField.COMPANY_REFERENCE)
                        || StringUtils.isNotBlank(getCompanyReference());

            } else if (Email.PROPERTY_PRIORITY.equals(field)) {
                result = !getDemandType().containsFields(MailField.PRIORITY)
                        || getPriority() != null;

            } else if (Email.PROPERTY_ETAT_ATTENTE.equals(field)) {
                result = !getDemandType().containsFields(MailField.ETAT_ATTENTE)
                        || getEtatAttente() != null;
            }
        }
        return result;
    }

    @Override
    protected Email newEntity() {
        return new EmailImpl();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().isAssignableFrom(DemandeUIModel.class)) {
            return false;
        }
        DemandeUIModel other = (DemandeUIModel) obj;
        return editObject.equals(other.editObject);
    }

    protected void decomposeEmail() {
        try {
            // ce code peut provoquer une NPE avec les données de test
            Message message = new MimeMessage(null, new ByteArrayInputStream(getOriginalEmail().getBytes()));
            subject = message.getSubject();

            toRecipients = new ArrayList<String>();
            ccRecipients = new ArrayList<String>();
            Address[] recipients = message.getRecipients(Message.RecipientType.TO);
            if (recipients != null) {
                for (Address address : recipients) {
                    toRecipients.add(address.toString());
                }
            }
            recipients = message.getRecipients(Message.RecipientType.CC);
            if (recipients != null) {
                for (Address address : recipients) {
                    ccRecipients.add(address.toString());
                }
            }

            if (message.isMimeType("multipart/*")) {
                decomposeMultipartEmail(message);

            } else {
                String content = IOUtils.toString(message.getInputStream());
                plainContent = content;
            }

        } catch (Exception e) {
            //TODO kmorin 20140516 do something when we use the real data
            if (log.isErrorEnabled()) {
                log.error("", e);
            }
        }
    }

    /**
     * Decompose a multipart part.
     * - sets the email content if the part contains a text bodypart
     * - adds attachments to the email
     *
     * @param part the part to decompose
     * @throws Exception
     */
    protected void decomposeMultipartEmail(Part part) throws Exception {
        DataSource dataSource = part.getDataHandler().getDataSource();
        MimeMultipart mimeMultipart = new MimeMultipart(dataSource);
        int multiPartCount = mimeMultipart.getCount();

        for (int j = 0; j < multiPartCount; j++) {
            BodyPart bp = mimeMultipart.getBodyPart(j);

            // if it is a text part, the,n this is the email content
            String disposition = bp.getDisposition();
            if (bp.isMimeType("text/*") && !Part.ATTACHMENT.equals(disposition)) {
                Charset charset = getCharset(bp);
                String content = IOUtils.toString(bp.getInputStream(), charset);
                if (bp.isMimeType("text/plain")) {
                    plainContent = content;
                } else {
                    htmlContent = content;
                }

            // if it is multipart part, decompose it
            } else if (bp.isMimeType("multipart/*")) {
                decomposeMultipartEmail(bp);
            }
        }
    }

    protected Charset getCharset(Part part) throws MessagingException {
        ContentType contentType = new ContentType(part.getContentType());
        String charsetName = contentType.getParameter("charset");
        Charset charset = Charsets.toCharset(charsetName);
        return charset;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public String getTitle() {
        String result = getObject();
        String ref = getReference();
        if (!ref.isEmpty()) {
            result = ref + " - " + result;
        }
        return result;
    }

    @Override
    public String getIcon() {
        return "email";
    }

    @Override
    public boolean isCloseable() {
        return closeable;
    }

    public void setCloseable(boolean closeable) {
        this.closeable = closeable;
    }
}
