package com.franciaflex.faxtomail.ui.swing.actions;

/*
 * #%L
 * FaxToMail :: UI
 * $Id: SaveAndOpenDialogAction.java 48 2014-04-25 13:43:04Z echatellier $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.2/faxtomail-ui-swing/src/main/java/com/franciaflex/faxtomail/ui/swing/actions/SaveAndOpenDialogAction.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;

import java.awt.*;

/**
 * @author Kevin Morin (Code Lutin)
 * @since x.x
 */
public class SaveAndOpenDialogAction extends SaveDemandeAction {

    protected boolean modal;
    protected FaxToMailUI dialogContent;
    protected String title;
    protected Dimension dimension;

    public SaveAndOpenDialogAction(DemandeUIHandler handler,
                                   boolean modal,
                                   FaxToMailUI dialogContent,
                                   String title,
                                   Dimension dimension) {
        super(handler);
        this.modal = modal;
        this.dialogContent = dialogContent;
        this.title = title;
        this.dimension = dimension;
    }

    @Override
    public void doAction() throws Exception {
        DemandeUIModel model = getModel();
        if (model.getTakenBy() == null) {
            model.setTakenBy(getContext().getCurrentUser());
        }

        if (getHandler().getMonitor().wasModified()) {
            super.doAction();
        }
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();

        DemandeUIHandler handler = getHandler();
        if (modal) {
            handler.openDialog(dialogContent, title, dimension);

        } else {
            handler.openFrame(dialogContent, title, dimension);
        }
    }
}
