/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.transmit;

import com.franciaflex.faxtomail.persistence.entities.EtatAttente;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.transmit.MailFolderChooserUI;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailUIHandler;
import com.franciaflex.faxtomail.ui.swing.util.Cancelable;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import com.franciaflex.faxtomail.ui.swing.util.FolderTreeNode;
import java.awt.Component;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MailFolderChooserUIHandler
extends AbstractFaxToMailUIHandler<DemandeUIModel, MailFolderChooserUI>
implements Cancelable {
    private static final Log log = LogFactory.getLog(MailFolderChooserUIHandler.class);

    public void afterInit(MailFolderChooserUI mailFolderChooserUI) {
        this.initUI(mailFolderChooserUI);
        DemandeUIModel model = (DemandeUIModel)this.getModel();
        EtatAttente etatAttente = model.getEtatAttente();
        Collection foldersWithEtatAttente = etatAttente != null ? this.getContext().getMailFolderService().getFoldersWithEtatAttente(etatAttente) : new HashSet();
        List folders = this.getContext().getMailFolderService().getRootMailFolders();
        JTree navigationTree = ((MailFolderChooserUI)this.ui).getNavigationTree();
        Map<MailFolder, DefaultMutableTreeNode> nodesByFolder = FaxToMailUIUtil.initFolderTree(this.getContext(), navigationTree, folders);
        MailFolder currentFolder = ((DemandeUIModel)this.getModel()).getMailFolder();
        for (MailFolder folder : nodesByFolder.keySet()) {
            DefaultMutableTreeNode node = nodesByFolder.get(folder);
            if (!node.getClass().isAssignableFrom(FolderTreeNode.class)) continue;
            FolderTreeNode folderTreeNode = (FolderTreeNode)node;
            folderTreeNode.setCanSelect(!currentFolder.equals(folder) && (CollectionUtils.isNotEmpty(foldersWithEtatAttente) || foldersWithEtatAttente.contains(folder)));
        }
        navigationTree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component component = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                FolderTreeNode node = (FolderTreeNode)value;
                this.setEnabled(node.isCanSelect());
                return component;
            }
        });
        navigationTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                FolderTreeNode folderNode = (FolderTreeNode)e.getPath().getLastPathComponent();
                MailFolder folder = folderNode.getMailFolder();
                if (!folderNode.isCanSelect()) {
                    folder = null;
                }
                ((DemandeUIModel)MailFolderChooserUIHandler.this.getModel()).setMailFolder(folder);
            }
        });
    }

    public void onCloseUI() {
    }

    public SwingValidator<DemandeUIModel> getValidator() {
        return null;
    }

    @Override
    public void cancel() {
        this.closeDialog();
    }

    protected JComponent getComponentToFocus() {
        return ((MailFolderChooserUI)this.ui).getNavigationTree();
    }
}

