/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.search;

import com.franciaflex.faxtomail.persistence.entities.DemandStatus;
import com.franciaflex.faxtomail.persistence.entities.MailField;
import com.franciaflex.faxtomail.services.service.ReferentielService;
import com.franciaflex.faxtomail.ui.swing.actions.SearchAction;
import com.franciaflex.faxtomail.ui.swing.actions.ShowDemandeListAction;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.search.SearchUI;
import com.franciaflex.faxtomail.ui.swing.content.search.SearchUIModel;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailDemandListHandler;
import com.franciaflex.faxtomail.ui.swing.util.CloseableUI;
import com.franciaflex.faxtomail.ui.swing.util.DemandeTableModel;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.action.AbstractApplicationAction;
import org.nuiton.jaxx.application.swing.table.AbstractApplicationTableModel;

public class SearchUIHandler
extends AbstractFaxToMailDemandListHandler<SearchUIModel, SearchUI>
implements CloseableUI {
    private static final Log log = LogFactory.getLog(SearchUIHandler.class);

    public void beforeInit(SearchUI ui) {
        super.beforeInit((ApplicationUI)ui);
        SearchUIModel searchUIModel = this.getContext().getSearch();
        if (searchUIModel == null) {
            searchUIModel = new SearchUIModel();
            Date now = new Date();
            Calendar cal = Calendar.getInstance();
            cal.add(2, -2);
            Date twoMonthsAgo = cal.getTime();
            searchUIModel.setMaxReceptionDate(now);
            searchUIModel.setMinReceptionDate(twoMonthsAgo);
        }
        ((SearchUI)this.getUI()).setContextValue(searchUIModel);
    }

    public void afterInit(SearchUI ui) {
        this.initUI(ui);
        ReferentielService referentielService = this.getContext().getReferentielService();
        SearchUIModel model = (SearchUIModel)((Object)this.getModel());
        this.initBeanFilterableComboBox(ui.getTakenByComboBox(), this.getContext().getUserService().getAllUsers(), model.getTakenBy());
        this.initBeanFilterableComboBox(ui.getModifiedByComboBox(), this.getContext().getUserService().getAllUsers(), model.getModifiedBy());
        this.initBeanFilterableComboBox(ui.getArchivedByComboBox(), this.getContext().getUserService().getAllUsers(), model.getArchivedBy());
        this.initBeanFilterableComboBox(ui.getTransferByComboBox(), this.getContext().getUserService().getAllUsers(), model.getTransferBy());
        this.initBeanFilterableComboBox(ui.getPrintedByComboBox(), this.getContext().getUserService().getAllUsers(), model.getPrintingBy());
        this.initBeanFilterableComboBox(ui.getRepliedByComboBox(), this.getContext().getUserService().getAllUsers(), model.getReplyBy());
        this.initCheckBoxComboBox(ui.getDocTypeComboBox(), referentielService.getAllDemandType(), model.getDemandType(), "demandType", true);
        this.initCheckBoxComboBox(ui.getPriorityComboBox(), referentielService.getAllPriority(), model.getPriority(), "priority", true);
        this.initCheckBoxComboBox(ui.getEtatAttenteComboBox(), referentielService.getAllEtatAttente(), model.getEtatAttente(), "etatAttente", true);
        this.initCheckBoxComboBox(ui.getStatusComboBox(), Arrays.asList(DemandStatus.values()), model.getDemandStatus(), "demandStatus", false);
        this.initCheckBoxComboBox(ui.getGammeComboBox(), referentielService.getAllRange(), model.getGamme(), "gamme", false);
        final JXTable dataTable = ((SearchUI)this.getUI()).getDataTable();
        dataTable.setSelectionMode(0);
        this.initDemandeTable(dataTable, true);
        model.addPropertyChangeListener("results", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                int row;
                List emails = (List)evt.getNewValue();
                AbstractApplicationTableModel dataTableModel = (AbstractApplicationTableModel)dataTable.getModel();
                dataTableModel.setRows(emails);
                SearchUIHandler.this.showInformationMessage(I18n.t((String)"faxtomail.search.resultNb", (Object[])new Object[]{emails.size()}));
                DemandeUIModel currentEmail = SearchUIHandler.this.getContext().getCurrentEmail();
                if (currentEmail != null && (row = dataTableModel.getRowIndex((Serializable)currentEmail)) > 0) {
                    dataTable.setRowSelectionInterval(row, row);
                }
            }
        });
        if (this.getContext().getSearch() != null) {
            try {
                SearchAction searchAction = (SearchAction)this.getContext().getActionFactory().createLogicAction((AbstractApplicationUIHandler)this, SearchAction.class);
                searchAction.doAction();
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"error while searching", (Throwable)e);
                }
                this.getContext().getErrorHelper().showErrorDialog(I18n.t((String)"faxtomail.search.action.error", (Object[])new Object[0]));
            }
        }
    }

    @Override
    protected Collection<String> getColumns() {
        Collection<String> columns = null;
        List tableColumns = this.getContext().getFaxToMailConfiguration().getSearchDisplayColumns();
        if (tableColumns != null) {
            Collections2.transform((Collection)tableColumns, (Function)new Function<MailField, String>(){

                public String apply(MailField field) {
                    return field.toString();
                }
            });
        }
        return columns;
    }

    protected JComponent getComponentToFocus() {
        return ((SearchUI)this.getUI()).getModifiedByComboBox();
    }

    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        this.clearValidators();
    }

    @Override
    public boolean quitUI() {
        return true;
    }

    public SwingValidator<SearchUIModel> getValidator() {
        return null;
    }

    protected void beforeOpenPopup(int rowIndex, int columnIndex) {
        super.beforeOpenPopup(rowIndex, columnIndex);
        int selectedRowCount = ((SearchUI)this.getUI()).getDataTable().getSelectedRowCount();
        SearchUIModel model = (SearchUIModel)((Object)this.getModel());
        model.setMenuEnabled(selectedRowCount == 1);
    }

    public void goToMenu() {
        JXTable dataTable = ((SearchUI)this.ui).getDataTable();
        int rowIndex = dataTable.getSelectedRow();
        rowIndex = dataTable.convertRowIndexToModel(rowIndex);
        DemandeUIModel selectedEmail = (DemandeUIModel)((DemandeTableModel)((Object)dataTable.getModel())).getEntry(rowIndex);
        this.getContext().setCurrentEmail(selectedEmail);
        this.getContext().setCurrentMailFolder(selectedEmail.getMailFolder());
        this.getContext().getActionEngine().runAction((AbstractApplicationAction)new ShowDemandeListAction(this.getContext().getMainUI().getHandler()));
    }

    @Override
    protected String[] getEditableTableProperties() {
        return new String[]{"attachment", "replies"};
    }
}

