/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.editor.gis;

import com.google.common.base.Preconditions;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatterFactory;
import jaxx.runtime.spi.UIHandler;
import jaxx.runtime.swing.editor.bean.BeanUIUtil;
import jaxx.runtime.swing.editor.gis.DmdCoordinate;
import jaxx.runtime.swing.editor.gis.DmdCoordinateConverter;
import jaxx.runtime.swing.editor.gis.DmdCoordinateEditor;
import jaxx.runtime.swing.editor.gis.DmdCoordinateEditorModel;
import jaxx.runtime.swing.editor.gis.MaskFormatterFromConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DmdCoordinateEditorHandler
implements UIHandler<DmdCoordinateEditor> {
    private static final Log log = LogFactory.getLog(DmdCoordinateEditorHandler.class);
    private DmdCoordinateEditor ui;
    protected Method signMutator;
    protected Method degreMutator;
    protected Method minuteMutator;
    protected Method decimalMutator;
    protected boolean valueIsAdjusting;
    protected boolean valueModelIsAdjusting;
    protected DmdCoordinateConverter signedConverter;
    protected DmdCoordinateConverter unsignedConverter;
    protected DefaultFormatterFactory signedFormatterFactory;
    protected DefaultFormatterFactory unsignedFormatterFactory;

    public void beforeInit(DmdCoordinateEditor ui) {
        this.ui = ui;
        this.signedConverter = new DmdCoordinateConverter();
        this.signedConverter.setUseSign(true);
        this.unsignedConverter = new DmdCoordinateConverter();
    }

    public void afterInit(DmdCoordinateEditor ui) {
    }

    public void init(boolean longitudeEditor) {
        MaskFormatterFromConverter<DmdCoordinate> maskFormatter;
        final DmdCoordinateEditorModel model = this.ui.getModel();
        Preconditions.checkNotNull((Object)model.getBean(), (Object)("could not find bean in " + this.ui));
        Preconditions.checkNotNull((Object)model.getPropertySign(), (Object)("could not find propertySign in " + this.ui));
        Preconditions.checkNotNull((Object)model.getPropertyDegree(), (Object)("could not find propertyDegree in " + this.ui));
        Preconditions.checkNotNull((Object)model.getPropertyMinute(), (Object)("could not find propertyMinute in " + this.ui));
        Preconditions.checkNotNull((Object)model.getPropertyDecimal(), (Object)("could not find propertyDecimal in " + this.ui));
        Serializable bean = model.getBean();
        this.signMutator = BeanUIUtil.getMutator(bean, model.getPropertySign());
        Preconditions.checkNotNull((Object)this.signMutator, (Object)("could not find mutator for " + model.getPropertySign()));
        this.degreMutator = BeanUIUtil.getMutator(bean, model.getPropertyDegree());
        Preconditions.checkNotNull((Object)this.degreMutator, (Object)("could not find mutator for " + model.getPropertyDegree()));
        this.minuteMutator = BeanUIUtil.getMutator(bean, model.getPropertyMinute());
        Preconditions.checkNotNull((Object)this.minuteMutator, (Object)("could not find mutator for " + model.getPropertyMinute()));
        this.decimalMutator = BeanUIUtil.getMutator(bean, model.getPropertyDecimal());
        Preconditions.checkNotNull((Object)this.decimalMutator, (Object)("could not find mutator for " + model.getPropertyDecimal()));
        this.signedConverter.setForLongitude(longitudeEditor);
        this.unsignedConverter.setForLongitude(longitudeEditor);
        String pattern = this.getMaskFormatterPattern(longitudeEditor, false);
        try {
            maskFormatter = MaskFormatterFromConverter.newFormatter(DmdCoordinate.class, pattern, this.unsignedConverter);
            maskFormatter.setValidCharacters(" 01234567890");
            maskFormatter.setCommitsOnValidEdit(true);
            this.unsignedFormatterFactory = new DefaultFormatterFactory(maskFormatter);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        pattern = this.getMaskFormatterPattern(longitudeEditor, true);
        try {
            maskFormatter = MaskFormatterFromConverter.newFormatter(DmdCoordinate.class, pattern, this.signedConverter);
            maskFormatter.setValidCharacters(" 01234567890");
            maskFormatter.setCommitsOnValidEdit(true);
            this.signedFormatterFactory = new DefaultFormatterFactory(maskFormatter);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        JFormattedTextField editor = this.ui.getEditor();
        editor.setFormatterFactory(model.isSign() ? this.signedFormatterFactory : this.unsignedFormatterFactory);
        editor.setFocusLostBehavior(0);
        editor.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DmdCoordinate newValue = (DmdCoordinate)((Object)evt.getNewValue());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Value has changed: " + (Object)((Object)newValue)));
                }
                model.setValue(newValue);
            }
        });
        model.addPropertyChangeListener("sign", new ModelPropertyChangeListener(model, this.signMutator));
        model.addPropertyChangeListener("degree", new ModelPropertyChangeListener(model, this.degreMutator));
        model.addPropertyChangeListener("minute", new ModelPropertyChangeListener(model, this.minuteMutator));
        model.addPropertyChangeListener("decimal", new ModelPropertyChangeListener(model, this.decimalMutator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(DmdCoordinate value, boolean pushToModel) {
        if (this.valueModelIsAdjusting) {
            return;
        }
        this.valueIsAdjusting = !pushToModel;
        try {
            this.ui.getEditor().setValue((Object)value);
        }
        finally {
            this.valueIsAdjusting = false;
        }
    }

    public void resetEditor() {
        this.setValue(null, true);
        this.ui.getEditor().setFormatterFactory(this.unsignedFormatterFactory);
    }

    public void onKeyReleased(KeyEvent e) {
        JFormattedTextField source = (JFormattedTextField)e.getSource();
        char keyChar = e.getKeyChar();
        int caretPosition = source.getCaretPosition();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Key pressed: " + keyChar + " (caret position: " + caretPosition + ")"));
        }
        if (keyChar == '-') {
            DefaultFormatterFactory newFactory;
            DmdCoordinate value = (DmdCoordinate)((Object)source.getValue());
            boolean useSign = this.ui.getModel().isSign();
            if (useSign) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Switch to unsigned");
                }
                newFactory = this.unsignedFormatterFactory;
                --caretPosition;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Switch to signed");
                }
                newFactory = this.signedFormatterFactory;
                ++caretPosition;
            }
            DmdCoordinate newValue = DmdCoordinate.valueOf(value);
            newValue.setSign(!useSign);
            source.setFormatterFactory(newFactory);
            source.setValue((Object)newValue);
            e.consume();
            source.setCaretPosition(caretPosition);
        }
    }

    protected String getMaskFormatterPattern(boolean longitudeEditor, boolean useSign) {
        String pattern = "**\u00b0**''**";
        if (longitudeEditor) {
            pattern = "*" + pattern;
        }
        if (useSign) {
            pattern = "-" + pattern;
        }
        return pattern;
    }

    private class ModelPropertyChangeListener
    implements PropertyChangeListener {
        private final DmdCoordinateEditorModel model;
        private final Method mutator;

        private ModelPropertyChangeListener(DmdCoordinateEditorModel model, Method mutator) {
            this.model = model;
            this.mutator = mutator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!DmdCoordinateEditorHandler.this.valueIsAdjusting) {
                Object newValue = evt.getNewValue();
                try {
                    DmdCoordinateEditorHandler.this.valueModelIsAdjusting = true;
                    try {
                        this.mutator.invoke((Object)this.model.getBean(), newValue);
                    }
                    finally {
                        DmdCoordinateEditorHandler.this.valueModelIsAdjusting = false;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

