package com.franciaflex.faxtomail.ui.swing.actions;

/*
 * #%L
 * FaxToMail :: UI
 * $Id: SaveDemandeAction.java 116 2014-05-30 20:43:45Z kmorin $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.1/faxtomail-ui-swing/src/main/java/com/franciaflex/faxtomail/ui/swing/actions/SaveDemandeAction.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.persistence.TopiaEntities;
import org.nuiton.util.beans.BeanMonitor;

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.EmailImpl;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.RangeRow;
import com.franciaflex.faxtomail.services.service.InvalidClientException;
import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUI;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.RangeRowModel;
import com.google.common.collect.Maps;

import static org.nuiton.i18n.I18n.t;

/**
 * @author Kevin Morin (Code Lutin)
 * @since x.x
 */
public class SaveDemandeAction extends AbstractFaxToMailAction<DemandeUIModel, DemandeUI, DemandeUIHandler> {

    public SaveDemandeAction(DemandeUIHandler handler) {
        super(handler, false);
        setActionDescription(t("faxtomail.action.save.tip"));
    }

    @Override
    public void doAction() throws Exception {
        DemandeUIModel model = getModel();
        FaxToMailUIContext context = getContext();

        Email persistedEmail;
        String topiaId = model.getTopiaId();
        if (!StringUtils.isBlank(topiaId)) {
            persistedEmail = context.getEmailService().getEmailById(topiaId);
        } else {
            persistedEmail = new EmailImpl();
        }

        Collection<RangeRowModel> rows = model.getValidRangeRowModels();
        Collection<RangeRow> rangeRows = model.getRangeRow();
        if (rangeRows == null) {
            rangeRows = new ArrayList<>();
        }

        Map<String, RangeRow> rangeRowsById = Maps.uniqueIndex(rangeRows, TopiaEntities.getTopiaIdFunction());

        model.setRangeRow(new ArrayList<RangeRow>());
        for (RangeRowModel rangeRowModel : rows) {
            RangeRow rangeRow = rangeRowsById.get(rangeRowModel.getTopiaId());
            if (rangeRow == null) {
                model.addRangeRow(rangeRowModel.toEntity());
            } else {
                model.addRangeRow(rangeRowModel.toEntity(rangeRow));
            }
        }

        FaxToMailUser currentUser = context.getCurrentUser();
        Email email = model.toEntity(persistedEmail);
        Collection<Attachment> attachments = model.getAttachment();
        String clientCode = model.getClientCode();

        BeanMonitor monitor = getHandler().getMonitor();

        String[] modifiedProperties = monitor.getModifiedProperties();
        email = context.getEmailService().saveEmail(email, attachments, clientCode, currentUser, modifiedProperties);

        model.fromEntity(email);

        getModel().setModify(false);
        monitor.clearModified();
    }

    public void postFailedAction(Throwable error) {

        if (error instanceof InvalidClientException) {
            DemandeUIModel model = getModel();
//            BeanMonitor monitor = getHandler().getMonitor();
//            String previousClientCode = (String) monitor.getOriginalValues().get(DemandeUIModel.PROPERTY_CLIENT_CODE);
            model.setClientCode(null);
        }
    }
}
