/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.services.service;

import com.franciaflex.faxtomail.persistence.entities.Client;
import com.franciaflex.faxtomail.persistence.entities.ClientImpl;
import com.franciaflex.faxtomail.persistence.entities.ClientTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.NewClient;
import com.franciaflex.faxtomail.services.FaxToMailServiceSupport;
import com.franciaflex.faxtomail.services.service.ClientService;
import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.support.TopiaSqlSupport;
import org.nuiton.topia.persistence.support.TopiaSqlWork;

public class ClientServiceImpl
extends FaxToMailServiceSupport
implements ClientService {
    private static final Log log = LogFactory.getLog(ClientServiceImpl.class);

    @Override
    public Client getClientForEmailAddress(String emailAddress, Email email, String company, String brand) {
        Preconditions.checkNotNull((Object)email);
        Preconditions.checkNotNull((Object)emailAddress);
        ClientTopiaDao clientDao = this.getPersistenceContext().getClientDao();
        Client client = null;
        if (StringUtils.isNotBlank((CharSequence)emailAddress)) {
            String faxNumber;
            List clients = clientDao.forEmailAddressesJsonLike(emailAddress);
            if (CollectionUtils.isEmpty((Collection)clients) && StringUtils.isNumeric((CharSequence)(faxNumber = emailAddress.substring(0, emailAddress.indexOf(64)).replaceAll(" ", "")))) {
                emailAddress = StringUtils.leftPad((String)faxNumber, (int)10, (char)'0');
                clients = clientDao.forFaxNumbersJsonLike(emailAddress);
                email.setFax(true);
            }
            if (CollectionUtils.isNotEmpty((Collection)clients)) {
                int i = 0;
                while (client == null && i < clients.size()) {
                    Client c = (Client)clients.get(i++);
                    if (!StringUtils.isBlank((CharSequence)company) && !Objects.equals(company, c.getCompany()) || !StringUtils.isBlank((CharSequence)brand) && !Objects.equals(StringUtils.lowerCase((String)brand), StringUtils.lowerCase((String)c.getBrand()))) continue;
                    client = c;
                }
            }
        }
        email.setSender(emailAddress);
        return client;
    }

    @Override
    public Client getClientForCode(String code, String company) {
        ClientTopiaDao clientDao = this.getPersistenceContext().getClientDao();
        Client client = null;
        if (StringUtils.isNotBlank((CharSequence)code)) {
            TopiaQueryBuilderAddCriteriaOrRunQueryStep ctqbacorqs = clientDao.forCodeEquals(code);
            if (StringUtils.isNotBlank((CharSequence)company)) {
                ctqbacorqs = ctqbacorqs.addEquals("company", (Object)company);
            }
            client = (Client)ctqbacorqs.findAnyOrNull();
        }
        return client;
    }

    @Override
    public void updateNewClients() {
        final ClientTopiaDao clientDao = this.getPersistenceContext().getClientDao();
        final FaxToMailUserTopiaDao faxToMailUserDao = this.getPersistenceContext().getFaxToMailUserDao();
        TopiaSqlSupport sqlSupport = this.getPersistenceContext().getSqlSupport();
        sqlSupport.doSqlWork(new TopiaSqlWork(){

            public void execute(Connection connection) throws SQLException {
                int importedCount = 0;
                String query = String.format("SELECT %s, %s, %s, %s, %s, %s, %s, %s, %s, %s FROM %s", "name", "emailAddress", "faxNumber", "caracteristic1", "caracteristic2", "caracteristic3", "code", "brand", "company", "personInCharge", NewClient.class.getSimpleName());
                Statement stat = connection.createStatement();
                ResultSet resultSet = stat.executeQuery(query);
                MultiKeyMap clientCache = new MultiKeyMap();
                while (resultSet.next()) {
                    Client client;
                    String name = resultSet.getString("name");
                    String emailAddress = resultSet.getString("emailAddress");
                    String faxNumber = resultSet.getString("faxNumber");
                    String caracteristic1 = resultSet.getString("caracteristic1");
                    String caracteristic2 = resultSet.getString("caracteristic2");
                    String caracteristic3 = resultSet.getString("caracteristic3");
                    String code = resultSet.getString("code");
                    String brand = resultSet.getString("brand");
                    String company = resultSet.getString("company");
                    String personInCharge = resultSet.getString("personInCharge");
                    if ("null".equalsIgnoreCase(caracteristic1)) {
                        caracteristic1 = null;
                    }
                    if ("null".equalsIgnoreCase(caracteristic2)) {
                        caracteristic2 = null;
                    }
                    if ("null".equalsIgnoreCase(caracteristic3)) {
                        caracteristic3 = null;
                    }
                    if ("null".equalsIgnoreCase(brand)) {
                        brand = null;
                    }
                    if ("null".equalsIgnoreCase(emailAddress)) {
                        emailAddress = null;
                    }
                    if (faxNumber != null && ((faxNumber = StringUtils.removePattern((String)faxNumber, (String)"[^0-9]")).isEmpty() || faxNumber.equals("0"))) {
                        faxNumber = null;
                    }
                    if ((client = (Client)clientCache.get((Object)code, (Object)company)) == null) {
                        client = (Client)clientDao.forCodeEquals(code).addEquals("company", (Object)company).findUniqueOrNull();
                        if (client == null) {
                            client = new ClientImpl();
                            client.setCode(code);
                            client.setCompany(company);
                        }
                        client.setName(name);
                        client.setCaracteristic1(caracteristic1);
                        client.setCaracteristic2(caracteristic2);
                        client.setCaracteristic3(caracteristic3);
                        client.setBrand(brand);
                        client.setEmailAddresses(null);
                        client.setFaxNumbers(null);
                        FaxToMailUser faxToMailUserInCharge = null;
                        if (StringUtils.isNotBlank((CharSequence)personInCharge)) {
                            faxToMailUserInCharge = (FaxToMailUser)faxToMailUserDao.forLoginEquals(personInCharge).findUniqueOrNull();
                        }
                        client.setPersonInCharge(faxToMailUserInCharge);
                        client = client.isPersisted() ? (Client)clientDao.update((TopiaEntity)client) : (Client)clientDao.create((TopiaEntity)client);
                        clientCache.put((Object)code, (Object)company, (Object)client);
                    }
                    if (StringUtils.isNotBlank((CharSequence)emailAddress)) {
                        ArrayList<String> currentAddresses = client.getEmailAddresses();
                        if (currentAddresses == null) {
                            currentAddresses = new ArrayList<String>();
                        }
                        currentAddresses.add(emailAddress);
                        client.setEmailAddresses(currentAddresses);
                        client = (Client)clientDao.update((TopiaEntity)client);
                    }
                    if (StringUtils.isNotBlank((CharSequence)faxNumber)) {
                        ArrayList<String> faxNumbers = client.getFaxNumbers();
                        if (faxNumbers == null) {
                            faxNumbers = new ArrayList<String>();
                        }
                        faxNumbers.add(faxNumber);
                        client.setFaxNumbers(faxNumbers);
                        client = (Client)clientDao.update((TopiaEntity)client);
                    }
                    ++importedCount;
                }
                stat = connection.createStatement();
                stat.execute("DELETE FROM " + NewClient.class.getSimpleName());
                if (importedCount > 0 && log.isInfoEnabled()) {
                    log.info((Object)String.format("Imported %d new client rows", importedCount));
                }
            }
        });
        this.getPersistenceContext().commit();
    }
}

