/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.services.service;

import com.franciaflex.faxtomail.persistence.entities.Client;
import com.franciaflex.faxtomail.persistence.entities.ClientTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.services.FaxToMailServiceSupport;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientService
extends FaxToMailServiceSupport {
    private static final Log log = LogFactory.getLog(ClientService.class);

    public Client getClientForEmailAddress(String emailAddress, Email email) {
        Preconditions.checkNotNull((Object)email);
        Preconditions.checkNotNull((Object)emailAddress);
        ClientTopiaDao clientDao = this.getPersistenceContext().getClientDao();
        Client client = null;
        if (StringUtils.isNotBlank((CharSequence)emailAddress)) {
            List clients = clientDao.forEmailAddressEquals(emailAddress).findAll();
            if (CollectionUtils.isEmpty((Collection)clients) && NumberUtils.isNumber((String)(emailAddress = emailAddress.substring(0, emailAddress.indexOf(64))))) {
                emailAddress = StringUtils.leftPad((String)emailAddress, (int)10, (char)'0');
                clients = clientDao.forFaxNumberEquals(emailAddress).findAll();
                email.setFax(true);
            }
            if (CollectionUtils.isNotEmpty((Collection)clients)) {
                MailFolder folder;
                if (clients.size() == 1) {
                    client = (Client)clients.get(0);
                } else if (folder != null) {
                    ImmutableListMultimap clientsByBrand = Multimaps.index((Iterable)clients, (Function)new Function<Client, String>(){

                        public String apply(Client client) {
                            return client.getBrand();
                        }
                    });
                    Set brands = clientsByBrand.keySet();
                    for (folder = email.getMailFolder(); client == null && folder != null; folder = folder.getParent()) {
                        if (!brands.contains(folder.getName())) continue;
                        client = (Client)new ArrayList(clientsByBrand.get((Object)folder.getName())).get(0);
                    }
                }
            }
        }
        return client;
    }

    public Client getClientForCode(String code) {
        ClientTopiaDao clientDao = this.getPersistenceContext().getClientDao();
        Client client = null;
        if (StringUtils.isNotBlank((CharSequence)code)) {
            client = (Client)clientDao.forCodeEquals(code).findAnyOrNull();
        }
        return client;
    }
}

