package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2014 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

/**
 * Required email fields for specific {@link WaitingState}.
 * 
 * @author Eric Chatellier
 */
public enum MailField {

    OBJECT,
    PROJECT_REFERENCE,
    PRIORITY,
    RANGE_ROW,
    CLIENT,
    WAITING_STATE,
    COMPANY_REFERENCE,
    COMMENT,
    DEMAND_TYPE,
    CLIENT_CODE,
    CLIENT_BRAND,
    SENDER,
    REFERENCE,
    RECEPTION_DATE,
    RECIPIENT,
    DEMAND_STATUS,
    PF_NB,
    SAV_NB,
    QUOTATION_NB,
    TAKEN_BY,
    LAST_ATTACHMENT_OPENING_IN_THIS_FOLDER_USER,
    REPLIES,
    ATTACHMENT,
    GROUP,
    EDI_RETURN;

    public static MailField[] getCanBeRequiredMailFields() {
        return new MailField[] {
                OBJECT,
                PROJECT_REFERENCE,
                PRIORITY,
                RANGE_ROW,
                CLIENT,
                WAITING_STATE,
                COMPANY_REFERENCE,
                COMMENT
        };
    }

    public static MailField[] getTableFields() {
        return new MailField[] {
                PRIORITY,
                DEMAND_TYPE,
                OBJECT,
                CLIENT_CODE,
                CLIENT_BRAND,
                SENDER,
                PROJECT_REFERENCE,
                COMPANY_REFERENCE,
                REFERENCE,
                RECEPTION_DATE,
                RECIPIENT,
                DEMAND_STATUS,
                WAITING_STATE,
                RANGE_ROW,
                PF_NB,
                SAV_NB,
                QUOTATION_NB,
                TAKEN_BY,
                COMMENT,
                EDI_RETURN,
                LAST_ATTACHMENT_OPENING_IN_THIS_FOLDER_USER,
                REPLIES,
                ATTACHMENT,
                GROUP
        };
    }
}
