package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Mon Nov 16 15:20:41 CET 2015")
public abstract class EmailAbstract extends AbstractTopiaEntity implements Email {

    /**
     * Nom de l'attribut en BD : receptionDate
     */
    protected Date receptionDate;

    /**
     * Nom de l'attribut en BD : ediError
     */
    protected String ediError;

    /**
     * Nom de l'attribut en BD : projectReference
     */
    protected String projectReference;

    /**
     * Nom de l'attribut en BD : sender
     */
    protected String sender;

    /**
     * Nom de l'attribut en BD : fax
     */
    protected boolean fax;

    /**
     * Nom de l'attribut en BD : recipient
     */
    protected String recipient;

    /**
     * Champ metier objet qui est la concaténation des differentes caractéristique de la demande (différent de l'objet du mail)
     * Nom de l'attribut en BD : object
     */
    protected String object;

    /**
     * Nom de l'attribut en BD : archiveDate
     */
    protected Date archiveDate;

    /**
     * Nom de l'attribut en BD : companyReference
     */
    protected String companyReference;

    /**
     * Nom de l'attribut en BD : comment
     */
    protected String comment;

    /**
     * Nom de l'attribut en BD : mailFolder
     */
    protected MailFolder mailFolder;

    /**
     * Nom de l'attribut en BD : demandType
     */
    protected DemandType demandType;

    /**
     * Nom de l'attribut en BD : priority
     */
    protected Priority priority;

    /**
     * Nom de l'attribut en BD : history
     */
    protected Collection<History> history;

    /**
     * Nom de l'attribut en BD : waitingState
     */
    protected WaitingState waitingState;

    /**
     * Nom de l'attribut en BD : takenBy
     */
    protected FaxToMailUser takenBy;

    /**
     * Nom de l'attribut en BD : rangeRow
     */
    protected List<RangeRow> rangeRow;

    /**
     * Nom de l'attribut en BD : client
     */
    protected Client client;

    /**
     * Nom de l'attribut en BD : demandStatus
     */
    protected DemandStatus demandStatus;

    /**
     * Nom de l'attribut en BD : emailGroup
     */
    protected EmailGroup emailGroup;

    /**
     * Nom de l'attribut en BD : replies
     */
    protected List<Reply> replies;

    /**
     * Nom de l'attribut en BD : lastAttachmentOpener
     */
    protected FaxToMailUser lastAttachmentOpener;

    /**
     * Nom de l'attribut en BD : attachment
     */
    protected Collection<Attachment> attachment;

    /**
     * Nom de l'attribut en BD : originalEmail
     */
    protected OriginalEmail originalEmail;

    private static final long serialVersionUID = 3977302110440272435L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_RECEPTION_DATE, Date.class, receptionDate);
        visitor.visit(this, PROPERTY_EDI_ERROR, String.class, ediError);
        visitor.visit(this, PROPERTY_PROJECT_REFERENCE, String.class, projectReference);
        visitor.visit(this, PROPERTY_SENDER, String.class, sender);
        visitor.visit(this, PROPERTY_FAX, boolean.class, fax);
        visitor.visit(this, PROPERTY_RECIPIENT, String.class, recipient);
        visitor.visit(this, PROPERTY_OBJECT, String.class, object);
        visitor.visit(this, PROPERTY_ARCHIVE_DATE, Date.class, archiveDate);
        visitor.visit(this, PROPERTY_COMPANY_REFERENCE, String.class, companyReference);
        visitor.visit(this, PROPERTY_COMMENT, String.class, comment);
        visitor.visit(this, PROPERTY_MAIL_FOLDER, MailFolder.class, mailFolder);
        visitor.visit(this, PROPERTY_DEMAND_TYPE, DemandType.class, demandType);
        visitor.visit(this, PROPERTY_PRIORITY, Priority.class, priority);
        visitor.visit(this, PROPERTY_HISTORY, Collection.class, History.class, history);
        visitor.visit(this, PROPERTY_WAITING_STATE, WaitingState.class, waitingState);
        visitor.visit(this, PROPERTY_TAKEN_BY, FaxToMailUser.class, takenBy);
        visitor.visit(this, PROPERTY_RANGE_ROW, List.class, RangeRow.class, rangeRow);
        visitor.visit(this, PROPERTY_CLIENT, Client.class, client);
        visitor.visit(this, PROPERTY_DEMAND_STATUS, DemandStatus.class, demandStatus);
        visitor.visit(this, PROPERTY_EMAIL_GROUP, EmailGroup.class, emailGroup);
        visitor.visit(this, PROPERTY_REPLIES, List.class, Reply.class, replies);
        visitor.visit(this, PROPERTY_LAST_ATTACHMENT_OPENER, FaxToMailUser.class, lastAttachmentOpener);
        visitor.visit(this, PROPERTY_ATTACHMENT, Collection.class, Attachment.class, attachment);
        visitor.visit(this, PROPERTY_ORIGINAL_EMAIL, OriginalEmail.class, originalEmail);
    }

    @Override
    public void setReceptionDate(Date receptionDate) {
        this.receptionDate = receptionDate;
    }

    @Override
    public Date getReceptionDate() {
        Date result = this.receptionDate;
        return result;
    }

    @Override
    public void setEdiError(String ediError) {
        this.ediError = ediError;
    }

    @Override
    public String getEdiError() {
        String result = this.ediError;
        return result;
    }

    @Override
    public void setProjectReference(String projectReference) {
        this.projectReference = projectReference;
    }

    @Override
    public String getProjectReference() {
        String result = this.projectReference;
        return result;
    }

    @Override
    public void setSender(String sender) {
        this.sender = sender;
    }

    @Override
    public String getSender() {
        String result = this.sender;
        return result;
    }

    @Override
    public void setFax(boolean fax) {
        this.fax = fax;
    }

    @Override
    public boolean isFax() {
        boolean result = this.fax;
        return result;
    }

    @Override
    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    @Override
    public String getRecipient() {
        String result = this.recipient;
        return result;
    }

    @Override
    public void setObject(String object) {
        this.object = object;
    }

    @Override
    public String getObject() {
        String result = this.object;
        return result;
    }

    @Override
    public void setArchiveDate(Date archiveDate) {
        this.archiveDate = archiveDate;
    }

    @Override
    public Date getArchiveDate() {
        Date result = this.archiveDate;
        return result;
    }

    @Override
    public void setCompanyReference(String companyReference) {
        this.companyReference = companyReference;
    }

    @Override
    public String getCompanyReference() {
        String result = this.companyReference;
        return result;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public String getComment() {
        String result = this.comment;
        return result;
    }

    @Override
    public void setMailFolder(MailFolder mailFolder) {
        this.mailFolder = mailFolder;
    }

    @Override
    public MailFolder getMailFolder() {
        MailFolder result = this.mailFolder;
        return result;
    }

    @Override
    public void setDemandType(DemandType demandType) {
        this.demandType = demandType;
    }

    @Override
    public DemandType getDemandType() {
        DemandType result = this.demandType;
        return result;
    }

    @Override
    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    @Override
    public Priority getPriority() {
        Priority result = this.priority;
        return result;
    }

    @Override
    public void addHistory(History history) {
        if (this.history == null) {
            this.history = new LinkedList<History>();
        }
        history.setEmail(this);
        this.history.add(history);
    }

    @Override
    public void addAllHistory(Collection<History> history) {
        if (history == null) {
            return;
        }
        for (History item : history) {
            addHistory(item);
        }
    }

    @Override
    public void setHistory(Collection<History> history) {
        this.history = history;
    }

    @Override
    public void removeHistory(History history) {
        if (this.history == null || !this.history.remove(history)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        history.setEmail(null);
    }

    @Override
    public void clearHistory() {
        if (this.history == null) {
            return;
        }
        for (History item : this.history) {
            item.setEmail(null);
        }
        this.history.clear();
    }

    @Override
    public Collection<History> getHistory() {
        return history;
    }

    @Override
    public History getHistoryByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(history, topiaId);
    }

    @Override
    public Collection<String> getHistoryTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.History> tmp = getHistory();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeHistory() {
        if (history == null) {
            return 0;
        }
        return history.size();
    }

    @Override
    public boolean isHistoryEmpty() {
        int size = sizeHistory();
        return size == 0;
    }

    @Override
    public boolean isHistoryNotEmpty() {
        boolean empty = isHistoryEmpty();
        return ! empty;
    }

    @Override
    public boolean containsHistory(History history) {
        boolean contains = this.history !=null && this.history.contains(history);
        return contains;
    }

    @Override
    public void setWaitingState(WaitingState waitingState) {
        this.waitingState = waitingState;
    }

    @Override
    public WaitingState getWaitingState() {
        WaitingState result = this.waitingState;
        return result;
    }

    @Override
    public void setTakenBy(FaxToMailUser takenBy) {
        this.takenBy = takenBy;
    }

    @Override
    public FaxToMailUser getTakenBy() {
        FaxToMailUser result = this.takenBy;
        return result;
    }

    @Override
    public void addRangeRow(RangeRow rangeRow) {
        if (this.rangeRow == null) {
            this.rangeRow = new LinkedList<RangeRow>();
        }
        this.rangeRow.add(rangeRow);
    }

    @Override
    public void addRangeRow(int index, RangeRow rangeRow) {
        if (this.rangeRow == null) {
            this.rangeRow = new LinkedList<RangeRow>();
        }
        this.rangeRow.add(index, rangeRow);
    }

    @Override
    public void addAllRangeRow(List<RangeRow> rangeRow) {
        if (rangeRow == null) {
            return;
        }
        for (RangeRow item : rangeRow) {
            addRangeRow(item);
        }
    }

    @Override
    public void setRangeRow(List<RangeRow> rangeRow) {
        this.rangeRow = rangeRow;
    }

    @Override
    public void removeRangeRow(RangeRow rangeRow) {
        if (this.rangeRow == null || !this.rangeRow.remove(rangeRow)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void removeRangeRow(int index) {
        if (this.rangeRow == null) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        RangeRow oldValue = this.rangeRow.remove(index);
        if (oldValue == null) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearRangeRow() {
        if (this.rangeRow == null) {
            return;
        }
        this.rangeRow.clear();
    }

    @Override
    public List<RangeRow> getRangeRow() {
        return rangeRow;
    }

    @Override
    public RangeRow getRangeRow(int index) {
        return TopiaEntityHelper.getEntityByIndex(rangeRow, index);
    }

    @Override
    public RangeRow getRangeRowByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(rangeRow, topiaId);
    }

    @Override
    public List<String> getRangeRowTopiaIds() {
        List<String> topiaIds = new LinkedList<String>();
        List<com.franciaflex.faxtomail.persistence.entities.RangeRow> tmp = getRangeRow();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeRangeRow() {
        if (rangeRow == null) {
            return 0;
        }
        return rangeRow.size();
    }

    @Override
    public boolean isRangeRowEmpty() {
        int size = sizeRangeRow();
        return size == 0;
    }

    @Override
    public boolean isRangeRowNotEmpty() {
        boolean empty = isRangeRowEmpty();
        return ! empty;
    }

    @Override
    public boolean containsRangeRow(RangeRow rangeRow) {
        boolean contains = this.rangeRow !=null && this.rangeRow.contains(rangeRow);
        return contains;
    }

    @Override
    public void setClient(Client client) {
        this.client = client;
    }

    @Override
    public Client getClient() {
        Client result = this.client;
        return result;
    }

    @Override
    public void setDemandStatus(DemandStatus demandStatus) {
        this.demandStatus = demandStatus;
    }

    @Override
    public DemandStatus getDemandStatus() {
        DemandStatus result = this.demandStatus;
        return result;
    }

    @Override
    public void setEmailGroup(EmailGroup emailGroup) {
        this.emailGroup = emailGroup;
    }

    @Override
    public EmailGroup getEmailGroup() {
        EmailGroup result = this.emailGroup;
        return result;
    }

    @Override
    public void addReplies(Reply replies) {
        if (this.replies == null) {
            this.replies = new LinkedList<Reply>();
        }
        this.replies.add(replies);
    }

    @Override
    public void addReplies(int index, Reply replies) {
        if (this.replies == null) {
            this.replies = new LinkedList<Reply>();
        }
        this.replies.add(index, replies);
    }

    @Override
    public void addAllReplies(List<Reply> replies) {
        if (replies == null) {
            return;
        }
        for (Reply item : replies) {
            addReplies(item);
        }
    }

    @Override
    public void setReplies(List<Reply> replies) {
        this.replies = replies;
    }

    @Override
    public void removeReplies(Reply replies) {
        if (this.replies == null || !this.replies.remove(replies)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void removeReplies(int index) {
        if (this.replies == null) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        Reply oldValue = this.replies.remove(index);
        if (oldValue == null) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearReplies() {
        if (this.replies == null) {
            return;
        }
        this.replies.clear();
    }

    @Override
    public List<Reply> getReplies() {
        return replies;
    }

    @Override
    public Reply getReplies(int index) {
        return TopiaEntityHelper.getEntityByIndex(replies, index);
    }

    @Override
    public Reply getRepliesByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(replies, topiaId);
    }

    @Override
    public List<String> getRepliesTopiaIds() {
        List<String> topiaIds = new LinkedList<String>();
        List<com.franciaflex.faxtomail.persistence.entities.Reply> tmp = getReplies();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeReplies() {
        if (replies == null) {
            return 0;
        }
        return replies.size();
    }

    @Override
    public boolean isRepliesEmpty() {
        int size = sizeReplies();
        return size == 0;
    }

    @Override
    public boolean isRepliesNotEmpty() {
        boolean empty = isRepliesEmpty();
        return ! empty;
    }

    @Override
    public boolean containsReplies(Reply replies) {
        boolean contains = this.replies !=null && this.replies.contains(replies);
        return contains;
    }

    @Override
    public void setLastAttachmentOpener(FaxToMailUser lastAttachmentOpener) {
        this.lastAttachmentOpener = lastAttachmentOpener;
    }

    @Override
    public FaxToMailUser getLastAttachmentOpener() {
        FaxToMailUser result = this.lastAttachmentOpener;
        return result;
    }

    @Override
    public void addAttachment(Attachment attachment) {
        if (this.attachment == null) {
            this.attachment = new LinkedList<Attachment>();
        }
        attachment.setEmail(this);
        this.attachment.add(attachment);
    }

    @Override
    public void addAllAttachment(Collection<Attachment> attachment) {
        if (attachment == null) {
            return;
        }
        for (Attachment item : attachment) {
            addAttachment(item);
        }
    }

    @Override
    public void setAttachment(Collection<Attachment> attachment) {
        this.attachment = attachment;
    }

    @Override
    public void removeAttachment(Attachment attachment) {
        if (this.attachment == null || !this.attachment.remove(attachment)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        attachment.setEmail(null);
    }

    @Override
    public void clearAttachment() {
        if (this.attachment == null) {
            return;
        }
        for (Attachment item : this.attachment) {
            item.setEmail(null);
        }
        this.attachment.clear();
    }

    @Override
    public Collection<Attachment> getAttachment() {
        return attachment;
    }

    @Override
    public Attachment getAttachmentByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(attachment, topiaId);
    }

    @Override
    public Collection<String> getAttachmentTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.Attachment> tmp = getAttachment();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeAttachment() {
        if (attachment == null) {
            return 0;
        }
        return attachment.size();
    }

    @Override
    public boolean isAttachmentEmpty() {
        int size = sizeAttachment();
        return size == 0;
    }

    @Override
    public boolean isAttachmentNotEmpty() {
        boolean empty = isAttachmentEmpty();
        return ! empty;
    }

    @Override
    public boolean containsAttachment(Attachment attachment) {
        boolean contains = this.attachment !=null && this.attachment.contains(attachment);
        return contains;
    }

    @Override
    public void setOriginalEmail(OriginalEmail originalEmail) {
        this.originalEmail = originalEmail;
    }

    @Override
    public OriginalEmail getOriginalEmail() {
        OriginalEmail result = this.originalEmail;
        return result;
    }

} //EmailAbstract
