package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id: ClientImpl.java 660 2014-10-02 11:30:33Z kmorin $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-1.0/faxtomail-persistence/src/main/java/com/franciaflex/faxtomail/persistence/entities/ClientImpl.java $
 * %%
 * Copyright (C) 2014 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.lang.reflect.Type;
import java.util.List;

import com.google.gson.reflect.TypeToken;

public class ClientImpl extends ClientAbstract {

    /** serialVersionUID. */
    private static final long serialVersionUID = 645048064844251689L;

    private static final Type LIST_STRING_GSON_TYPE = new TypeToken<List<String>>() {}.getType();

    @Override
    public void setEmailAddresses(List<String> emails) {
        String json = AbstractFaxToMailTopiaDao.GSON_INSTANCE.toJson(emails);
        setEmailAddressesJson(json);
    }

    @Override
    public List<String> getEmailAddresses() {
        String json = getEmailAddressesJson();
        List<String> emailAddress = AbstractFaxToMailTopiaDao.GSON_INSTANCE.fromJson(json, LIST_STRING_GSON_TYPE);
        return emailAddress;
    }

    @Override
    public void setFaxNumbers(List<String> faxNumbers) {
        String json = AbstractFaxToMailTopiaDao.GSON_INSTANCE.toJson(faxNumbers);
        setFaxNumbersJson(json);
    }

    @Override
    public List<String> getFaxNumbers() {
        String json = getFaxNumbersJson();
        List<String> faxNumbers = AbstractFaxToMailTopiaDao.GSON_INSTANCE.fromJson(json, LIST_STRING_GSON_TYPE);
        return faxNumbers;
    }

}
