package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id: MailField.java 145 2014-06-06 16:25:02Z echatellier $
 * $HeadURL: https://svn.codelutin.com/faxtomail/trunk/faxtomail-persistence/src/main/java/com/franciaflex/faxtomail/persistence/entities/MailField.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

/**
 * Required email fields for specific {@link EtatAttente}.
 * 
 * @author Eric Chatellier
 */
public enum MailField {

    OBJECT,
    PROJECT_REFERENCE,
    PRIORITY,
    RANGE_ROW,
    CLIENT,
    ETAT_ATTENTE,
    COMPANY_REFERENCE,
    COMMENT,
    DEMAND_TYPE,
    CLIENT_CODE,
    CLIENT_BRAND,
    SENDER,
    REFERENCE,
    RECEPTION_DATE,
    RECIPIENT,
    DEMAND_STATUS,
    PF_NB,
    SAV_NB,
    QUOTATION_NB,
    TAKEN_BY,
    LAST_ATTACHMENT_OPENING_IN_THIS_FOLDER_USER,
    REPLIES,
    ATTACHMENT,
    EDI_RETURN;

    public static MailField[] getCanBeRequiredMailFields() {
        return new MailField[] {
                OBJECT,
                PROJECT_REFERENCE,
                PRIORITY,
                RANGE_ROW,
                CLIENT,
                ETAT_ATTENTE,
                COMPANY_REFERENCE,
                COMMENT
        };
    }

    public static MailField[] getTableFields() {
        return new MailField[] {
                PRIORITY,
                DEMAND_TYPE,
                OBJECT,
                CLIENT_CODE,
                CLIENT_BRAND,
                SENDER,
                PROJECT_REFERENCE,
                COMPANY_REFERENCE,
                REFERENCE,
                RECEPTION_DATE,
                RECIPIENT,
                DEMAND_STATUS,
                ETAT_ATTENTE,
                PF_NB,
                SAV_NB,
                QUOTATION_NB,
                TAKEN_BY,
                COMMENT,
                EDI_RETURN,
                LAST_ATTACHMENT_OPENING_IN_THIS_FOLDER_USER,
                REPLIES,
                ATTACHMENT
        };
    }
}
