package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Wed Jun 11 16:38:33 CEST 2014")
public abstract class FaxToMailUserAbstract extends AbstractTopiaEntity implements FaxToMailUser {

    /**
     * Nom de l'attribut en BD : lastName
     */
    protected String lastName;

    /**
     * Nom de l'attribut en BD : login
     */
    protected String login;

    /**
     * Nom de l'attribut en BD : trigraph
     */
    protected String trigraph;

    /**
     * Nom de l'attribut en BD : firstName
     */
    protected String firstName;

    /**
     * Nom de l'attribut en BD : userGroups
     */
    protected Collection<FaxToMailUserGroup> userGroups;

    /**
     * Nom de l'attribut en BD : affectedFolders
     */
    protected Collection<MailFolder> affectedFolders;

    private static final long serialVersionUID = 3545232548679464242L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_LAST_NAME, String.class, lastName);
        visitor.visit(this, PROPERTY_LOGIN, String.class, login);
        visitor.visit(this, PROPERTY_TRIGRAPH, String.class, trigraph);
        visitor.visit(this, PROPERTY_FIRST_NAME, String.class, firstName);
        visitor.visit(this, PROPERTY_USER_GROUPS, Collection.class, FaxToMailUserGroup.class, userGroups);
        visitor.visit(this, PROPERTY_AFFECTED_FOLDERS, Collection.class, MailFolder.class, affectedFolders);
        visitor.end(this);
    }

    @Override
    public void setLastName(String lastName) {
        String oldValue = this.lastName;
        fireOnPreWrite(PROPERTY_LAST_NAME, oldValue, lastName);
        this.lastName = lastName;
        fireOnPostWrite(PROPERTY_LAST_NAME, oldValue, lastName);
    }

    @Override
    public String getLastName() {
        fireOnPreRead(PROPERTY_LAST_NAME, lastName);
        String result = this.lastName;
        fireOnPostRead(PROPERTY_LAST_NAME, lastName);
        return result;
    }

    @Override
    public void setLogin(String login) {
        String oldValue = this.login;
        fireOnPreWrite(PROPERTY_LOGIN, oldValue, login);
        this.login = login;
        fireOnPostWrite(PROPERTY_LOGIN, oldValue, login);
    }

    @Override
    public String getLogin() {
        fireOnPreRead(PROPERTY_LOGIN, login);
        String result = this.login;
        fireOnPostRead(PROPERTY_LOGIN, login);
        return result;
    }

    @Override
    public void setTrigraph(String trigraph) {
        String oldValue = this.trigraph;
        fireOnPreWrite(PROPERTY_TRIGRAPH, oldValue, trigraph);
        this.trigraph = trigraph;
        fireOnPostWrite(PROPERTY_TRIGRAPH, oldValue, trigraph);
    }

    @Override
    public String getTrigraph() {
        fireOnPreRead(PROPERTY_TRIGRAPH, trigraph);
        String result = this.trigraph;
        fireOnPostRead(PROPERTY_TRIGRAPH, trigraph);
        return result;
    }

    @Override
    public void setFirstName(String firstName) {
        String oldValue = this.firstName;
        fireOnPreWrite(PROPERTY_FIRST_NAME, oldValue, firstName);
        this.firstName = firstName;
        fireOnPostWrite(PROPERTY_FIRST_NAME, oldValue, firstName);
    }

    @Override
    public String getFirstName() {
        fireOnPreRead(PROPERTY_FIRST_NAME, firstName);
        String result = this.firstName;
        fireOnPostRead(PROPERTY_FIRST_NAME, firstName);
        return result;
    }

    @Override
    public void addUserGroups(FaxToMailUserGroup userGroups) {
        fireOnPreWrite(PROPERTY_USER_GROUPS, null, userGroups);
        if (this.userGroups == null) {
            this.userGroups = new LinkedList<FaxToMailUserGroup>();
        }

        this.userGroups.add(userGroups);
        fireOnPostWrite(PROPERTY_USER_GROUPS, this.userGroups.size(), null, userGroups);
    }

    @Override
    public void addAllUserGroups(Collection<FaxToMailUserGroup> userGroups) {
        if (userGroups == null) {
            return;
        }
        for (FaxToMailUserGroup item : userGroups) {
            addUserGroups(item);
        }
    }

    @Override
    public void setUserGroups(Collection<FaxToMailUserGroup> userGroups) {
        // Copy elements to keep data for fire with new reference
        Collection<FaxToMailUserGroup> oldValue = this.userGroups != null ? new LinkedList<FaxToMailUserGroup>(this.userGroups) : null;
        fireOnPreWrite(PROPERTY_USER_GROUPS, oldValue, userGroups);
        this.userGroups = userGroups;
        fireOnPostWrite(PROPERTY_USER_GROUPS, oldValue, userGroups);
    }

    @Override
    public void removeUserGroups(FaxToMailUserGroup userGroups) {
        fireOnPreWrite(PROPERTY_USER_GROUPS, userGroups, null);
        if (this.userGroups == null || !this.userGroups.remove(userGroups)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_USER_GROUPS, this.userGroups.size() + 1, userGroups, null);
    }

    @Override
    public void clearUserGroups() {
        if (this.userGroups == null) {
            return;
        }
        Collection<FaxToMailUserGroup> oldValue = new LinkedList<FaxToMailUserGroup>(this.userGroups);
        fireOnPreWrite(PROPERTY_USER_GROUPS, oldValue, this.userGroups);
        this.userGroups.clear();
        fireOnPostWrite(PROPERTY_USER_GROUPS, oldValue, this.userGroups);
    }

    @Override
    public Collection<FaxToMailUserGroup> getUserGroups() {
        return userGroups;
    }

    @Override
    public FaxToMailUserGroup getUserGroupsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(userGroups, topiaId);
    }

    @Override
    public Collection<String> getUserGroupsTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.FaxToMailUserGroup> tmp = getUserGroups();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeUserGroups() {
        if (userGroups == null) {
            return 0;
        }
        return userGroups.size();
    }

    @Override
    public boolean isUserGroupsEmpty() {
        int size = sizeUserGroups();
        return size == 0;
    }

    @Override
    public boolean isUserGroupsNotEmpty() {
        boolean empty = isUserGroupsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsUserGroups(FaxToMailUserGroup userGroups) {
        boolean contains = this.userGroups !=null && this.userGroups.contains(userGroups);
        return contains;
    }

    @Override
    public void addAffectedFolders(MailFolder affectedFolders) {
        fireOnPreWrite(PROPERTY_AFFECTED_FOLDERS, null, affectedFolders);
        if (this.affectedFolders == null) {
            this.affectedFolders = new LinkedList<MailFolder>();
        }

        this.affectedFolders.add(affectedFolders);
        fireOnPostWrite(PROPERTY_AFFECTED_FOLDERS, this.affectedFolders.size(), null, affectedFolders);
    }

    @Override
    public void addAllAffectedFolders(Collection<MailFolder> affectedFolders) {
        if (affectedFolders == null) {
            return;
        }
        for (MailFolder item : affectedFolders) {
            addAffectedFolders(item);
        }
    }

    @Override
    public void setAffectedFolders(Collection<MailFolder> affectedFolders) {
        // Copy elements to keep data for fire with new reference
        Collection<MailFolder> oldValue = this.affectedFolders != null ? new LinkedList<MailFolder>(this.affectedFolders) : null;
        fireOnPreWrite(PROPERTY_AFFECTED_FOLDERS, oldValue, affectedFolders);
        this.affectedFolders = affectedFolders;
        fireOnPostWrite(PROPERTY_AFFECTED_FOLDERS, oldValue, affectedFolders);
    }

    @Override
    public void removeAffectedFolders(MailFolder affectedFolders) {
        fireOnPreWrite(PROPERTY_AFFECTED_FOLDERS, affectedFolders, null);
        if (this.affectedFolders == null || !this.affectedFolders.remove(affectedFolders)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_AFFECTED_FOLDERS, this.affectedFolders.size() + 1, affectedFolders, null);
    }

    @Override
    public void clearAffectedFolders() {
        if (this.affectedFolders == null) {
            return;
        }
        Collection<MailFolder> oldValue = new LinkedList<MailFolder>(this.affectedFolders);
        fireOnPreWrite(PROPERTY_AFFECTED_FOLDERS, oldValue, this.affectedFolders);
        this.affectedFolders.clear();
        fireOnPostWrite(PROPERTY_AFFECTED_FOLDERS, oldValue, this.affectedFolders);
    }

    @Override
    public Collection<MailFolder> getAffectedFolders() {
        return affectedFolders;
    }

    @Override
    public MailFolder getAffectedFoldersByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(affectedFolders, topiaId);
    }

    @Override
    public Collection<String> getAffectedFoldersTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.MailFolder> tmp = getAffectedFolders();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeAffectedFolders() {
        if (affectedFolders == null) {
            return 0;
        }
        return affectedFolders.size();
    }

    @Override
    public boolean isAffectedFoldersEmpty() {
        int size = sizeAffectedFolders();
        return size == 0;
    }

    @Override
    public boolean isAffectedFoldersNotEmpty() {
        boolean empty = isAffectedFoldersEmpty();
        return ! empty;
    }

    @Override
    public boolean containsAffectedFolders(MailFolder affectedFolders) {
        boolean contains = this.affectedFolders !=null && this.affectedFolders.contains(affectedFolders);
        return contains;
    }

} //FaxToMailUserAbstract
