package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Tue Jun 10 11:30:04 CEST 2014")
public abstract class MailFolderAbstract extends AbstractTopiaEntity implements MailFolder {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : allowCreateDemandIntoFolder
     */
    protected Boolean allowCreateDemandIntoFolder;

    /**
     * Nom de l'attribut en BD : allowMoveDemandIntoFolder
     */
    protected Boolean allowMoveDemandIntoFolder;

    /**
     * Nom de l'attribut en BD : rejectUnknownSender
     */
    protected Boolean rejectUnknownSender;

    /**
     * Nom de l'attribut en BD : replyAddresses
     */
    protected Collection<String> replyAddresses;

    /**
     * Nom de l'attribut en BD : replyDomains
     */
    protected Collection<String> replyDomains;

    /**
     * Nom de l'attribut en BD : openAttachmentReportNoTaken
     */
    protected Boolean openAttachmentReportNoTaken;

    /**
     * Nom de l'attribut en BD : printActionEqualTakeAction
     */
    protected Boolean printActionEqualTakeAction;

    /**
     * Nom de l'attribut en BD : ediFolder
     */
    protected String ediFolder;

    /**
     * Nom de l'attribut en BD : faxDomain
     */
    protected String faxDomain;

    /**
     * Nom de l'attribut en BD : useCurrentLevelEtatAttente
     */
    protected boolean useCurrentLevelEtatAttente;

    /**
     * Nom de l'attribut en BD : useCurrentLevelTableColumns
     */
    protected boolean useCurrentLevelTableColumns;

    /**
     * Nom de l'attribut en BD : useCurrentLevelFaxDomain
     */
    protected boolean useCurrentLevelFaxDomain;

    /**
     * Nom de l'attribut en BD : useCurrentLevelFolderActions
     */
    protected boolean useCurrentLevelFolderActions;

    /**
     * Nom de l'attribut en BD : useCurrentLevelEdiFolder
     */
    protected boolean useCurrentLevelEdiFolder;

    /**
     * Nom de l'attribut en BD : rejectUnknownSenderMessage
     */
    protected String rejectUnknownSenderMessage;

    /**
     * Nom de l'attribut en BD : etatAttentes
     */
    protected Collection<EtatAttente> etatAttentes;

    /**
     * Nom de l'attribut en BD : children
     */
    protected Collection<MailFolder> children;

    /**
     * Nom de l'attribut en BD : parent
     */
    protected MailFolder parent;

    /**
     * Nom de l'attribut en BD : folderTableColumns
     */
    protected List<MailField> folderTableColumns;

    /**
     * Nom de l'attribut en BD : folderActions
     */
    protected Collection<FolderAction> folderActions;

    /**
     * Nom de l'attribut en BD : customerResponsibles
     */
    protected Collection<FaxToMailUser> customerResponsibles;

    /**
     * Nom de l'attribut en BD : writeRightUsers
     */
    protected Collection<FaxToMailUser> writeRightUsers;

    /**
     * Nom de l'attribut en BD : readRightUsers
     */
    protected Collection<FaxToMailUser> readRightUsers;

    /**
     * Nom de l'attribut en BD : moveRightUsers
     */
    protected Collection<FaxToMailUser> moveRightUsers;

    /**
     * Nom de l'attribut en BD : writeRightGroups
     */
    protected Collection<FaxToMailUserGroup> writeRightGroups;

    /**
     * Nom de l'attribut en BD : moveRightGroups
     */
    protected Collection<FaxToMailUserGroup> moveRightGroups;

    /**
     * Nom de l'attribut en BD : readRightGroups
     */
    protected Collection<FaxToMailUserGroup> readRightGroups;

    private static final long serialVersionUID = 3688556281690863664L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_ALLOW_CREATE_DEMAND_INTO_FOLDER, Boolean.class, allowCreateDemandIntoFolder);
        visitor.visit(this, PROPERTY_ALLOW_MOVE_DEMAND_INTO_FOLDER, Boolean.class, allowMoveDemandIntoFolder);
        visitor.visit(this, PROPERTY_REJECT_UNKNOWN_SENDER, Boolean.class, rejectUnknownSender);
        visitor.visit(this, PROPERTY_REPLY_ADDRESSES, Collection.class, String.class, replyAddresses);
        visitor.visit(this, PROPERTY_REPLY_DOMAINS, Collection.class, String.class, replyDomains);
        visitor.visit(this, PROPERTY_OPEN_ATTACHMENT_REPORT_NO_TAKEN, Boolean.class, openAttachmentReportNoTaken);
        visitor.visit(this, PROPERTY_PRINT_ACTION_EQUAL_TAKE_ACTION, Boolean.class, printActionEqualTakeAction);
        visitor.visit(this, PROPERTY_EDI_FOLDER, String.class, ediFolder);
        visitor.visit(this, PROPERTY_FAX_DOMAIN, String.class, faxDomain);
        visitor.visit(this, PROPERTY_USE_CURRENT_LEVEL_ETAT_ATTENTE, boolean.class, useCurrentLevelEtatAttente);
        visitor.visit(this, PROPERTY_USE_CURRENT_LEVEL_TABLE_COLUMNS, boolean.class, useCurrentLevelTableColumns);
        visitor.visit(this, PROPERTY_USE_CURRENT_LEVEL_FAX_DOMAIN, boolean.class, useCurrentLevelFaxDomain);
        visitor.visit(this, PROPERTY_USE_CURRENT_LEVEL_FOLDER_ACTIONS, boolean.class, useCurrentLevelFolderActions);
        visitor.visit(this, PROPERTY_USE_CURRENT_LEVEL_EDI_FOLDER, boolean.class, useCurrentLevelEdiFolder);
        visitor.visit(this, PROPERTY_REJECT_UNKNOWN_SENDER_MESSAGE, String.class, rejectUnknownSenderMessage);
        visitor.visit(this, PROPERTY_ETAT_ATTENTES, Collection.class, EtatAttente.class, etatAttentes);
        visitor.visit(this, PROPERTY_CHILDREN, Collection.class, MailFolder.class, children);
        visitor.visit(this, PROPERTY_PARENT, MailFolder.class, parent);
        visitor.visit(this, PROPERTY_FOLDER_TABLE_COLUMNS, List.class, MailField.class, folderTableColumns);
        visitor.visit(this, PROPERTY_FOLDER_ACTIONS, Collection.class, FolderAction.class, folderActions);
        visitor.visit(this, PROPERTY_CUSTOMER_RESPONSIBLES, Collection.class, FaxToMailUser.class, customerResponsibles);
        visitor.visit(this, PROPERTY_WRITE_RIGHT_USERS, Collection.class, FaxToMailUser.class, writeRightUsers);
        visitor.visit(this, PROPERTY_READ_RIGHT_USERS, Collection.class, FaxToMailUser.class, readRightUsers);
        visitor.visit(this, PROPERTY_MOVE_RIGHT_USERS, Collection.class, FaxToMailUser.class, moveRightUsers);
        visitor.visit(this, PROPERTY_WRITE_RIGHT_GROUPS, Collection.class, FaxToMailUserGroup.class, writeRightGroups);
        visitor.visit(this, PROPERTY_MOVE_RIGHT_GROUPS, Collection.class, FaxToMailUserGroup.class, moveRightGroups);
        visitor.visit(this, PROPERTY_READ_RIGHT_GROUPS, Collection.class, FaxToMailUserGroup.class, readRightGroups);
        visitor.end(this);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(PROPERTY_NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(PROPERTY_NAME, oldValue, name);
    }

    @Override
    public String getName() {
        fireOnPreRead(PROPERTY_NAME, name);
        String result = this.name;
        fireOnPostRead(PROPERTY_NAME, name);
        return result;
    }

    @Override
    public void setAllowCreateDemandIntoFolder(Boolean allowCreateDemandIntoFolder) {
        Boolean oldValue = this.allowCreateDemandIntoFolder;
        fireOnPreWrite(PROPERTY_ALLOW_CREATE_DEMAND_INTO_FOLDER, oldValue, allowCreateDemandIntoFolder);
        this.allowCreateDemandIntoFolder = allowCreateDemandIntoFolder;
        fireOnPostWrite(PROPERTY_ALLOW_CREATE_DEMAND_INTO_FOLDER, oldValue, allowCreateDemandIntoFolder);
    }

    @Override
    public Boolean getAllowCreateDemandIntoFolder() {
        fireOnPreRead(PROPERTY_ALLOW_CREATE_DEMAND_INTO_FOLDER, allowCreateDemandIntoFolder);
        Boolean result = this.allowCreateDemandIntoFolder;
        fireOnPostRead(PROPERTY_ALLOW_CREATE_DEMAND_INTO_FOLDER, allowCreateDemandIntoFolder);
        return result;
    }

    @Override
    public void setAllowMoveDemandIntoFolder(Boolean allowMoveDemandIntoFolder) {
        Boolean oldValue = this.allowMoveDemandIntoFolder;
        fireOnPreWrite(PROPERTY_ALLOW_MOVE_DEMAND_INTO_FOLDER, oldValue, allowMoveDemandIntoFolder);
        this.allowMoveDemandIntoFolder = allowMoveDemandIntoFolder;
        fireOnPostWrite(PROPERTY_ALLOW_MOVE_DEMAND_INTO_FOLDER, oldValue, allowMoveDemandIntoFolder);
    }

    @Override
    public Boolean getAllowMoveDemandIntoFolder() {
        fireOnPreRead(PROPERTY_ALLOW_MOVE_DEMAND_INTO_FOLDER, allowMoveDemandIntoFolder);
        Boolean result = this.allowMoveDemandIntoFolder;
        fireOnPostRead(PROPERTY_ALLOW_MOVE_DEMAND_INTO_FOLDER, allowMoveDemandIntoFolder);
        return result;
    }

    @Override
    public void setRejectUnknownSender(Boolean rejectUnknownSender) {
        Boolean oldValue = this.rejectUnknownSender;
        fireOnPreWrite(PROPERTY_REJECT_UNKNOWN_SENDER, oldValue, rejectUnknownSender);
        this.rejectUnknownSender = rejectUnknownSender;
        fireOnPostWrite(PROPERTY_REJECT_UNKNOWN_SENDER, oldValue, rejectUnknownSender);
    }

    @Override
    public Boolean getRejectUnknownSender() {
        fireOnPreRead(PROPERTY_REJECT_UNKNOWN_SENDER, rejectUnknownSender);
        Boolean result = this.rejectUnknownSender;
        fireOnPostRead(PROPERTY_REJECT_UNKNOWN_SENDER, rejectUnknownSender);
        return result;
    }

    @Override
    public void addReplyAddresses(String replyAddresses) {
        fireOnPreWrite(PROPERTY_REPLY_ADDRESSES, null, replyAddresses);
        if (this.replyAddresses == null) {
            this.replyAddresses = new LinkedList<String>();
        }

        this.replyAddresses.add(replyAddresses);
        fireOnPostWrite(PROPERTY_REPLY_ADDRESSES, this.replyAddresses.size(), null, replyAddresses);
    }

    @Override
    public void addAllReplyAddresses(Collection<String> replyAddresses) {
        if (replyAddresses == null) {
            return;
        }
        for (String item : replyAddresses) {
            addReplyAddresses(item);
        }
    }

    @Override
    public void setReplyAddresses(Collection<String> replyAddresses) {
        // Copy elements to keep data for fire with new reference
        Collection<String> oldValue = this.replyAddresses != null ? new LinkedList<String>(this.replyAddresses) : null;
        fireOnPreWrite(PROPERTY_REPLY_ADDRESSES, oldValue, replyAddresses);
        this.replyAddresses = replyAddresses;
        fireOnPostWrite(PROPERTY_REPLY_ADDRESSES, oldValue, replyAddresses);
    }

    @Override
    public void removeReplyAddresses(String replyAddresses) {
        fireOnPreWrite(PROPERTY_REPLY_ADDRESSES, replyAddresses, null);
        if (this.replyAddresses == null || !this.replyAddresses.remove(replyAddresses)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_REPLY_ADDRESSES, this.replyAddresses.size() + 1, replyAddresses, null);
    }

    @Override
    public void clearReplyAddresses() {
        if (this.replyAddresses == null) {
            return;
        }
        Collection<String> oldValue = new LinkedList<String>(this.replyAddresses);
        fireOnPreWrite(PROPERTY_REPLY_ADDRESSES, oldValue, this.replyAddresses);
        this.replyAddresses.clear();
        fireOnPostWrite(PROPERTY_REPLY_ADDRESSES, oldValue, this.replyAddresses);
    }

    @Override
    public Collection<String> getReplyAddresses() {
        return replyAddresses;
    }

    @Override
    public int sizeReplyAddresses() {
        if (replyAddresses == null) {
            return 0;
        }
        return replyAddresses.size();
    }

    @Override
    public boolean isReplyAddressesEmpty() {
        int size = sizeReplyAddresses();
        return size == 0;
    }

    @Override
    public boolean isReplyAddressesNotEmpty() {
        boolean empty = isReplyAddressesEmpty();
        return ! empty;
    }

    @Override
    public boolean containsReplyAddresses(String replyAddresses) {
        boolean contains = this.replyAddresses !=null && this.replyAddresses.contains(replyAddresses);
        return contains;
    }

    @Override
    public void addReplyDomains(String replyDomains) {
        fireOnPreWrite(PROPERTY_REPLY_DOMAINS, null, replyDomains);
        if (this.replyDomains == null) {
            this.replyDomains = new LinkedList<String>();
        }

        this.replyDomains.add(replyDomains);
        fireOnPostWrite(PROPERTY_REPLY_DOMAINS, this.replyDomains.size(), null, replyDomains);
    }

    @Override
    public void addAllReplyDomains(Collection<String> replyDomains) {
        if (replyDomains == null) {
            return;
        }
        for (String item : replyDomains) {
            addReplyDomains(item);
        }
    }

    @Override
    public void setReplyDomains(Collection<String> replyDomains) {
        // Copy elements to keep data for fire with new reference
        Collection<String> oldValue = this.replyDomains != null ? new LinkedList<String>(this.replyDomains) : null;
        fireOnPreWrite(PROPERTY_REPLY_DOMAINS, oldValue, replyDomains);
        this.replyDomains = replyDomains;
        fireOnPostWrite(PROPERTY_REPLY_DOMAINS, oldValue, replyDomains);
    }

    @Override
    public void removeReplyDomains(String replyDomains) {
        fireOnPreWrite(PROPERTY_REPLY_DOMAINS, replyDomains, null);
        if (this.replyDomains == null || !this.replyDomains.remove(replyDomains)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_REPLY_DOMAINS, this.replyDomains.size() + 1, replyDomains, null);
    }

    @Override
    public void clearReplyDomains() {
        if (this.replyDomains == null) {
            return;
        }
        Collection<String> oldValue = new LinkedList<String>(this.replyDomains);
        fireOnPreWrite(PROPERTY_REPLY_DOMAINS, oldValue, this.replyDomains);
        this.replyDomains.clear();
        fireOnPostWrite(PROPERTY_REPLY_DOMAINS, oldValue, this.replyDomains);
    }

    @Override
    public Collection<String> getReplyDomains() {
        return replyDomains;
    }

    @Override
    public int sizeReplyDomains() {
        if (replyDomains == null) {
            return 0;
        }
        return replyDomains.size();
    }

    @Override
    public boolean isReplyDomainsEmpty() {
        int size = sizeReplyDomains();
        return size == 0;
    }

    @Override
    public boolean isReplyDomainsNotEmpty() {
        boolean empty = isReplyDomainsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsReplyDomains(String replyDomains) {
        boolean contains = this.replyDomains !=null && this.replyDomains.contains(replyDomains);
        return contains;
    }

    @Override
    public void setOpenAttachmentReportNoTaken(Boolean openAttachmentReportNoTaken) {
        Boolean oldValue = this.openAttachmentReportNoTaken;
        fireOnPreWrite(PROPERTY_OPEN_ATTACHMENT_REPORT_NO_TAKEN, oldValue, openAttachmentReportNoTaken);
        this.openAttachmentReportNoTaken = openAttachmentReportNoTaken;
        fireOnPostWrite(PROPERTY_OPEN_ATTACHMENT_REPORT_NO_TAKEN, oldValue, openAttachmentReportNoTaken);
    }

    @Override
    public Boolean getOpenAttachmentReportNoTaken() {
        fireOnPreRead(PROPERTY_OPEN_ATTACHMENT_REPORT_NO_TAKEN, openAttachmentReportNoTaken);
        Boolean result = this.openAttachmentReportNoTaken;
        fireOnPostRead(PROPERTY_OPEN_ATTACHMENT_REPORT_NO_TAKEN, openAttachmentReportNoTaken);
        return result;
    }

    @Override
    public void setPrintActionEqualTakeAction(Boolean printActionEqualTakeAction) {
        Boolean oldValue = this.printActionEqualTakeAction;
        fireOnPreWrite(PROPERTY_PRINT_ACTION_EQUAL_TAKE_ACTION, oldValue, printActionEqualTakeAction);
        this.printActionEqualTakeAction = printActionEqualTakeAction;
        fireOnPostWrite(PROPERTY_PRINT_ACTION_EQUAL_TAKE_ACTION, oldValue, printActionEqualTakeAction);
    }

    @Override
    public Boolean getPrintActionEqualTakeAction() {
        fireOnPreRead(PROPERTY_PRINT_ACTION_EQUAL_TAKE_ACTION, printActionEqualTakeAction);
        Boolean result = this.printActionEqualTakeAction;
        fireOnPostRead(PROPERTY_PRINT_ACTION_EQUAL_TAKE_ACTION, printActionEqualTakeAction);
        return result;
    }

    @Override
    public void setEdiFolder(String ediFolder) {
        String oldValue = this.ediFolder;
        fireOnPreWrite(PROPERTY_EDI_FOLDER, oldValue, ediFolder);
        this.ediFolder = ediFolder;
        fireOnPostWrite(PROPERTY_EDI_FOLDER, oldValue, ediFolder);
    }

    @Override
    public String getEdiFolder() {
        fireOnPreRead(PROPERTY_EDI_FOLDER, ediFolder);
        String result = this.ediFolder;
        fireOnPostRead(PROPERTY_EDI_FOLDER, ediFolder);
        return result;
    }

    @Override
    public void setFaxDomain(String faxDomain) {
        String oldValue = this.faxDomain;
        fireOnPreWrite(PROPERTY_FAX_DOMAIN, oldValue, faxDomain);
        this.faxDomain = faxDomain;
        fireOnPostWrite(PROPERTY_FAX_DOMAIN, oldValue, faxDomain);
    }

    @Override
    public String getFaxDomain() {
        fireOnPreRead(PROPERTY_FAX_DOMAIN, faxDomain);
        String result = this.faxDomain;
        fireOnPostRead(PROPERTY_FAX_DOMAIN, faxDomain);
        return result;
    }

    @Override
    public void setUseCurrentLevelEtatAttente(boolean useCurrentLevelEtatAttente) {
        boolean oldValue = this.useCurrentLevelEtatAttente;
        fireOnPreWrite(PROPERTY_USE_CURRENT_LEVEL_ETAT_ATTENTE, oldValue, useCurrentLevelEtatAttente);
        this.useCurrentLevelEtatAttente = useCurrentLevelEtatAttente;
        fireOnPostWrite(PROPERTY_USE_CURRENT_LEVEL_ETAT_ATTENTE, oldValue, useCurrentLevelEtatAttente);
    }

    @Override
    public boolean isUseCurrentLevelEtatAttente() {
        fireOnPreRead(PROPERTY_USE_CURRENT_LEVEL_ETAT_ATTENTE, useCurrentLevelEtatAttente);
        boolean result = this.useCurrentLevelEtatAttente;
        fireOnPostRead(PROPERTY_USE_CURRENT_LEVEL_ETAT_ATTENTE, useCurrentLevelEtatAttente);
        return result;
    }

    @Override
    public boolean getUseCurrentLevelEtatAttente() {
        fireOnPreRead(PROPERTY_USE_CURRENT_LEVEL_ETAT_ATTENTE, useCurrentLevelEtatAttente);
        boolean result = this.useCurrentLevelEtatAttente;
        fireOnPostRead(PROPERTY_USE_CURRENT_LEVEL_ETAT_ATTENTE, useCurrentLevelEtatAttente);
        return result;
    }

    @Override
    public void setUseCurrentLevelTableColumns(boolean useCurrentLevelTableColumns) {
        boolean oldValue = this.useCurrentLevelTableColumns;
        fireOnPreWrite(PROPERTY_USE_CURRENT_LEVEL_TABLE_COLUMNS, oldValue, useCurrentLevelTableColumns);
        this.useCurrentLevelTableColumns = useCurrentLevelTableColumns;
        fireOnPostWrite(PROPERTY_USE_CURRENT_LEVEL_TABLE_COLUMNS, oldValue, useCurrentLevelTableColumns);
    }

    @Override
    public boolean isUseCurrentLevelTableColumns() {
        fireOnPreRead(PROPERTY_USE_CURRENT_LEVEL_TABLE_COLUMNS, useCurrentLevelTableColumns);
        boolean result = this.useCurrentLevelTableColumns;
        fireOnPostRead(PROPERTY_USE_CURRENT_LEVEL_TABLE_COLUMNS, useCurrentLevelTableColumns);
        return result;
    }

    @Override
    public boolean getUseCurrentLevelTableColumns() {
        fireOnPreRead(PROPERTY_USE_CURRENT_LEVEL_TABLE_COLUMNS, useCurrentLevelTableColumns);
        boolean result = this.useCurrentLevelTableColumns;
        fireOnPostRead(PROPERTY_USE_CURRENT_LEVEL_TABLE_COLUMNS, useCurrentLevelTableColumns);
        return result;
    }

    @Override
    public void setUseCurrentLevelFaxDomain(boolean useCurrentLevelFaxDomain) {
        boolean oldValue = this.useCurrentLevelFaxDomain;
        fireOnPreWrite(PROPERTY_USE_CURRENT_LEVEL_FAX_DOMAIN, oldValue, useCurrentLevelFaxDomain);
        this.useCurrentLevelFaxDomain = useCurrentLevelFaxDomain;
        fireOnPostWrite(PROPERTY_USE_CURRENT_LEVEL_FAX_DOMAIN, oldValue, useCurrentLevelFaxDomain);
    }

    @Override
    public boolean isUseCurrentLevelFaxDomain() {
        fireOnPreRead(PROPERTY_USE_CURRENT_LEVEL_FAX_DOMAIN, useCurrentLevelFaxDomain);
        boolean result = this.useCurrentLevelFaxDomain;
        fireOnPostRead(PROPERTY_USE_CURRENT_LEVEL_FAX_DOMAIN, useCurrentLevelFaxDomain);
        return result;
    }

    @Override
    public boolean getUseCurrentLevelFaxDomain() {
        fireOnPreRead(PROPERTY_USE_CURRENT_LEVEL_FAX_DOMAIN, useCurrentLevelFaxDomain);
        boolean result = this.useCurrentLevelFaxDomain;
        fireOnPostRead(PROPERTY_USE_CURRENT_LEVEL_FAX_DOMAIN, useCurrentLevelFaxDomain);
        return result;
    }

    @Override
    public void setUseCurrentLevelFolderActions(boolean useCurrentLevelFolderActions) {
        boolean oldValue = this.useCurrentLevelFolderActions;
        fireOnPreWrite(PROPERTY_USE_CURRENT_LEVEL_FOLDER_ACTIONS, oldValue, useCurrentLevelFolderActions);
        this.useCurrentLevelFolderActions = useCurrentLevelFolderActions;
        fireOnPostWrite(PROPERTY_USE_CURRENT_LEVEL_FOLDER_ACTIONS, oldValue, useCurrentLevelFolderActions);
    }

    @Override
    public boolean isUseCurrentLevelFolderActions() {
        fireOnPreRead(PROPERTY_USE_CURRENT_LEVEL_FOLDER_ACTIONS, useCurrentLevelFolderActions);
        boolean result = this.useCurrentLevelFolderActions;
        fireOnPostRead(PROPERTY_USE_CURRENT_LEVEL_FOLDER_ACTIONS, useCurrentLevelFolderActions);
        return result;
    }

    @Override
    public boolean getUseCurrentLevelFolderActions() {
        fireOnPreRead(PROPERTY_USE_CURRENT_LEVEL_FOLDER_ACTIONS, useCurrentLevelFolderActions);
        boolean result = this.useCurrentLevelFolderActions;
        fireOnPostRead(PROPERTY_USE_CURRENT_LEVEL_FOLDER_ACTIONS, useCurrentLevelFolderActions);
        return result;
    }

    @Override
    public void setUseCurrentLevelEdiFolder(boolean useCurrentLevelEdiFolder) {
        boolean oldValue = this.useCurrentLevelEdiFolder;
        fireOnPreWrite(PROPERTY_USE_CURRENT_LEVEL_EDI_FOLDER, oldValue, useCurrentLevelEdiFolder);
        this.useCurrentLevelEdiFolder = useCurrentLevelEdiFolder;
        fireOnPostWrite(PROPERTY_USE_CURRENT_LEVEL_EDI_FOLDER, oldValue, useCurrentLevelEdiFolder);
    }

    @Override
    public boolean isUseCurrentLevelEdiFolder() {
        fireOnPreRead(PROPERTY_USE_CURRENT_LEVEL_EDI_FOLDER, useCurrentLevelEdiFolder);
        boolean result = this.useCurrentLevelEdiFolder;
        fireOnPostRead(PROPERTY_USE_CURRENT_LEVEL_EDI_FOLDER, useCurrentLevelEdiFolder);
        return result;
    }

    @Override
    public boolean getUseCurrentLevelEdiFolder() {
        fireOnPreRead(PROPERTY_USE_CURRENT_LEVEL_EDI_FOLDER, useCurrentLevelEdiFolder);
        boolean result = this.useCurrentLevelEdiFolder;
        fireOnPostRead(PROPERTY_USE_CURRENT_LEVEL_EDI_FOLDER, useCurrentLevelEdiFolder);
        return result;
    }

    @Override
    public void setRejectUnknownSenderMessage(String rejectUnknownSenderMessage) {
        String oldValue = this.rejectUnknownSenderMessage;
        fireOnPreWrite(PROPERTY_REJECT_UNKNOWN_SENDER_MESSAGE, oldValue, rejectUnknownSenderMessage);
        this.rejectUnknownSenderMessage = rejectUnknownSenderMessage;
        fireOnPostWrite(PROPERTY_REJECT_UNKNOWN_SENDER_MESSAGE, oldValue, rejectUnknownSenderMessage);
    }

    @Override
    public String getRejectUnknownSenderMessage() {
        fireOnPreRead(PROPERTY_REJECT_UNKNOWN_SENDER_MESSAGE, rejectUnknownSenderMessage);
        String result = this.rejectUnknownSenderMessage;
        fireOnPostRead(PROPERTY_REJECT_UNKNOWN_SENDER_MESSAGE, rejectUnknownSenderMessage);
        return result;
    }

    @Override
    public void addEtatAttentes(EtatAttente etatAttentes) {
        fireOnPreWrite(PROPERTY_ETAT_ATTENTES, null, etatAttentes);
        if (this.etatAttentes == null) {
            this.etatAttentes = new LinkedList<EtatAttente>();
        }

        this.etatAttentes.add(etatAttentes);
        fireOnPostWrite(PROPERTY_ETAT_ATTENTES, this.etatAttentes.size(), null, etatAttentes);
    }

    @Override
    public void addAllEtatAttentes(Collection<EtatAttente> etatAttentes) {
        if (etatAttentes == null) {
            return;
        }
        for (EtatAttente item : etatAttentes) {
            addEtatAttentes(item);
        }
    }

    @Override
    public void setEtatAttentes(Collection<EtatAttente> etatAttentes) {
        // Copy elements to keep data for fire with new reference
        Collection<EtatAttente> oldValue = this.etatAttentes != null ? new LinkedList<EtatAttente>(this.etatAttentes) : null;
        fireOnPreWrite(PROPERTY_ETAT_ATTENTES, oldValue, etatAttentes);
        this.etatAttentes = etatAttentes;
        fireOnPostWrite(PROPERTY_ETAT_ATTENTES, oldValue, etatAttentes);
    }

    @Override
    public void removeEtatAttentes(EtatAttente etatAttentes) {
        fireOnPreWrite(PROPERTY_ETAT_ATTENTES, etatAttentes, null);
        if (this.etatAttentes == null || !this.etatAttentes.remove(etatAttentes)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_ETAT_ATTENTES, this.etatAttentes.size() + 1, etatAttentes, null);
    }

    @Override
    public void clearEtatAttentes() {
        if (this.etatAttentes == null) {
            return;
        }
        Collection<EtatAttente> oldValue = new LinkedList<EtatAttente>(this.etatAttentes);
        fireOnPreWrite(PROPERTY_ETAT_ATTENTES, oldValue, this.etatAttentes);
        this.etatAttentes.clear();
        fireOnPostWrite(PROPERTY_ETAT_ATTENTES, oldValue, this.etatAttentes);
    }

    @Override
    public Collection<EtatAttente> getEtatAttentes() {
        return etatAttentes;
    }

    @Override
    public EtatAttente getEtatAttentesByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(etatAttentes, topiaId);
    }

    @Override
    public Collection<String> getEtatAttentesTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.EtatAttente> tmp = getEtatAttentes();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeEtatAttentes() {
        if (etatAttentes == null) {
            return 0;
        }
        return etatAttentes.size();
    }

    @Override
    public boolean isEtatAttentesEmpty() {
        int size = sizeEtatAttentes();
        return size == 0;
    }

    @Override
    public boolean isEtatAttentesNotEmpty() {
        boolean empty = isEtatAttentesEmpty();
        return ! empty;
    }

    @Override
    public boolean containsEtatAttentes(EtatAttente etatAttentes) {
        boolean contains = this.etatAttentes !=null && this.etatAttentes.contains(etatAttentes);
        return contains;
    }

    @Override
    public void addChildren(MailFolder children) {
        fireOnPreWrite(PROPERTY_CHILDREN, null, children);
        if (this.children == null) {
            this.children = new LinkedList<MailFolder>();
        }

        children.setParent(this);

        this.children.add(children);
        fireOnPostWrite(PROPERTY_CHILDREN, this.children.size(), null, children);
    }

    @Override
    public void addAllChildren(Collection<MailFolder> children) {
        if (children == null) {
            return;
        }
        for (MailFolder item : children) {
            addChildren(item);
        }
    }

    @Override
    public void setChildren(Collection<MailFolder> children) {
        // Copy elements to keep data for fire with new reference
        Collection<MailFolder> oldValue = this.children != null ? new LinkedList<MailFolder>(this.children) : null;
        fireOnPreWrite(PROPERTY_CHILDREN, oldValue, children);
        this.children = children;
        fireOnPostWrite(PROPERTY_CHILDREN, oldValue, children);
    }

    @Override
    public void removeChildren(MailFolder children) {
        fireOnPreWrite(PROPERTY_CHILDREN, children, null);
        if (this.children == null || !this.children.remove(children)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        children.setParent(null);

        fireOnPostWrite(PROPERTY_CHILDREN, this.children.size() + 1, children, null);
    }

    @Override
    public void clearChildren() {
        if (this.children == null) {
            return;
        }
        for (MailFolder item : this.children) {
            item.setParent(null);
        }
        Collection<MailFolder> oldValue = new LinkedList<MailFolder>(this.children);
        fireOnPreWrite(PROPERTY_CHILDREN, oldValue, this.children);
        this.children.clear();
        fireOnPostWrite(PROPERTY_CHILDREN, oldValue, this.children);
    }

    @Override
    public Collection<MailFolder> getChildren() {
        return children;
    }

    @Override
    public MailFolder getChildrenByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(children, topiaId);
    }

    @Override
    public Collection<String> getChildrenTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.MailFolder> tmp = getChildren();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeChildren() {
        if (children == null) {
            return 0;
        }
        return children.size();
    }

    @Override
    public boolean isChildrenEmpty() {
        int size = sizeChildren();
        return size == 0;
    }

    @Override
    public boolean isChildrenNotEmpty() {
        boolean empty = isChildrenEmpty();
        return ! empty;
    }

    @Override
    public boolean containsChildren(MailFolder children) {
        boolean contains = this.children !=null && this.children.contains(children);
        return contains;
    }

    @Override
    public void setParent(MailFolder parent) {
        MailFolder oldValue = this.parent;
        fireOnPreWrite(PROPERTY_PARENT, oldValue, parent);
        this.parent = parent;
        fireOnPostWrite(PROPERTY_PARENT, oldValue, parent);
    }

    @Override
    public MailFolder getParent() {
        fireOnPreRead(PROPERTY_PARENT, parent);
        MailFolder result = this.parent;
        fireOnPostRead(PROPERTY_PARENT, parent);
        return result;
    }

    @Override
    public void addFolderTableColumns(MailField folderTableColumns) {
        fireOnPreWrite(PROPERTY_FOLDER_TABLE_COLUMNS, null, folderTableColumns);
        if (this.folderTableColumns == null) {
            this.folderTableColumns = new LinkedList<MailField>();
        }

        this.folderTableColumns.add(folderTableColumns);
        fireOnPostWrite(PROPERTY_FOLDER_TABLE_COLUMNS, this.folderTableColumns.size(), null, folderTableColumns);
    }

    @Override
    public void addFolderTableColumns(int index, MailField folderTableColumns) {
        fireOnPreWrite(PROPERTY_FOLDER_TABLE_COLUMNS, null, folderTableColumns);
        if (this.folderTableColumns == null) {
            this.folderTableColumns = new LinkedList<MailField>();
        }

        this.folderTableColumns.add(index, folderTableColumns);
        fireOnPostWrite(PROPERTY_FOLDER_TABLE_COLUMNS, index, null, folderTableColumns);
    }

    @Override
    public void addAllFolderTableColumns(List<MailField> folderTableColumns) {
        if (folderTableColumns == null) {
            return;
        }
        for (MailField item : folderTableColumns) {
            addFolderTableColumns(item);
        }
    }

    @Override
    public void setFolderTableColumns(List<MailField> folderTableColumns) {
        // Copy elements to keep data for fire with new reference
        List<MailField> oldValue = this.folderTableColumns != null ? new LinkedList<MailField>(this.folderTableColumns) : null;
        fireOnPreWrite(PROPERTY_FOLDER_TABLE_COLUMNS, oldValue, folderTableColumns);
        this.folderTableColumns = folderTableColumns;
        fireOnPostWrite(PROPERTY_FOLDER_TABLE_COLUMNS, oldValue, folderTableColumns);
    }

    @Override
    public void removeFolderTableColumns(MailField folderTableColumns) {
        fireOnPreWrite(PROPERTY_FOLDER_TABLE_COLUMNS, folderTableColumns, null);
        if (this.folderTableColumns == null || !this.folderTableColumns.remove(folderTableColumns)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_FOLDER_TABLE_COLUMNS, this.folderTableColumns.size() + 1, folderTableColumns, null);
    }

    @Override
    public void removeFolderTableColumns(int index) {
        fireOnPreWrite(PROPERTY_FOLDER_TABLE_COLUMNS, folderTableColumns, null);
        if (this.folderTableColumns == null) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        MailField oldValue = this.folderTableColumns.remove(index);
        if (oldValue == null) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_FOLDER_TABLE_COLUMNS, index, oldValue, null);
    }

    @Override
    public void clearFolderTableColumns() {
        if (this.folderTableColumns == null) {
            return;
        }
        List<MailField> oldValue = new LinkedList<MailField>(this.folderTableColumns);
        fireOnPreWrite(PROPERTY_FOLDER_TABLE_COLUMNS, oldValue, this.folderTableColumns);
        this.folderTableColumns.clear();
        fireOnPostWrite(PROPERTY_FOLDER_TABLE_COLUMNS, oldValue, this.folderTableColumns);
    }

    @Override
    public List<MailField> getFolderTableColumns() {
        return folderTableColumns;
    }

    @Override
    public MailField getFolderTableColumns(int index) {
        return TopiaEntityHelper.getEntityByIndex(folderTableColumns, index);
    }

    @Override
    public int sizeFolderTableColumns() {
        if (folderTableColumns == null) {
            return 0;
        }
        return folderTableColumns.size();
    }

    @Override
    public boolean isFolderTableColumnsEmpty() {
        int size = sizeFolderTableColumns();
        return size == 0;
    }

    @Override
    public boolean isFolderTableColumnsNotEmpty() {
        boolean empty = isFolderTableColumnsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsFolderTableColumns(MailField folderTableColumns) {
        boolean contains = this.folderTableColumns !=null && this.folderTableColumns.contains(folderTableColumns);
        return contains;
    }

    @Override
    public void addFolderActions(FolderAction folderActions) {
        fireOnPreWrite(PROPERTY_FOLDER_ACTIONS, null, folderActions);
        if (this.folderActions == null) {
            this.folderActions = new LinkedList<FolderAction>();
        }

        this.folderActions.add(folderActions);
        fireOnPostWrite(PROPERTY_FOLDER_ACTIONS, this.folderActions.size(), null, folderActions);
    }

    @Override
    public void addAllFolderActions(Collection<FolderAction> folderActions) {
        if (folderActions == null) {
            return;
        }
        for (FolderAction item : folderActions) {
            addFolderActions(item);
        }
    }

    @Override
    public void setFolderActions(Collection<FolderAction> folderActions) {
        // Copy elements to keep data for fire with new reference
        Collection<FolderAction> oldValue = this.folderActions != null ? new LinkedList<FolderAction>(this.folderActions) : null;
        fireOnPreWrite(PROPERTY_FOLDER_ACTIONS, oldValue, folderActions);
        this.folderActions = folderActions;
        fireOnPostWrite(PROPERTY_FOLDER_ACTIONS, oldValue, folderActions);
    }

    @Override
    public void removeFolderActions(FolderAction folderActions) {
        fireOnPreWrite(PROPERTY_FOLDER_ACTIONS, folderActions, null);
        if (this.folderActions == null || !this.folderActions.remove(folderActions)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_FOLDER_ACTIONS, this.folderActions.size() + 1, folderActions, null);
    }

    @Override
    public void clearFolderActions() {
        if (this.folderActions == null) {
            return;
        }
        Collection<FolderAction> oldValue = new LinkedList<FolderAction>(this.folderActions);
        fireOnPreWrite(PROPERTY_FOLDER_ACTIONS, oldValue, this.folderActions);
        this.folderActions.clear();
        fireOnPostWrite(PROPERTY_FOLDER_ACTIONS, oldValue, this.folderActions);
    }

    @Override
    public Collection<FolderAction> getFolderActions() {
        return folderActions;
    }

    @Override
    public int sizeFolderActions() {
        if (folderActions == null) {
            return 0;
        }
        return folderActions.size();
    }

    @Override
    public boolean isFolderActionsEmpty() {
        int size = sizeFolderActions();
        return size == 0;
    }

    @Override
    public boolean isFolderActionsNotEmpty() {
        boolean empty = isFolderActionsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsFolderActions(FolderAction folderActions) {
        boolean contains = this.folderActions !=null && this.folderActions.contains(folderActions);
        return contains;
    }

    @Override
    public void addCustomerResponsibles(FaxToMailUser customerResponsibles) {
        fireOnPreWrite(PROPERTY_CUSTOMER_RESPONSIBLES, null, customerResponsibles);
        if (this.customerResponsibles == null) {
            this.customerResponsibles = new LinkedList<FaxToMailUser>();
        }

        this.customerResponsibles.add(customerResponsibles);
        fireOnPostWrite(PROPERTY_CUSTOMER_RESPONSIBLES, this.customerResponsibles.size(), null, customerResponsibles);
    }

    @Override
    public void addAllCustomerResponsibles(Collection<FaxToMailUser> customerResponsibles) {
        if (customerResponsibles == null) {
            return;
        }
        for (FaxToMailUser item : customerResponsibles) {
            addCustomerResponsibles(item);
        }
    }

    @Override
    public void setCustomerResponsibles(Collection<FaxToMailUser> customerResponsibles) {
        // Copy elements to keep data for fire with new reference
        Collection<FaxToMailUser> oldValue = this.customerResponsibles != null ? new LinkedList<FaxToMailUser>(this.customerResponsibles) : null;
        fireOnPreWrite(PROPERTY_CUSTOMER_RESPONSIBLES, oldValue, customerResponsibles);
        this.customerResponsibles = customerResponsibles;
        fireOnPostWrite(PROPERTY_CUSTOMER_RESPONSIBLES, oldValue, customerResponsibles);
    }

    @Override
    public void removeCustomerResponsibles(FaxToMailUser customerResponsibles) {
        fireOnPreWrite(PROPERTY_CUSTOMER_RESPONSIBLES, customerResponsibles, null);
        if (this.customerResponsibles == null || !this.customerResponsibles.remove(customerResponsibles)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_CUSTOMER_RESPONSIBLES, this.customerResponsibles.size() + 1, customerResponsibles, null);
    }

    @Override
    public void clearCustomerResponsibles() {
        if (this.customerResponsibles == null) {
            return;
        }
        Collection<FaxToMailUser> oldValue = new LinkedList<FaxToMailUser>(this.customerResponsibles);
        fireOnPreWrite(PROPERTY_CUSTOMER_RESPONSIBLES, oldValue, this.customerResponsibles);
        this.customerResponsibles.clear();
        fireOnPostWrite(PROPERTY_CUSTOMER_RESPONSIBLES, oldValue, this.customerResponsibles);
    }

    @Override
    public Collection<FaxToMailUser> getCustomerResponsibles() {
        return customerResponsibles;
    }

    @Override
    public FaxToMailUser getCustomerResponsiblesByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(customerResponsibles, topiaId);
    }

    @Override
    public Collection<String> getCustomerResponsiblesTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.FaxToMailUser> tmp = getCustomerResponsibles();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeCustomerResponsibles() {
        if (customerResponsibles == null) {
            return 0;
        }
        return customerResponsibles.size();
    }

    @Override
    public boolean isCustomerResponsiblesEmpty() {
        int size = sizeCustomerResponsibles();
        return size == 0;
    }

    @Override
    public boolean isCustomerResponsiblesNotEmpty() {
        boolean empty = isCustomerResponsiblesEmpty();
        return ! empty;
    }

    @Override
    public boolean containsCustomerResponsibles(FaxToMailUser customerResponsibles) {
        boolean contains = this.customerResponsibles !=null && this.customerResponsibles.contains(customerResponsibles);
        return contains;
    }

    @Override
    public void addWriteRightUsers(FaxToMailUser writeRightUsers) {
        fireOnPreWrite(PROPERTY_WRITE_RIGHT_USERS, null, writeRightUsers);
        if (this.writeRightUsers == null) {
            this.writeRightUsers = new LinkedList<FaxToMailUser>();
        }

        this.writeRightUsers.add(writeRightUsers);
        fireOnPostWrite(PROPERTY_WRITE_RIGHT_USERS, this.writeRightUsers.size(), null, writeRightUsers);
    }

    @Override
    public void addAllWriteRightUsers(Collection<FaxToMailUser> writeRightUsers) {
        if (writeRightUsers == null) {
            return;
        }
        for (FaxToMailUser item : writeRightUsers) {
            addWriteRightUsers(item);
        }
    }

    @Override
    public void setWriteRightUsers(Collection<FaxToMailUser> writeRightUsers) {
        // Copy elements to keep data for fire with new reference
        Collection<FaxToMailUser> oldValue = this.writeRightUsers != null ? new LinkedList<FaxToMailUser>(this.writeRightUsers) : null;
        fireOnPreWrite(PROPERTY_WRITE_RIGHT_USERS, oldValue, writeRightUsers);
        this.writeRightUsers = writeRightUsers;
        fireOnPostWrite(PROPERTY_WRITE_RIGHT_USERS, oldValue, writeRightUsers);
    }

    @Override
    public void removeWriteRightUsers(FaxToMailUser writeRightUsers) {
        fireOnPreWrite(PROPERTY_WRITE_RIGHT_USERS, writeRightUsers, null);
        if (this.writeRightUsers == null || !this.writeRightUsers.remove(writeRightUsers)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_WRITE_RIGHT_USERS, this.writeRightUsers.size() + 1, writeRightUsers, null);
    }

    @Override
    public void clearWriteRightUsers() {
        if (this.writeRightUsers == null) {
            return;
        }
        Collection<FaxToMailUser> oldValue = new LinkedList<FaxToMailUser>(this.writeRightUsers);
        fireOnPreWrite(PROPERTY_WRITE_RIGHT_USERS, oldValue, this.writeRightUsers);
        this.writeRightUsers.clear();
        fireOnPostWrite(PROPERTY_WRITE_RIGHT_USERS, oldValue, this.writeRightUsers);
    }

    @Override
    public Collection<FaxToMailUser> getWriteRightUsers() {
        return writeRightUsers;
    }

    @Override
    public FaxToMailUser getWriteRightUsersByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(writeRightUsers, topiaId);
    }

    @Override
    public Collection<String> getWriteRightUsersTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.FaxToMailUser> tmp = getWriteRightUsers();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeWriteRightUsers() {
        if (writeRightUsers == null) {
            return 0;
        }
        return writeRightUsers.size();
    }

    @Override
    public boolean isWriteRightUsersEmpty() {
        int size = sizeWriteRightUsers();
        return size == 0;
    }

    @Override
    public boolean isWriteRightUsersNotEmpty() {
        boolean empty = isWriteRightUsersEmpty();
        return ! empty;
    }

    @Override
    public boolean containsWriteRightUsers(FaxToMailUser writeRightUsers) {
        boolean contains = this.writeRightUsers !=null && this.writeRightUsers.contains(writeRightUsers);
        return contains;
    }

    @Override
    public void addReadRightUsers(FaxToMailUser readRightUsers) {
        fireOnPreWrite(PROPERTY_READ_RIGHT_USERS, null, readRightUsers);
        if (this.readRightUsers == null) {
            this.readRightUsers = new LinkedList<FaxToMailUser>();
        }

        this.readRightUsers.add(readRightUsers);
        fireOnPostWrite(PROPERTY_READ_RIGHT_USERS, this.readRightUsers.size(), null, readRightUsers);
    }

    @Override
    public void addAllReadRightUsers(Collection<FaxToMailUser> readRightUsers) {
        if (readRightUsers == null) {
            return;
        }
        for (FaxToMailUser item : readRightUsers) {
            addReadRightUsers(item);
        }
    }

    @Override
    public void setReadRightUsers(Collection<FaxToMailUser> readRightUsers) {
        // Copy elements to keep data for fire with new reference
        Collection<FaxToMailUser> oldValue = this.readRightUsers != null ? new LinkedList<FaxToMailUser>(this.readRightUsers) : null;
        fireOnPreWrite(PROPERTY_READ_RIGHT_USERS, oldValue, readRightUsers);
        this.readRightUsers = readRightUsers;
        fireOnPostWrite(PROPERTY_READ_RIGHT_USERS, oldValue, readRightUsers);
    }

    @Override
    public void removeReadRightUsers(FaxToMailUser readRightUsers) {
        fireOnPreWrite(PROPERTY_READ_RIGHT_USERS, readRightUsers, null);
        if (this.readRightUsers == null || !this.readRightUsers.remove(readRightUsers)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_READ_RIGHT_USERS, this.readRightUsers.size() + 1, readRightUsers, null);
    }

    @Override
    public void clearReadRightUsers() {
        if (this.readRightUsers == null) {
            return;
        }
        Collection<FaxToMailUser> oldValue = new LinkedList<FaxToMailUser>(this.readRightUsers);
        fireOnPreWrite(PROPERTY_READ_RIGHT_USERS, oldValue, this.readRightUsers);
        this.readRightUsers.clear();
        fireOnPostWrite(PROPERTY_READ_RIGHT_USERS, oldValue, this.readRightUsers);
    }

    @Override
    public Collection<FaxToMailUser> getReadRightUsers() {
        return readRightUsers;
    }

    @Override
    public FaxToMailUser getReadRightUsersByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(readRightUsers, topiaId);
    }

    @Override
    public Collection<String> getReadRightUsersTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.FaxToMailUser> tmp = getReadRightUsers();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeReadRightUsers() {
        if (readRightUsers == null) {
            return 0;
        }
        return readRightUsers.size();
    }

    @Override
    public boolean isReadRightUsersEmpty() {
        int size = sizeReadRightUsers();
        return size == 0;
    }

    @Override
    public boolean isReadRightUsersNotEmpty() {
        boolean empty = isReadRightUsersEmpty();
        return ! empty;
    }

    @Override
    public boolean containsReadRightUsers(FaxToMailUser readRightUsers) {
        boolean contains = this.readRightUsers !=null && this.readRightUsers.contains(readRightUsers);
        return contains;
    }

    @Override
    public void addMoveRightUsers(FaxToMailUser moveRightUsers) {
        fireOnPreWrite(PROPERTY_MOVE_RIGHT_USERS, null, moveRightUsers);
        if (this.moveRightUsers == null) {
            this.moveRightUsers = new LinkedList<FaxToMailUser>();
        }

        this.moveRightUsers.add(moveRightUsers);
        fireOnPostWrite(PROPERTY_MOVE_RIGHT_USERS, this.moveRightUsers.size(), null, moveRightUsers);
    }

    @Override
    public void addAllMoveRightUsers(Collection<FaxToMailUser> moveRightUsers) {
        if (moveRightUsers == null) {
            return;
        }
        for (FaxToMailUser item : moveRightUsers) {
            addMoveRightUsers(item);
        }
    }

    @Override
    public void setMoveRightUsers(Collection<FaxToMailUser> moveRightUsers) {
        // Copy elements to keep data for fire with new reference
        Collection<FaxToMailUser> oldValue = this.moveRightUsers != null ? new LinkedList<FaxToMailUser>(this.moveRightUsers) : null;
        fireOnPreWrite(PROPERTY_MOVE_RIGHT_USERS, oldValue, moveRightUsers);
        this.moveRightUsers = moveRightUsers;
        fireOnPostWrite(PROPERTY_MOVE_RIGHT_USERS, oldValue, moveRightUsers);
    }

    @Override
    public void removeMoveRightUsers(FaxToMailUser moveRightUsers) {
        fireOnPreWrite(PROPERTY_MOVE_RIGHT_USERS, moveRightUsers, null);
        if (this.moveRightUsers == null || !this.moveRightUsers.remove(moveRightUsers)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_MOVE_RIGHT_USERS, this.moveRightUsers.size() + 1, moveRightUsers, null);
    }

    @Override
    public void clearMoveRightUsers() {
        if (this.moveRightUsers == null) {
            return;
        }
        Collection<FaxToMailUser> oldValue = new LinkedList<FaxToMailUser>(this.moveRightUsers);
        fireOnPreWrite(PROPERTY_MOVE_RIGHT_USERS, oldValue, this.moveRightUsers);
        this.moveRightUsers.clear();
        fireOnPostWrite(PROPERTY_MOVE_RIGHT_USERS, oldValue, this.moveRightUsers);
    }

    @Override
    public Collection<FaxToMailUser> getMoveRightUsers() {
        return moveRightUsers;
    }

    @Override
    public FaxToMailUser getMoveRightUsersByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(moveRightUsers, topiaId);
    }

    @Override
    public Collection<String> getMoveRightUsersTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.FaxToMailUser> tmp = getMoveRightUsers();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeMoveRightUsers() {
        if (moveRightUsers == null) {
            return 0;
        }
        return moveRightUsers.size();
    }

    @Override
    public boolean isMoveRightUsersEmpty() {
        int size = sizeMoveRightUsers();
        return size == 0;
    }

    @Override
    public boolean isMoveRightUsersNotEmpty() {
        boolean empty = isMoveRightUsersEmpty();
        return ! empty;
    }

    @Override
    public boolean containsMoveRightUsers(FaxToMailUser moveRightUsers) {
        boolean contains = this.moveRightUsers !=null && this.moveRightUsers.contains(moveRightUsers);
        return contains;
    }

    @Override
    public void addWriteRightGroups(FaxToMailUserGroup writeRightGroups) {
        fireOnPreWrite(PROPERTY_WRITE_RIGHT_GROUPS, null, writeRightGroups);
        if (this.writeRightGroups == null) {
            this.writeRightGroups = new LinkedList<FaxToMailUserGroup>();
        }

        this.writeRightGroups.add(writeRightGroups);
        fireOnPostWrite(PROPERTY_WRITE_RIGHT_GROUPS, this.writeRightGroups.size(), null, writeRightGroups);
    }

    @Override
    public void addAllWriteRightGroups(Collection<FaxToMailUserGroup> writeRightGroups) {
        if (writeRightGroups == null) {
            return;
        }
        for (FaxToMailUserGroup item : writeRightGroups) {
            addWriteRightGroups(item);
        }
    }

    @Override
    public void setWriteRightGroups(Collection<FaxToMailUserGroup> writeRightGroups) {
        // Copy elements to keep data for fire with new reference
        Collection<FaxToMailUserGroup> oldValue = this.writeRightGroups != null ? new LinkedList<FaxToMailUserGroup>(this.writeRightGroups) : null;
        fireOnPreWrite(PROPERTY_WRITE_RIGHT_GROUPS, oldValue, writeRightGroups);
        this.writeRightGroups = writeRightGroups;
        fireOnPostWrite(PROPERTY_WRITE_RIGHT_GROUPS, oldValue, writeRightGroups);
    }

    @Override
    public void removeWriteRightGroups(FaxToMailUserGroup writeRightGroups) {
        fireOnPreWrite(PROPERTY_WRITE_RIGHT_GROUPS, writeRightGroups, null);
        if (this.writeRightGroups == null || !this.writeRightGroups.remove(writeRightGroups)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_WRITE_RIGHT_GROUPS, this.writeRightGroups.size() + 1, writeRightGroups, null);
    }

    @Override
    public void clearWriteRightGroups() {
        if (this.writeRightGroups == null) {
            return;
        }
        Collection<FaxToMailUserGroup> oldValue = new LinkedList<FaxToMailUserGroup>(this.writeRightGroups);
        fireOnPreWrite(PROPERTY_WRITE_RIGHT_GROUPS, oldValue, this.writeRightGroups);
        this.writeRightGroups.clear();
        fireOnPostWrite(PROPERTY_WRITE_RIGHT_GROUPS, oldValue, this.writeRightGroups);
    }

    @Override
    public Collection<FaxToMailUserGroup> getWriteRightGroups() {
        return writeRightGroups;
    }

    @Override
    public FaxToMailUserGroup getWriteRightGroupsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(writeRightGroups, topiaId);
    }

    @Override
    public Collection<String> getWriteRightGroupsTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.FaxToMailUserGroup> tmp = getWriteRightGroups();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeWriteRightGroups() {
        if (writeRightGroups == null) {
            return 0;
        }
        return writeRightGroups.size();
    }

    @Override
    public boolean isWriteRightGroupsEmpty() {
        int size = sizeWriteRightGroups();
        return size == 0;
    }

    @Override
    public boolean isWriteRightGroupsNotEmpty() {
        boolean empty = isWriteRightGroupsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsWriteRightGroups(FaxToMailUserGroup writeRightGroups) {
        boolean contains = this.writeRightGroups !=null && this.writeRightGroups.contains(writeRightGroups);
        return contains;
    }

    @Override
    public void addMoveRightGroups(FaxToMailUserGroup moveRightGroups) {
        fireOnPreWrite(PROPERTY_MOVE_RIGHT_GROUPS, null, moveRightGroups);
        if (this.moveRightGroups == null) {
            this.moveRightGroups = new LinkedList<FaxToMailUserGroup>();
        }

        this.moveRightGroups.add(moveRightGroups);
        fireOnPostWrite(PROPERTY_MOVE_RIGHT_GROUPS, this.moveRightGroups.size(), null, moveRightGroups);
    }

    @Override
    public void addAllMoveRightGroups(Collection<FaxToMailUserGroup> moveRightGroups) {
        if (moveRightGroups == null) {
            return;
        }
        for (FaxToMailUserGroup item : moveRightGroups) {
            addMoveRightGroups(item);
        }
    }

    @Override
    public void setMoveRightGroups(Collection<FaxToMailUserGroup> moveRightGroups) {
        // Copy elements to keep data for fire with new reference
        Collection<FaxToMailUserGroup> oldValue = this.moveRightGroups != null ? new LinkedList<FaxToMailUserGroup>(this.moveRightGroups) : null;
        fireOnPreWrite(PROPERTY_MOVE_RIGHT_GROUPS, oldValue, moveRightGroups);
        this.moveRightGroups = moveRightGroups;
        fireOnPostWrite(PROPERTY_MOVE_RIGHT_GROUPS, oldValue, moveRightGroups);
    }

    @Override
    public void removeMoveRightGroups(FaxToMailUserGroup moveRightGroups) {
        fireOnPreWrite(PROPERTY_MOVE_RIGHT_GROUPS, moveRightGroups, null);
        if (this.moveRightGroups == null || !this.moveRightGroups.remove(moveRightGroups)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_MOVE_RIGHT_GROUPS, this.moveRightGroups.size() + 1, moveRightGroups, null);
    }

    @Override
    public void clearMoveRightGroups() {
        if (this.moveRightGroups == null) {
            return;
        }
        Collection<FaxToMailUserGroup> oldValue = new LinkedList<FaxToMailUserGroup>(this.moveRightGroups);
        fireOnPreWrite(PROPERTY_MOVE_RIGHT_GROUPS, oldValue, this.moveRightGroups);
        this.moveRightGroups.clear();
        fireOnPostWrite(PROPERTY_MOVE_RIGHT_GROUPS, oldValue, this.moveRightGroups);
    }

    @Override
    public Collection<FaxToMailUserGroup> getMoveRightGroups() {
        return moveRightGroups;
    }

    @Override
    public FaxToMailUserGroup getMoveRightGroupsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(moveRightGroups, topiaId);
    }

    @Override
    public Collection<String> getMoveRightGroupsTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.FaxToMailUserGroup> tmp = getMoveRightGroups();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeMoveRightGroups() {
        if (moveRightGroups == null) {
            return 0;
        }
        return moveRightGroups.size();
    }

    @Override
    public boolean isMoveRightGroupsEmpty() {
        int size = sizeMoveRightGroups();
        return size == 0;
    }

    @Override
    public boolean isMoveRightGroupsNotEmpty() {
        boolean empty = isMoveRightGroupsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsMoveRightGroups(FaxToMailUserGroup moveRightGroups) {
        boolean contains = this.moveRightGroups !=null && this.moveRightGroups.contains(moveRightGroups);
        return contains;
    }

    @Override
    public void addReadRightGroups(FaxToMailUserGroup readRightGroups) {
        fireOnPreWrite(PROPERTY_READ_RIGHT_GROUPS, null, readRightGroups);
        if (this.readRightGroups == null) {
            this.readRightGroups = new LinkedList<FaxToMailUserGroup>();
        }

        this.readRightGroups.add(readRightGroups);
        fireOnPostWrite(PROPERTY_READ_RIGHT_GROUPS, this.readRightGroups.size(), null, readRightGroups);
    }

    @Override
    public void addAllReadRightGroups(Collection<FaxToMailUserGroup> readRightGroups) {
        if (readRightGroups == null) {
            return;
        }
        for (FaxToMailUserGroup item : readRightGroups) {
            addReadRightGroups(item);
        }
    }

    @Override
    public void setReadRightGroups(Collection<FaxToMailUserGroup> readRightGroups) {
        // Copy elements to keep data for fire with new reference
        Collection<FaxToMailUserGroup> oldValue = this.readRightGroups != null ? new LinkedList<FaxToMailUserGroup>(this.readRightGroups) : null;
        fireOnPreWrite(PROPERTY_READ_RIGHT_GROUPS, oldValue, readRightGroups);
        this.readRightGroups = readRightGroups;
        fireOnPostWrite(PROPERTY_READ_RIGHT_GROUPS, oldValue, readRightGroups);
    }

    @Override
    public void removeReadRightGroups(FaxToMailUserGroup readRightGroups) {
        fireOnPreWrite(PROPERTY_READ_RIGHT_GROUPS, readRightGroups, null);
        if (this.readRightGroups == null || !this.readRightGroups.remove(readRightGroups)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_READ_RIGHT_GROUPS, this.readRightGroups.size() + 1, readRightGroups, null);
    }

    @Override
    public void clearReadRightGroups() {
        if (this.readRightGroups == null) {
            return;
        }
        Collection<FaxToMailUserGroup> oldValue = new LinkedList<FaxToMailUserGroup>(this.readRightGroups);
        fireOnPreWrite(PROPERTY_READ_RIGHT_GROUPS, oldValue, this.readRightGroups);
        this.readRightGroups.clear();
        fireOnPostWrite(PROPERTY_READ_RIGHT_GROUPS, oldValue, this.readRightGroups);
    }

    @Override
    public Collection<FaxToMailUserGroup> getReadRightGroups() {
        return readRightGroups;
    }

    @Override
    public FaxToMailUserGroup getReadRightGroupsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(readRightGroups, topiaId);
    }

    @Override
    public Collection<String> getReadRightGroupsTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.FaxToMailUserGroup> tmp = getReadRightGroups();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeReadRightGroups() {
        if (readRightGroups == null) {
            return 0;
        }
        return readRightGroups.size();
    }

    @Override
    public boolean isReadRightGroupsEmpty() {
        int size = sizeReadRightGroups();
        return size == 0;
    }

    @Override
    public boolean isReadRightGroupsNotEmpty() {
        boolean empty = isReadRightGroupsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsReadRightGroups(FaxToMailUserGroup readRightGroups) {
        boolean contains = this.readRightGroups !=null && this.readRightGroups.contains(readRightGroups);
        return contains;
    }

} //MailFolderAbstract
