package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Tue Jun 10 11:30:03 CEST 2014")
public abstract class DemandTypeAbstract extends AbstractTopiaEntity implements DemandType {

    /**
     * Nom de l'attribut en BD : label
     */
    protected String label;

    /**
     * Nom de l'attribut en BD : fields
     */
    protected Collection<MailField> fields;

    private static final long serialVersionUID = 3761743954621982004L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_LABEL, String.class, label);
        visitor.visit(this, PROPERTY_FIELDS, Collection.class, MailField.class, fields);
        visitor.end(this);
    }

    @Override
    public void setLabel(String label) {
        String oldValue = this.label;
        fireOnPreWrite(PROPERTY_LABEL, oldValue, label);
        this.label = label;
        fireOnPostWrite(PROPERTY_LABEL, oldValue, label);
    }

    @Override
    public String getLabel() {
        fireOnPreRead(PROPERTY_LABEL, label);
        String result = this.label;
        fireOnPostRead(PROPERTY_LABEL, label);
        return result;
    }

    @Override
    public void addFields(MailField fields) {
        fireOnPreWrite(PROPERTY_FIELDS, null, fields);
        if (this.fields == null) {
            this.fields = new LinkedList<MailField>();
        }

        this.fields.add(fields);
        fireOnPostWrite(PROPERTY_FIELDS, this.fields.size(), null, fields);
    }

    @Override
    public void addAllFields(Collection<MailField> fields) {
        if (fields == null) {
            return;
        }
        for (MailField item : fields) {
            addFields(item);
        }
    }

    @Override
    public void setFields(Collection<MailField> fields) {
        // Copy elements to keep data for fire with new reference
        Collection<MailField> oldValue = this.fields != null ? new LinkedList<MailField>(this.fields) : null;
        fireOnPreWrite(PROPERTY_FIELDS, oldValue, fields);
        this.fields = fields;
        fireOnPostWrite(PROPERTY_FIELDS, oldValue, fields);
    }

    @Override
    public void removeFields(MailField fields) {
        fireOnPreWrite(PROPERTY_FIELDS, fields, null);
        if (this.fields == null || !this.fields.remove(fields)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_FIELDS, this.fields.size() + 1, fields, null);
    }

    @Override
    public void clearFields() {
        if (this.fields == null) {
            return;
        }
        Collection<MailField> oldValue = new LinkedList<MailField>(this.fields);
        fireOnPreWrite(PROPERTY_FIELDS, oldValue, this.fields);
        this.fields.clear();
        fireOnPostWrite(PROPERTY_FIELDS, oldValue, this.fields);
    }

    @Override
    public Collection<MailField> getFields() {
        return fields;
    }

    @Override
    public int sizeFields() {
        if (fields == null) {
            return 0;
        }
        return fields.size();
    }

    @Override
    public boolean isFieldsEmpty() {
        int size = sizeFields();
        return size == 0;
    }

    @Override
    public boolean isFieldsNotEmpty() {
        boolean empty = isFieldsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsFields(MailField fields) {
        boolean contains = this.fields !=null && this.fields.contains(fields);
        return contains;
    }

} //DemandTypeAbstract
