/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java;

import org.fife.rsta.ac.java.MemberCompletion;
import org.fife.rsta.ac.java.rjc.ast.Method;
import org.fife.rsta.ac.java.rjc.ast.TypeDeclaration;
import org.fife.rsta.ac.java.rjc.lang.Modifiers;
import org.fife.rsta.ac.java.rjc.lang.Type;

class MethodData
implements MemberCompletion.Data {
    private Method method;

    public MethodData(Method method) {
        this.method = method;
    }

    public String getDefinedIn() {
        TypeDeclaration td = this.method.getParentTypeDeclaration();
        if (td == null) {
            new Exception("No parent type declaration for: " + this.getSignature()).printStackTrace();
            return "";
        }
        return this.method.getParentTypeDeclaration().getName();
    }

    public String getIcon() {
        String key = null;
        Modifiers mod = this.method.getModifiers();
        key = mod == null ? "methodDefaultIcon" : (mod.isPrivate() ? "methodPrivateIcon" : (mod.isProtected() ? "methodProtectedIcon" : (mod.isPublic() ? "methodPublicIcon" : "methodDefaultIcon")));
        return key;
    }

    public String getSignature() {
        return this.method.getNameAndParameters();
    }

    public String getSummary() {
        String docComment = this.method.getDocComment();
        return docComment != null ? docComment : this.method.toString();
    }

    public String getType() {
        Type type = this.method.getType();
        return type == null ? "void" : type.toString();
    }

    public boolean isAbstract() {
        return this.method.getModifiers().isAbstract();
    }

    public boolean isDeprecated() {
        return this.method.isDeprecated();
    }

    public boolean isFinal() {
        return this.method.getModifiers().isFinal();
    }

    public boolean isStatic() {
        return this.method.getModifiers().isStatic();
    }
}

