/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.fife.rsta.ac.LanguageSupport;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class LanguageSupportFactory
implements PropertyChangeListener {
    private static LanguageSupportFactory INSTANCE = new LanguageSupportFactory();
    private Map styleToSupport;
    private static final String LANGUAGE_SUPPORT_PROPERTY = "org.fife.rsta.ac.LanguageSupport";

    private LanguageSupportFactory() {
        this.createSupportMap();
    }

    private void createSupportMap() {
        this.styleToSupport = new HashMap();
        String prefix = "org.fife.rsta.ac.";
        this.styleToSupport.put("text/c", prefix + "c.CLanguageSupport");
        this.styleToSupport.put("text/html", prefix + "html.HtmlLanguageSupport");
        this.styleToSupport.put("text/java", prefix + "java.JavaLanguageSupport");
        this.styleToSupport.put("text/perl", prefix + "perl.PerlLanguageSupport");
        this.styleToSupport.put("text/php", prefix + "php.PhpLanguageSupport");
        this.styleToSupport.put("text/unix", prefix + "sh.ShellLanguageSupport");
    }

    public static LanguageSupportFactory get() {
        return INSTANCE;
    }

    public LanguageSupport getSupportFor(String style) {
        LanguageSupport support = null;
        Object obj = this.styleToSupport.get(style);
        if (obj instanceof String) {
            try {
                Class<?> clazz = Class.forName((String)obj);
                support = (LanguageSupport)clazz.newInstance();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.styleToSupport.put(style, support);
            return support;
        }
        return (LanguageSupport)obj;
    }

    private void installSupport(RSyntaxTextArea textArea) {
        String style = textArea.getSyntaxEditingStyle();
        LanguageSupport support = this.getSupportFor(style);
        if (support != null) {
            support.install(textArea);
        }
        textArea.putClientProperty((Object)LANGUAGE_SUPPORT_PROPERTY, (Object)support);
    }

    public void propertyChange(PropertyChangeEvent e) {
        RSyntaxTextArea source = (RSyntaxTextArea)e.getSource();
        String name = e.getPropertyName();
        if ("RSTA.syntaxStyle".equals(name)) {
            this.uninstallSupport(source);
            this.installSupport(source);
        }
    }

    public void register(RSyntaxTextArea textArea) {
        this.installSupport(textArea);
        textArea.addPropertyChangeListener("RSTA.syntaxStyle", (PropertyChangeListener)this);
    }

    private void uninstallSupport(RSyntaxTextArea textArea) {
        LanguageSupport support = (LanguageSupport)textArea.getClientProperty((Object)LANGUAGE_SUPPORT_PROPERTY);
        if (support != null) {
            support.uninstall(textArea);
        }
    }

    public void unregister(RSyntaxTextArea textArea) {
        this.uninstallSupport(textArea);
        textArea.removePropertyChangeListener("RSTA.syntaxStyle", (PropertyChangeListener)this);
    }
}

