/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.fife.rsta.ac.OutputCollector;

public class IOUtil {
    private static Map DEFAULT_ENV;

    private IOUtil() {
    }

    private static Map getDefaultEnvMap() {
        if (DEFAULT_ENV != null) {
            return DEFAULT_ENV;
        }
        try {
            Method m = System.class.getDeclaredMethod("getenv", null);
            DEFAULT_ENV = (Map)m.invoke(null, null);
        }
        catch (Exception e) {
            DEFAULT_ENV = new HashMap();
            StringBuffer stdout = new StringBuffer();
            String command = null;
            command = File.separatorChar == '\\' ? "cmd.exe /c set" : "/bin/sh -c env";
            try {
                Process p = Runtime.getRuntime().exec(command);
                IOUtil.waitForProcess(p, stdout, null);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            String str = stdout.toString();
            BufferedReader r = new BufferedReader(new StringReader(str));
            String line = null;
            try {
                while ((line = r.readLine()) != null) {
                    int equals = line.indexOf(61);
                    if (equals <= -1) continue;
                    String key = line.substring(0, equals);
                    String value = line.substring(equals + 1);
                    DEFAULT_ENV.put(key, value);
                }
                r.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return DEFAULT_ENV;
    }

    public static String getEnvSafely(String var) {
        String value;
        block8: {
            value = null;
            try {
                value = System.getenv(var);
            }
            catch (Error e) {
                String test;
                if (File.separatorChar == '\\') {
                    String test2;
                    String command = "cmd.exe /c set " + var;
                    StringBuffer stdout = new StringBuffer();
                    try {
                        Process p = Runtime.getRuntime().exec(command);
                        IOUtil.waitForProcess(p, stdout, null);
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                    String str = stdout.toString();
                    int equals = str.indexOf(61);
                    int newline = str.indexOf(10);
                    if (equals == var.length() && newline > equals && (test2 = str.substring(0, var.length())).equalsIgnoreCase(var)) {
                        value = str.substring(var.length() + 1, str.length() - 1);
                    }
                }
                String command = "/bin/sh -c env | grep \"var\"=";
                StringBuffer stdout = new StringBuffer();
                try {
                    Process p = Runtime.getRuntime().exec(command);
                    IOUtil.waitForProcess(p, stdout, null);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                String str = stdout.toString();
                int equals = str.indexOf(61);
                int newline = str.indexOf(10);
                if (equals != var.length() || newline <= equals || !(test = str.substring(0, var.length())).equals(var)) break block8;
                value = str.substring(var.length() + 1, str.length() - 1);
            }
        }
        return value;
    }

    public static String[] getEnvironmentSafely(String[] toAdd) {
        HashMap<String, String> env = IOUtil.getDefaultEnvMap();
        if (toAdd != null) {
            HashMap<String, String> temp = new HashMap<String, String>(env);
            for (int i = 0; i < toAdd.length; i += 2) {
                temp.put(toAdd[i], toAdd[i + 1]);
            }
            env = temp;
        }
        int count = env.size();
        String[] vars = new String[count];
        int i = 0;
        Iterator j = env.entrySet().iterator();
        while (j.hasNext()) {
            Map.Entry entry = j.next();
            vars[i++] = entry.getKey() + "=" + entry.getValue();
        }
        return vars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int waitForProcess(Process p, StringBuffer stdout, StringBuffer stderr) throws IOException {
        InputStream in = p.getInputStream();
        InputStream err = p.getErrorStream();
        Thread t1 = new Thread(new OutputCollector(in, stdout));
        Thread t2 = new Thread(new OutputCollector(err, stderr));
        t1.start();
        t2.start();
        int rc = -1;
        try {
            rc = p.waitFor();
            t1.join();
            t2.join();
        }
        catch (InterruptedException ie) {
            p.destroy();
        }
        finally {
            in.close();
            err.close();
        }
        return rc;
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String value = IOUtil.getEnvSafely(args[i]);
            System.out.println(args[i] + "=" + value);
        }
    }
}

