/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.BulkSendingCopyCustomField;
import com.docusign.esign.model.BulkSendingCopyRecipient;
import com.docusign.esign.model.BulksendingCopyDocGenFormField;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="This object contains the details to use for a specific copy, or instance, of the envelope. When you send an envelope by using a bulk send list, you can customize these properties for each instance.")
public class BulkSendingCopy
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="customFields")
    private List<BulkSendingCopyCustomField> customFields = null;
    @JsonProperty(value="docGenFormFields")
    private List<BulksendingCopyDocGenFormField> docGenFormFields = null;
    @JsonProperty(value="emailBlurb")
    private String emailBlurb = null;
    @JsonProperty(value="emailSubject")
    private String emailSubject = null;
    @JsonProperty(value="recipients")
    private List<BulkSendingCopyRecipient> recipients = null;

    public BulkSendingCopy customFields(List<BulkSendingCopyCustomField> customFields) {
        this.customFields = customFields;
        return this;
    }

    public BulkSendingCopy addCustomFieldsItem(BulkSendingCopyCustomField customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new ArrayList<BulkSendingCopyCustomField>();
        }
        this.customFields.add(customFieldsItem);
        return this;
    }

    @Schema(description="An optional array of strings that allows the sender to provide custom data about the recipient. This information is returned in the envelope status but otherwise not used by DocuSign. Each customField string can be a maximum of 100 characters.")
    public List<BulkSendingCopyCustomField> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(List<BulkSendingCopyCustomField> customFields) {
        this.customFields = customFields;
    }

    public BulkSendingCopy docGenFormFields(List<BulksendingCopyDocGenFormField> docGenFormFields) {
        this.docGenFormFields = docGenFormFields;
        return this;
    }

    public BulkSendingCopy addDocGenFormFieldsItem(BulksendingCopyDocGenFormField docGenFormFieldsItem) {
        if (this.docGenFormFields == null) {
            this.docGenFormFields = new ArrayList<BulksendingCopyDocGenFormField>();
        }
        this.docGenFormFields.add(docGenFormFieldsItem);
        return this;
    }

    @Schema(description="")
    public List<BulksendingCopyDocGenFormField> getDocGenFormFields() {
        return this.docGenFormFields;
    }

    public void setDocGenFormFields(List<BulksendingCopyDocGenFormField> docGenFormFields) {
        this.docGenFormFields = docGenFormFields;
    }

    public BulkSendingCopy emailBlurb(String emailBlurb) {
        this.emailBlurb = emailBlurb;
        return this;
    }

    @Schema(description="")
    public String getEmailBlurb() {
        return this.emailBlurb;
    }

    public void setEmailBlurb(String emailBlurb) {
        this.emailBlurb = emailBlurb;
    }

    public BulkSendingCopy emailSubject(String emailSubject) {
        this.emailSubject = emailSubject;
        return this;
    }

    @Schema(description="Specifies the subject of the email that is sent to all recipients.  See [ML:Template Email Subject Merge Fields] for information about adding merge field information to the email subject.")
    public String getEmailSubject() {
        return this.emailSubject;
    }

    public void setEmailSubject(String emailSubject) {
        this.emailSubject = emailSubject;
    }

    public BulkSendingCopy recipients(List<BulkSendingCopyRecipient> recipients) {
        this.recipients = recipients;
        return this;
    }

    public BulkSendingCopy addRecipientsItem(BulkSendingCopyRecipient recipientsItem) {
        if (this.recipients == null) {
            this.recipients = new ArrayList<BulkSendingCopyRecipient>();
        }
        this.recipients.add(recipientsItem);
        return this;
    }

    @Schema(description="An array of powerform recipients.")
    public List<BulkSendingCopyRecipient> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(List<BulkSendingCopyRecipient> recipients) {
        this.recipients = recipients;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BulkSendingCopy bulkSendingCopy = (BulkSendingCopy)o;
        return Objects.equals(this.customFields, bulkSendingCopy.customFields) && Objects.equals(this.docGenFormFields, bulkSendingCopy.docGenFormFields) && Objects.equals(this.emailBlurb, bulkSendingCopy.emailBlurb) && Objects.equals(this.emailSubject, bulkSendingCopy.emailSubject) && Objects.equals(this.recipients, bulkSendingCopy.recipients);
    }

    public int hashCode() {
        return Objects.hash(this.customFields, this.docGenFormFields, this.emailBlurb, this.emailSubject, this.recipients);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BulkSendingCopy {\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    docGenFormFields: ").append(this.toIndentedString(this.docGenFormFields)).append("\n");
        sb.append("    emailBlurb: ").append(this.toIndentedString(this.emailBlurb)).append("\n");
        sb.append("    emailSubject: ").append(this.toIndentedString(this.emailSubject)).append("\n");
        sb.append("    recipients: ").append(this.toIndentedString(this.recipients)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

