/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.api;

import com.docusign.esign.client.ApiClient;
import com.docusign.esign.client.ApiException;
import com.docusign.esign.client.ApiResponse;
import com.docusign.esign.client.Configuration;
import com.docusign.esign.client.Pair;
import com.docusign.esign.model.CustomFields;
import com.docusign.esign.model.DocumentFieldsInformation;
import com.docusign.esign.model.DocumentHtmlDefinition;
import com.docusign.esign.model.DocumentHtmlDefinitionOriginals;
import com.docusign.esign.model.DocumentHtmlDefinitions;
import com.docusign.esign.model.EnvelopeDefinition;
import com.docusign.esign.model.EnvelopeDocument;
import com.docusign.esign.model.EnvelopeTemplate;
import com.docusign.esign.model.EnvelopeTemplateResults;
import com.docusign.esign.model.GroupInformation;
import com.docusign.esign.model.LockInformation;
import com.docusign.esign.model.LockRequest;
import com.docusign.esign.model.Notification;
import com.docusign.esign.model.PageImages;
import com.docusign.esign.model.PageRequest;
import com.docusign.esign.model.RecipientPreviewRequest;
import com.docusign.esign.model.Recipients;
import com.docusign.esign.model.RecipientsUpdateSummary;
import com.docusign.esign.model.Tabs;
import com.docusign.esign.model.TemplateAutoMatchList;
import com.docusign.esign.model.TemplateCustomFields;
import com.docusign.esign.model.TemplateDocumentsResult;
import com.docusign.esign.model.TemplateNotificationRequest;
import com.docusign.esign.model.TemplateRecipients;
import com.docusign.esign.model.TemplateSummary;
import com.docusign.esign.model.TemplateTabs;
import com.docusign.esign.model.TemplateUpdateSummary;
import com.docusign.esign.model.TemplateViewRequest;
import com.docusign.esign.model.ViewUrl;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;

public class TemplatesApi {
    private ApiClient apiClient;

    public TemplatesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TemplatesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CustomFields createCustomFields(String accountId, String templateId, TemplateCustomFields templateCustomFields) throws ApiException {
        ApiResponse<CustomFields> localVarResponse = this.createCustomFieldsWithHttpInfo(accountId, templateId, templateCustomFields);
        return localVarResponse.getData();
    }

    public ApiResponse<CustomFields> createCustomFieldsWithHttpInfo(String accountId, String templateId, TemplateCustomFields templateCustomFields) throws ApiException {
        TemplateCustomFields localVarPostBody = templateCustomFields;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createCustomFields");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling createCustomFields");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/custom_fields".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<CustomFields> localVarReturnType = new GenericType<CustomFields>(){};
        CustomFields localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<CustomFields>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public DocumentFieldsInformation createDocumentFields(String accountId, String templateId, String documentId, DocumentFieldsInformation documentFieldsInformation) throws ApiException {
        ApiResponse<DocumentFieldsInformation> localVarResponse = this.createDocumentFieldsWithHttpInfo(accountId, templateId, documentId, documentFieldsInformation);
        return localVarResponse.getData();
    }

    public ApiResponse<DocumentFieldsInformation> createDocumentFieldsWithHttpInfo(String accountId, String templateId, String documentId, DocumentFieldsInformation documentFieldsInformation) throws ApiException {
        DocumentFieldsInformation localVarPostBody = documentFieldsInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createDocumentFields");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling createDocumentFields");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling createDocumentFields");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/fields".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentFieldsInformation> localVarReturnType = new GenericType<DocumentFieldsInformation>(){};
        DocumentFieldsInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<DocumentFieldsInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ViewUrl createEditView(String accountId, String templateId, TemplateViewRequest templateViewRequest) throws ApiException {
        ApiResponse<ViewUrl> localVarResponse = this.createEditViewWithHttpInfo(accountId, templateId, templateViewRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<ViewUrl> createEditViewWithHttpInfo(String accountId, String templateId, TemplateViewRequest templateViewRequest) throws ApiException {
        TemplateViewRequest localVarPostBody = templateViewRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createEditView");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling createEditView");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/views/edit".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ViewUrl> localVarReturnType = new GenericType<ViewUrl>(){};
        ViewUrl localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ViewUrl>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public LockInformation createLock(String accountId, String templateId, LockRequest lockRequest) throws ApiException {
        ApiResponse<LockInformation> localVarResponse = this.createLockWithHttpInfo(accountId, templateId, lockRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<LockInformation> createLockWithHttpInfo(String accountId, String templateId, LockRequest lockRequest) throws ApiException {
        LockRequest localVarPostBody = lockRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createLock");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling createLock");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/lock".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<LockInformation> localVarReturnType = new GenericType<LockInformation>(){};
        LockInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<LockInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Recipients createRecipients(String accountId, String templateId, TemplateRecipients templateRecipients) throws ApiException {
        return this.createRecipients(accountId, templateId, templateRecipients, null);
    }

    public Recipients createRecipients(String accountId, String templateId, TemplateRecipients templateRecipients, CreateRecipientsOptions options) throws ApiException {
        ApiResponse<Recipients> localVarResponse = this.createRecipientsWithHttpInfo(accountId, templateId, templateRecipients, options);
        return localVarResponse.getData();
    }

    public ApiResponse<Recipients> createRecipientsWithHttpInfo(String accountId, String templateId, TemplateRecipients templateRecipients, CreateRecipientsOptions options) throws ApiException {
        TemplateRecipients localVarPostBody = templateRecipients;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createRecipients");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling createRecipients");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/recipients".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("resend_envelope", options.resendEnvelope));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Recipients> localVarReturnType = new GenericType<Recipients>(){};
        Recipients localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Recipients>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Tabs createTabs(String accountId, String templateId, String recipientId, TemplateTabs templateTabs) throws ApiException {
        ApiResponse<Tabs> localVarResponse = this.createTabsWithHttpInfo(accountId, templateId, recipientId, templateTabs);
        return localVarResponse.getData();
    }

    public ApiResponse<Tabs> createTabsWithHttpInfo(String accountId, String templateId, String recipientId, TemplateTabs templateTabs) throws ApiException {
        TemplateTabs localVarPostBody = templateTabs;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createTabs");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling createTabs");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling createTabs");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/tabs".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Tabs> localVarReturnType = new GenericType<Tabs>(){};
        Tabs localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Tabs>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public TemplateSummary createTemplate(String accountId, EnvelopeTemplate envelopeTemplate) throws ApiException {
        ApiResponse<TemplateSummary> localVarResponse = this.createTemplateWithHttpInfo(accountId, envelopeTemplate);
        return localVarResponse.getData();
    }

    public ApiResponse<TemplateSummary> createTemplateWithHttpInfo(String accountId, EnvelopeTemplate envelopeTemplate) throws ApiException {
        EnvelopeTemplate localVarPostBody = envelopeTemplate;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createTemplate");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<TemplateSummary> localVarReturnType = new GenericType<TemplateSummary>(){};
        TemplateSummary localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<TemplateSummary>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public DocumentHtmlDefinitions createTemplateDocumentResponsiveHtmlPreview(String accountId, String templateId, String documentId, DocumentHtmlDefinition documentHtmlDefinition) throws ApiException {
        ApiResponse<DocumentHtmlDefinitions> localVarResponse = this.createTemplateDocumentResponsiveHtmlPreviewWithHttpInfo(accountId, templateId, documentId, documentHtmlDefinition);
        return localVarResponse.getData();
    }

    public ApiResponse<DocumentHtmlDefinitions> createTemplateDocumentResponsiveHtmlPreviewWithHttpInfo(String accountId, String templateId, String documentId, DocumentHtmlDefinition documentHtmlDefinition) throws ApiException {
        DocumentHtmlDefinition localVarPostBody = documentHtmlDefinition;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createTemplateDocumentResponsiveHtmlPreview");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling createTemplateDocumentResponsiveHtmlPreview");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling createTemplateDocumentResponsiveHtmlPreview");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/responsive_html_preview".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentHtmlDefinitions> localVarReturnType = new GenericType<DocumentHtmlDefinitions>(){};
        DocumentHtmlDefinitions localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<DocumentHtmlDefinitions>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Tabs createTemplateDocumentTabs(String accountId, String templateId, String documentId, TemplateTabs templateTabs) throws ApiException {
        ApiResponse<Tabs> localVarResponse = this.createTemplateDocumentTabsWithHttpInfo(accountId, templateId, documentId, templateTabs);
        return localVarResponse.getData();
    }

    public ApiResponse<Tabs> createTemplateDocumentTabsWithHttpInfo(String accountId, String templateId, String documentId, TemplateTabs templateTabs) throws ApiException {
        TemplateTabs localVarPostBody = templateTabs;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createTemplateDocumentTabs");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling createTemplateDocumentTabs");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling createTemplateDocumentTabs");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/tabs".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Tabs> localVarReturnType = new GenericType<Tabs>(){};
        Tabs localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Tabs>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ViewUrl createTemplateRecipientPreview(String accountId, String templateId, RecipientPreviewRequest recipientPreviewRequest) throws ApiException {
        ApiResponse<ViewUrl> localVarResponse = this.createTemplateRecipientPreviewWithHttpInfo(accountId, templateId, recipientPreviewRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<ViewUrl> createTemplateRecipientPreviewWithHttpInfo(String accountId, String templateId, RecipientPreviewRequest recipientPreviewRequest) throws ApiException {
        RecipientPreviewRequest localVarPostBody = recipientPreviewRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createTemplateRecipientPreview");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling createTemplateRecipientPreview");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/views/recipient_preview".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ViewUrl> localVarReturnType = new GenericType<ViewUrl>(){};
        ViewUrl localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ViewUrl>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public DocumentHtmlDefinitions createTemplateResponsiveHtmlPreview(String accountId, String templateId, DocumentHtmlDefinition documentHtmlDefinition) throws ApiException {
        ApiResponse<DocumentHtmlDefinitions> localVarResponse = this.createTemplateResponsiveHtmlPreviewWithHttpInfo(accountId, templateId, documentHtmlDefinition);
        return localVarResponse.getData();
    }

    public ApiResponse<DocumentHtmlDefinitions> createTemplateResponsiveHtmlPreviewWithHttpInfo(String accountId, String templateId, DocumentHtmlDefinition documentHtmlDefinition) throws ApiException {
        DocumentHtmlDefinition localVarPostBody = documentHtmlDefinition;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createTemplateResponsiveHtmlPreview");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling createTemplateResponsiveHtmlPreview");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/responsive_html_preview".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentHtmlDefinitions> localVarReturnType = new GenericType<DocumentHtmlDefinitions>(){};
        DocumentHtmlDefinitions localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<DocumentHtmlDefinitions>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public CustomFields deleteCustomFields(String accountId, String templateId, TemplateCustomFields templateCustomFields) throws ApiException {
        ApiResponse<CustomFields> localVarResponse = this.deleteCustomFieldsWithHttpInfo(accountId, templateId, templateCustomFields);
        return localVarResponse.getData();
    }

    public ApiResponse<CustomFields> deleteCustomFieldsWithHttpInfo(String accountId, String templateId, TemplateCustomFields templateCustomFields) throws ApiException {
        TemplateCustomFields localVarPostBody = templateCustomFields;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteCustomFields");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling deleteCustomFields");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/custom_fields".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<CustomFields> localVarReturnType = new GenericType<CustomFields>(){};
        CustomFields localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<CustomFields>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public DocumentFieldsInformation deleteDocumentFields(String accountId, String templateId, String documentId, DocumentFieldsInformation documentFieldsInformation) throws ApiException {
        ApiResponse<DocumentFieldsInformation> localVarResponse = this.deleteDocumentFieldsWithHttpInfo(accountId, templateId, documentId, documentFieldsInformation);
        return localVarResponse.getData();
    }

    public ApiResponse<DocumentFieldsInformation> deleteDocumentFieldsWithHttpInfo(String accountId, String templateId, String documentId, DocumentFieldsInformation documentFieldsInformation) throws ApiException {
        DocumentFieldsInformation localVarPostBody = documentFieldsInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteDocumentFields");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling deleteDocumentFields");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling deleteDocumentFields");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/fields".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentFieldsInformation> localVarReturnType = new GenericType<DocumentFieldsInformation>(){};
        DocumentFieldsInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<DocumentFieldsInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public void deleteDocumentPage(String accountId, String templateId, String documentId, String pageNumber, PageRequest pageRequest) throws ApiException {
        this.deleteDocumentPageWithHttpInfo(accountId, templateId, documentId, pageNumber, pageRequest);
    }

    public ApiResponse<Object> deleteDocumentPageWithHttpInfo(String accountId, String templateId, String documentId, String pageNumber, PageRequest pageRequest) throws ApiException {
        PageRequest localVarPostBody = pageRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteDocumentPage");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling deleteDocumentPage");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling deleteDocumentPage");
        }
        if (pageNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'pageNumber' when calling deleteDocumentPage");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/pages/{pageNumber}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString())).replaceAll("\\{pageNumber\\}", this.apiClient.escapeString(pageNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public TemplateDocumentsResult deleteDocuments(String accountId, String templateId, EnvelopeDefinition envelopeDefinition) throws ApiException {
        ApiResponse<TemplateDocumentsResult> localVarResponse = this.deleteDocumentsWithHttpInfo(accountId, templateId, envelopeDefinition);
        return localVarResponse.getData();
    }

    public ApiResponse<TemplateDocumentsResult> deleteDocumentsWithHttpInfo(String accountId, String templateId, EnvelopeDefinition envelopeDefinition) throws ApiException {
        EnvelopeDefinition localVarPostBody = envelopeDefinition;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteDocuments");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling deleteDocuments");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<TemplateDocumentsResult> localVarReturnType = new GenericType<TemplateDocumentsResult>(){};
        TemplateDocumentsResult localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<TemplateDocumentsResult>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public GroupInformation deleteGroupShare(String accountId, String templateId, String templatePart, GroupInformation groupInformation) throws ApiException {
        ApiResponse<GroupInformation> localVarResponse = this.deleteGroupShareWithHttpInfo(accountId, templateId, templatePart, groupInformation);
        return localVarResponse.getData();
    }

    public ApiResponse<GroupInformation> deleteGroupShareWithHttpInfo(String accountId, String templateId, String templatePart, GroupInformation groupInformation) throws ApiException {
        GroupInformation localVarPostBody = groupInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteGroupShare");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling deleteGroupShare");
        }
        if (templatePart == null) {
            throw new ApiException(400, "Missing the required parameter 'templatePart' when calling deleteGroupShare");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/{templatePart}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{templatePart\\}", this.apiClient.escapeString(templatePart.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<GroupInformation> localVarReturnType = new GenericType<GroupInformation>(){};
        GroupInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<GroupInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public LockInformation deleteLock(String accountId, String templateId, LockRequest lockRequest) throws ApiException {
        ApiResponse<LockInformation> localVarResponse = this.deleteLockWithHttpInfo(accountId, templateId, lockRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<LockInformation> deleteLockWithHttpInfo(String accountId, String templateId, LockRequest lockRequest) throws ApiException {
        LockRequest localVarPostBody = lockRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteLock");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling deleteLock");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/lock".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<LockInformation> localVarReturnType = new GenericType<LockInformation>(){};
        LockInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<LockInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Recipients deleteRecipient(String accountId, String templateId, String recipientId, TemplateRecipients templateRecipients) throws ApiException {
        ApiResponse<Recipients> localVarResponse = this.deleteRecipientWithHttpInfo(accountId, templateId, recipientId, templateRecipients);
        return localVarResponse.getData();
    }

    public ApiResponse<Recipients> deleteRecipientWithHttpInfo(String accountId, String templateId, String recipientId, TemplateRecipients templateRecipients) throws ApiException {
        TemplateRecipients localVarPostBody = templateRecipients;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteRecipient");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling deleteRecipient");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling deleteRecipient");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Recipients> localVarReturnType = new GenericType<Recipients>(){};
        Recipients localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Recipients>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Recipients deleteRecipients(String accountId, String templateId, TemplateRecipients templateRecipients) throws ApiException {
        ApiResponse<Recipients> localVarResponse = this.deleteRecipientsWithHttpInfo(accountId, templateId, templateRecipients);
        return localVarResponse.getData();
    }

    public ApiResponse<Recipients> deleteRecipientsWithHttpInfo(String accountId, String templateId, TemplateRecipients templateRecipients) throws ApiException {
        TemplateRecipients localVarPostBody = templateRecipients;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteRecipients");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling deleteRecipients");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/recipients".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Recipients> localVarReturnType = new GenericType<Recipients>(){};
        Recipients localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Recipients>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Tabs deleteTabs(String accountId, String templateId, String recipientId, TemplateTabs templateTabs) throws ApiException {
        ApiResponse<Tabs> localVarResponse = this.deleteTabsWithHttpInfo(accountId, templateId, recipientId, templateTabs);
        return localVarResponse.getData();
    }

    public ApiResponse<Tabs> deleteTabsWithHttpInfo(String accountId, String templateId, String recipientId, TemplateTabs templateTabs) throws ApiException {
        TemplateTabs localVarPostBody = templateTabs;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteTabs");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling deleteTabs");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling deleteTabs");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/tabs".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Tabs> localVarReturnType = new GenericType<Tabs>(){};
        Tabs localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Tabs>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Tabs deleteTemplateDocumentTabs(String accountId, String templateId, String documentId, TemplateTabs templateTabs) throws ApiException {
        ApiResponse<Tabs> localVarResponse = this.deleteTemplateDocumentTabsWithHttpInfo(accountId, templateId, documentId, templateTabs);
        return localVarResponse.getData();
    }

    public ApiResponse<Tabs> deleteTemplateDocumentTabsWithHttpInfo(String accountId, String templateId, String documentId, TemplateTabs templateTabs) throws ApiException {
        TemplateTabs localVarPostBody = templateTabs;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteTemplateDocumentTabs");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling deleteTemplateDocumentTabs");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling deleteTemplateDocumentTabs");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/tabs".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Tabs> localVarReturnType = new GenericType<Tabs>(){};
        Tabs localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Tabs>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public EnvelopeTemplate get(String accountId, String templateId) throws ApiException {
        return this.get(accountId, templateId, null);
    }

    public EnvelopeTemplate get(String accountId, String templateId, GetOptions options) throws ApiException {
        ApiResponse<EnvelopeTemplate> localVarResponse = this.getWithHttpInfo(accountId, templateId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<EnvelopeTemplate> getWithHttpInfo(String accountId, String templateId, GetOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling get");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling get");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include", options.include));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopeTemplate> localVarReturnType = new GenericType<EnvelopeTemplate>(){};
        EnvelopeTemplate localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<EnvelopeTemplate>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public byte[] getDocument(String accountId, String templateId, String documentId) throws ApiException {
        return this.getDocument(accountId, templateId, documentId, null);
    }

    public byte[] getDocument(String accountId, String templateId, String documentId, GetDocumentOptions options) throws ApiException {
        ApiResponse<byte[]> localVarResponse = this.getDocumentWithHttpInfo(accountId, templateId, documentId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<byte[]> getDocumentWithHttpInfo(String accountId, String templateId, String documentId, GetDocumentOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getDocument");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling getDocument");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling getDocument");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("encrypt", options.encrypt));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("file_type", options.fileType));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("show_changes", options.showChanges));
        }
        String[] localVarAccepts = new String[]{"application/pdf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<byte[]> localVarReturnType = new GenericType<byte[]>(){};
        byte[] localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<byte[]>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public byte[] getDocumentPageImage(String accountId, String templateId, String documentId, String pageNumber) throws ApiException {
        return this.getDocumentPageImage(accountId, templateId, documentId, pageNumber, null);
    }

    public byte[] getDocumentPageImage(String accountId, String templateId, String documentId, String pageNumber, GetDocumentPageImageOptions options) throws ApiException {
        ApiResponse<byte[]> localVarResponse = this.getDocumentPageImageWithHttpInfo(accountId, templateId, documentId, pageNumber, options);
        return localVarResponse.getData();
    }

    public ApiResponse<byte[]> getDocumentPageImageWithHttpInfo(String accountId, String templateId, String documentId, String pageNumber, GetDocumentPageImageOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getDocumentPageImage");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling getDocumentPageImage");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling getDocumentPageImage");
        }
        if (pageNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'pageNumber' when calling getDocumentPageImage");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/pages/{pageNumber}/page_image".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString())).replaceAll("\\{pageNumber\\}", this.apiClient.escapeString(pageNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dpi", options.dpi));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("max_height", options.maxHeight));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("max_width", options.maxWidth));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("show_changes", options.showChanges));
        }
        String[] localVarAccepts = new String[]{"image/png"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<byte[]> localVarReturnType = new GenericType<byte[]>(){};
        byte[] localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<byte[]>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Tabs getDocumentTabs(String accountId, String templateId, String documentId) throws ApiException {
        return this.getDocumentTabs(accountId, templateId, documentId, null);
    }

    public Tabs getDocumentTabs(String accountId, String templateId, String documentId, GetDocumentTabsOptions options) throws ApiException {
        ApiResponse<Tabs> localVarResponse = this.getDocumentTabsWithHttpInfo(accountId, templateId, documentId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<Tabs> getDocumentTabsWithHttpInfo(String accountId, String templateId, String documentId, GetDocumentTabsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getDocumentTabs");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling getDocumentTabs");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling getDocumentTabs");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/tabs".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_numbers", options.pageNumbers));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Tabs> localVarReturnType = new GenericType<Tabs>(){};
        Tabs localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Tabs>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public LockInformation getLock(String accountId, String templateId) throws ApiException {
        ApiResponse<LockInformation> localVarResponse = this.getLockWithHttpInfo(accountId, templateId);
        return localVarResponse.getData();
    }

    public ApiResponse<LockInformation> getLockWithHttpInfo(String accountId, String templateId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getLock");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling getLock");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/lock".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<LockInformation> localVarReturnType = new GenericType<LockInformation>(){};
        LockInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<LockInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Notification getNotificationSettings(String accountId, String templateId) throws ApiException {
        ApiResponse<Notification> localVarResponse = this.getNotificationSettingsWithHttpInfo(accountId, templateId);
        return localVarResponse.getData();
    }

    public ApiResponse<Notification> getNotificationSettingsWithHttpInfo(String accountId, String templateId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getNotificationSettings");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling getNotificationSettings");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/notification".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Notification> localVarReturnType = new GenericType<Notification>(){};
        Notification localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Notification>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Tabs getPageTabs(String accountId, String templateId, String documentId, String pageNumber) throws ApiException {
        ApiResponse<Tabs> localVarResponse = this.getPageTabsWithHttpInfo(accountId, templateId, documentId, pageNumber);
        return localVarResponse.getData();
    }

    public ApiResponse<Tabs> getPageTabsWithHttpInfo(String accountId, String templateId, String documentId, String pageNumber) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getPageTabs");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling getPageTabs");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling getPageTabs");
        }
        if (pageNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'pageNumber' when calling getPageTabs");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/pages/{pageNumber}/tabs".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString())).replaceAll("\\{pageNumber\\}", this.apiClient.escapeString(pageNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Tabs> localVarReturnType = new GenericType<Tabs>(){};
        Tabs localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Tabs>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public PageImages getPages(String accountId, String templateId, String documentId) throws ApiException {
        return this.getPages(accountId, templateId, documentId, null);
    }

    public PageImages getPages(String accountId, String templateId, String documentId, GetPagesOptions options) throws ApiException {
        ApiResponse<PageImages> localVarResponse = this.getPagesWithHttpInfo(accountId, templateId, documentId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<PageImages> getPagesWithHttpInfo(String accountId, String templateId, String documentId, GetPagesOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getPages");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling getPages");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling getPages");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/pages".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("count", options.count));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dpi", options.dpi));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("max_height", options.maxHeight));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("max_width", options.maxWidth));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("nocache", options.nocache));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("show_changes", options.showChanges));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("start_position", options.startPosition));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<PageImages> localVarReturnType = new GenericType<PageImages>(){};
        PageImages localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<PageImages>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public DocumentHtmlDefinitionOriginals getTemplateDocumentHtmlDefinitions(String accountId, String templateId, String documentId) throws ApiException {
        ApiResponse<DocumentHtmlDefinitionOriginals> localVarResponse = this.getTemplateDocumentHtmlDefinitionsWithHttpInfo(accountId, templateId, documentId);
        return localVarResponse.getData();
    }

    public ApiResponse<DocumentHtmlDefinitionOriginals> getTemplateDocumentHtmlDefinitionsWithHttpInfo(String accountId, String templateId, String documentId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getTemplateDocumentHtmlDefinitions");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling getTemplateDocumentHtmlDefinitions");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling getTemplateDocumentHtmlDefinitions");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/html_definitions".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentHtmlDefinitionOriginals> localVarReturnType = new GenericType<DocumentHtmlDefinitionOriginals>(){};
        DocumentHtmlDefinitionOriginals localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<DocumentHtmlDefinitionOriginals>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public DocumentHtmlDefinitionOriginals getTemplateHtmlDefinitions(String accountId, String templateId) throws ApiException {
        ApiResponse<DocumentHtmlDefinitionOriginals> localVarResponse = this.getTemplateHtmlDefinitionsWithHttpInfo(accountId, templateId);
        return localVarResponse.getData();
    }

    public ApiResponse<DocumentHtmlDefinitionOriginals> getTemplateHtmlDefinitionsWithHttpInfo(String accountId, String templateId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getTemplateHtmlDefinitions");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling getTemplateHtmlDefinitions");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/html_definitions".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentHtmlDefinitionOriginals> localVarReturnType = new GenericType<DocumentHtmlDefinitionOriginals>(){};
        DocumentHtmlDefinitionOriginals localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<DocumentHtmlDefinitionOriginals>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public CustomFields listCustomFields(String accountId, String templateId) throws ApiException {
        ApiResponse<CustomFields> localVarResponse = this.listCustomFieldsWithHttpInfo(accountId, templateId);
        return localVarResponse.getData();
    }

    public ApiResponse<CustomFields> listCustomFieldsWithHttpInfo(String accountId, String templateId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listCustomFields");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling listCustomFields");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/custom_fields".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<CustomFields> localVarReturnType = new GenericType<CustomFields>(){};
        CustomFields localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<CustomFields>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public DocumentFieldsInformation listDocumentFields(String accountId, String templateId, String documentId) throws ApiException {
        ApiResponse<DocumentFieldsInformation> localVarResponse = this.listDocumentFieldsWithHttpInfo(accountId, templateId, documentId);
        return localVarResponse.getData();
    }

    public ApiResponse<DocumentFieldsInformation> listDocumentFieldsWithHttpInfo(String accountId, String templateId, String documentId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listDocumentFields");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling listDocumentFields");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling listDocumentFields");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/fields".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentFieldsInformation> localVarReturnType = new GenericType<DocumentFieldsInformation>(){};
        DocumentFieldsInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<DocumentFieldsInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public TemplateDocumentsResult listDocuments(String accountId, String templateId) throws ApiException {
        return this.listDocuments(accountId, templateId, null);
    }

    public TemplateDocumentsResult listDocuments(String accountId, String templateId, ListDocumentsOptions options) throws ApiException {
        ApiResponse<TemplateDocumentsResult> localVarResponse = this.listDocumentsWithHttpInfo(accountId, templateId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<TemplateDocumentsResult> listDocumentsWithHttpInfo(String accountId, String templateId, ListDocumentsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listDocuments");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling listDocuments");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_tabs", options.includeTabs));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<TemplateDocumentsResult> localVarReturnType = new GenericType<TemplateDocumentsResult>(){};
        TemplateDocumentsResult localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<TemplateDocumentsResult>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Recipients listRecipients(String accountId, String templateId) throws ApiException {
        return this.listRecipients(accountId, templateId, null);
    }

    public Recipients listRecipients(String accountId, String templateId, ListRecipientsOptions options) throws ApiException {
        ApiResponse<Recipients> localVarResponse = this.listRecipientsWithHttpInfo(accountId, templateId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<Recipients> listRecipientsWithHttpInfo(String accountId, String templateId, ListRecipientsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listRecipients");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling listRecipients");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/recipients".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_anchor_tab_locations", options.includeAnchorTabLocations));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_extended", options.includeExtended));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_tabs", options.includeTabs));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Recipients> localVarReturnType = new GenericType<Recipients>(){};
        Recipients localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Recipients>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Tabs listTabs(String accountId, String templateId, String recipientId) throws ApiException {
        return this.listTabs(accountId, templateId, recipientId, null);
    }

    public Tabs listTabs(String accountId, String templateId, String recipientId, ListTabsOptions options) throws ApiException {
        ApiResponse<Tabs> localVarResponse = this.listTabsWithHttpInfo(accountId, templateId, recipientId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<Tabs> listTabsWithHttpInfo(String accountId, String templateId, String recipientId, ListTabsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listTabs");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling listTabs");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling listTabs");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/tabs".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_anchor_tab_locations", options.includeAnchorTabLocations));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_metadata", options.includeMetadata));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Tabs> localVarReturnType = new GenericType<Tabs>(){};
        Tabs localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Tabs>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public EnvelopeTemplateResults listTemplates(String accountId) throws ApiException {
        return this.listTemplates(accountId, null);
    }

    public EnvelopeTemplateResults listTemplates(String accountId, ListTemplatesOptions options) throws ApiException {
        ApiResponse<EnvelopeTemplateResults> localVarResponse = this.listTemplatesWithHttpInfo(accountId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<EnvelopeTemplateResults> listTemplatesWithHttpInfo(String accountId, ListTemplatesOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listTemplates");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("count", options.count));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("created_from_date", options.createdFromDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("created_to_date", options.createdToDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("folder_ids", options.folderIds));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("folder_types", options.folderTypes));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("from_date", options.fromDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include", options.include));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("is_deleted_template_only", options.isDeletedTemplateOnly));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("is_download", options.isDownload));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("modified_from_date", options.modifiedFromDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("modified_to_date", options.modifiedToDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("order", options.order));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("order_by", options.orderBy));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("search_fields", options.searchFields));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("search_text", options.searchText));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("shared_by_me", options.sharedByMe));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("start_position", options.startPosition));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("template_ids", options.templateIds));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("to_date", options.toDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("used_from_date", options.usedFromDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("used_to_date", options.usedToDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("user_filter", options.userFilter));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("user_id", options.userId));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopeTemplateResults> localVarReturnType = new GenericType<EnvelopeTemplateResults>(){};
        EnvelopeTemplateResults localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<EnvelopeTemplateResults>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public void rotateDocumentPage(String accountId, String templateId, String documentId, String pageNumber, PageRequest pageRequest) throws ApiException {
        this.rotateDocumentPageWithHttpInfo(accountId, templateId, documentId, pageNumber, pageRequest);
    }

    public ApiResponse<Object> rotateDocumentPageWithHttpInfo(String accountId, String templateId, String documentId, String pageNumber, PageRequest pageRequest) throws ApiException {
        PageRequest localVarPostBody = pageRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling rotateDocumentPage");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling rotateDocumentPage");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling rotateDocumentPage");
        }
        if (pageNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'pageNumber' when calling rotateDocumentPage");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/pages/{pageNumber}/page_image".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString())).replaceAll("\\{pageNumber\\}", this.apiClient.escapeString(pageNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public TemplateUpdateSummary update(String accountId, String templateId, EnvelopeTemplate envelopeTemplate) throws ApiException {
        ApiResponse<TemplateUpdateSummary> localVarResponse = this.updateWithHttpInfo(accountId, templateId, envelopeTemplate);
        return localVarResponse.getData();
    }

    public ApiResponse<TemplateUpdateSummary> updateWithHttpInfo(String accountId, String templateId, EnvelopeTemplate envelopeTemplate) throws ApiException {
        EnvelopeTemplate localVarPostBody = envelopeTemplate;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling update");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling update");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<TemplateUpdateSummary> localVarReturnType = new GenericType<TemplateUpdateSummary>(){};
        TemplateUpdateSummary localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<TemplateUpdateSummary>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public CustomFields updateCustomFields(String accountId, String templateId, TemplateCustomFields templateCustomFields) throws ApiException {
        ApiResponse<CustomFields> localVarResponse = this.updateCustomFieldsWithHttpInfo(accountId, templateId, templateCustomFields);
        return localVarResponse.getData();
    }

    public ApiResponse<CustomFields> updateCustomFieldsWithHttpInfo(String accountId, String templateId, TemplateCustomFields templateCustomFields) throws ApiException {
        TemplateCustomFields localVarPostBody = templateCustomFields;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateCustomFields");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling updateCustomFields");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/custom_fields".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<CustomFields> localVarReturnType = new GenericType<CustomFields>(){};
        CustomFields localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<CustomFields>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public EnvelopeDocument updateDocument(String accountId, String templateId, String documentId, EnvelopeDefinition envelopeDefinition) throws ApiException {
        return this.updateDocument(accountId, templateId, documentId, envelopeDefinition, null);
    }

    public EnvelopeDocument updateDocument(String accountId, String templateId, String documentId, EnvelopeDefinition envelopeDefinition, UpdateDocumentOptions options) throws ApiException {
        ApiResponse<EnvelopeDocument> localVarResponse = this.updateDocumentWithHttpInfo(accountId, templateId, documentId, envelopeDefinition, options);
        return localVarResponse.getData();
    }

    public ApiResponse<EnvelopeDocument> updateDocumentWithHttpInfo(String accountId, String templateId, String documentId, EnvelopeDefinition envelopeDefinition, UpdateDocumentOptions options) throws ApiException {
        EnvelopeDefinition localVarPostBody = envelopeDefinition;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateDocument");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling updateDocument");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling updateDocument");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("is_envelope_definition", options.isEnvelopeDefinition));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<EnvelopeDocument> localVarReturnType = new GenericType<EnvelopeDocument>(){};
        EnvelopeDocument localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<EnvelopeDocument>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public DocumentFieldsInformation updateDocumentFields(String accountId, String templateId, String documentId, DocumentFieldsInformation documentFieldsInformation) throws ApiException {
        ApiResponse<DocumentFieldsInformation> localVarResponse = this.updateDocumentFieldsWithHttpInfo(accountId, templateId, documentId, documentFieldsInformation);
        return localVarResponse.getData();
    }

    public ApiResponse<DocumentFieldsInformation> updateDocumentFieldsWithHttpInfo(String accountId, String templateId, String documentId, DocumentFieldsInformation documentFieldsInformation) throws ApiException {
        DocumentFieldsInformation localVarPostBody = documentFieldsInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateDocumentFields");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling updateDocumentFields");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling updateDocumentFields");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/fields".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DocumentFieldsInformation> localVarReturnType = new GenericType<DocumentFieldsInformation>(){};
        DocumentFieldsInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<DocumentFieldsInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public TemplateDocumentsResult updateDocuments(String accountId, String templateId, EnvelopeDefinition envelopeDefinition) throws ApiException {
        ApiResponse<TemplateDocumentsResult> localVarResponse = this.updateDocumentsWithHttpInfo(accountId, templateId, envelopeDefinition);
        return localVarResponse.getData();
    }

    public ApiResponse<TemplateDocumentsResult> updateDocumentsWithHttpInfo(String accountId, String templateId, EnvelopeDefinition envelopeDefinition) throws ApiException {
        EnvelopeDefinition localVarPostBody = envelopeDefinition;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateDocuments");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling updateDocuments");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<TemplateDocumentsResult> localVarReturnType = new GenericType<TemplateDocumentsResult>(){};
        TemplateDocumentsResult localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<TemplateDocumentsResult>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public GroupInformation updateGroupShare(String accountId, String templateId, String templatePart, GroupInformation groupInformation) throws ApiException {
        ApiResponse<GroupInformation> localVarResponse = this.updateGroupShareWithHttpInfo(accountId, templateId, templatePart, groupInformation);
        return localVarResponse.getData();
    }

    public ApiResponse<GroupInformation> updateGroupShareWithHttpInfo(String accountId, String templateId, String templatePart, GroupInformation groupInformation) throws ApiException {
        GroupInformation localVarPostBody = groupInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateGroupShare");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling updateGroupShare");
        }
        if (templatePart == null) {
            throw new ApiException(400, "Missing the required parameter 'templatePart' when calling updateGroupShare");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/{templatePart}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{templatePart\\}", this.apiClient.escapeString(templatePart.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<GroupInformation> localVarReturnType = new GenericType<GroupInformation>(){};
        GroupInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<GroupInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public LockInformation updateLock(String accountId, String templateId, LockRequest lockRequest) throws ApiException {
        ApiResponse<LockInformation> localVarResponse = this.updateLockWithHttpInfo(accountId, templateId, lockRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<LockInformation> updateLockWithHttpInfo(String accountId, String templateId, LockRequest lockRequest) throws ApiException {
        LockRequest localVarPostBody = lockRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateLock");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling updateLock");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/lock".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<LockInformation> localVarReturnType = new GenericType<LockInformation>(){};
        LockInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<LockInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Notification updateNotificationSettings(String accountId, String templateId, TemplateNotificationRequest templateNotificationRequest) throws ApiException {
        ApiResponse<Notification> localVarResponse = this.updateNotificationSettingsWithHttpInfo(accountId, templateId, templateNotificationRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<Notification> updateNotificationSettingsWithHttpInfo(String accountId, String templateId, TemplateNotificationRequest templateNotificationRequest) throws ApiException {
        TemplateNotificationRequest localVarPostBody = templateNotificationRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateNotificationSettings");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling updateNotificationSettings");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/notification".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Notification> localVarReturnType = new GenericType<Notification>(){};
        Notification localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Notification>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public RecipientsUpdateSummary updateRecipients(String accountId, String templateId, TemplateRecipients templateRecipients) throws ApiException {
        return this.updateRecipients(accountId, templateId, templateRecipients, null);
    }

    public RecipientsUpdateSummary updateRecipients(String accountId, String templateId, TemplateRecipients templateRecipients, UpdateRecipientsOptions options) throws ApiException {
        ApiResponse<RecipientsUpdateSummary> localVarResponse = this.updateRecipientsWithHttpInfo(accountId, templateId, templateRecipients, options);
        return localVarResponse.getData();
    }

    public ApiResponse<RecipientsUpdateSummary> updateRecipientsWithHttpInfo(String accountId, String templateId, TemplateRecipients templateRecipients, UpdateRecipientsOptions options) throws ApiException {
        TemplateRecipients localVarPostBody = templateRecipients;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateRecipients");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling updateRecipients");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/recipients".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("resend_envelope", options.resendEnvelope));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<RecipientsUpdateSummary> localVarReturnType = new GenericType<RecipientsUpdateSummary>(){};
        RecipientsUpdateSummary localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<RecipientsUpdateSummary>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Tabs updateTabs(String accountId, String templateId, String recipientId, TemplateTabs templateTabs) throws ApiException {
        ApiResponse<Tabs> localVarResponse = this.updateTabsWithHttpInfo(accountId, templateId, recipientId, templateTabs);
        return localVarResponse.getData();
    }

    public ApiResponse<Tabs> updateTabsWithHttpInfo(String accountId, String templateId, String recipientId, TemplateTabs templateTabs) throws ApiException {
        TemplateTabs localVarPostBody = templateTabs;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateTabs");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling updateTabs");
        }
        if (recipientId == null) {
            throw new ApiException(400, "Missing the required parameter 'recipientId' when calling updateTabs");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/tabs".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{recipientId\\}", this.apiClient.escapeString(recipientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Tabs> localVarReturnType = new GenericType<Tabs>(){};
        Tabs localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Tabs>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Tabs updateTemplateDocumentTabs(String accountId, String templateId, String documentId, TemplateTabs templateTabs) throws ApiException {
        ApiResponse<Tabs> localVarResponse = this.updateTemplateDocumentTabsWithHttpInfo(accountId, templateId, documentId, templateTabs);
        return localVarResponse.getData();
    }

    public ApiResponse<Tabs> updateTemplateDocumentTabsWithHttpInfo(String accountId, String templateId, String documentId, TemplateTabs templateTabs) throws ApiException {
        TemplateTabs localVarPostBody = templateTabs;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateTemplateDocumentTabs");
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling updateTemplateDocumentTabs");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling updateTemplateDocumentTabs");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/tabs".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Tabs> localVarReturnType = new GenericType<Tabs>(){};
        Tabs localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Tabs>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public TemplateAutoMatchList updateTemplates(String accountId, TemplateAutoMatchList templateAutoMatchList) throws ApiException {
        ApiResponse<TemplateAutoMatchList> localVarResponse = this.updateTemplatesWithHttpInfo(accountId, templateAutoMatchList);
        return localVarResponse.getData();
    }

    public ApiResponse<TemplateAutoMatchList> updateTemplatesWithHttpInfo(String accountId, TemplateAutoMatchList templateAutoMatchList) throws ApiException {
        TemplateAutoMatchList localVarPostBody = templateAutoMatchList;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateTemplates");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<TemplateAutoMatchList> localVarReturnType = new GenericType<TemplateAutoMatchList>(){};
        TemplateAutoMatchList localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<TemplateAutoMatchList>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public TemplateAutoMatchList updateTemplatesAutoMatch(String accountId, TemplateAutoMatchList templateAutoMatchList) throws ApiException {
        ApiResponse<TemplateAutoMatchList> localVarResponse = this.updateTemplatesAutoMatchWithHttpInfo(accountId, templateAutoMatchList);
        return localVarResponse.getData();
    }

    public ApiResponse<TemplateAutoMatchList> updateTemplatesAutoMatchWithHttpInfo(String accountId, TemplateAutoMatchList templateAutoMatchList) throws ApiException {
        TemplateAutoMatchList localVarPostBody = templateAutoMatchList;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateTemplatesAutoMatch");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/templates/auto_match".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<TemplateAutoMatchList> localVarReturnType = new GenericType<TemplateAutoMatchList>(){};
        TemplateAutoMatchList localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<TemplateAutoMatchList>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public class UpdateRecipientsOptions {
        private String resendEnvelope = null;

        public void setResendEnvelope(String resendEnvelope) {
            this.resendEnvelope = resendEnvelope;
        }

        public String getResendEnvelope() {
            return this.resendEnvelope;
        }
    }

    public class UpdateDocumentOptions {
        private String isEnvelopeDefinition = null;

        public void setIsEnvelopeDefinition(String isEnvelopeDefinition) {
            this.isEnvelopeDefinition = isEnvelopeDefinition;
        }

        public String getIsEnvelopeDefinition() {
            return this.isEnvelopeDefinition;
        }
    }

    public class ListTemplatesOptions {
        private String count = null;
        private String createdFromDate = null;
        private String createdToDate = null;
        private String folderIds = null;
        private String folderTypes = null;
        private String fromDate = null;
        private String include = null;
        private String isDeletedTemplateOnly = null;
        private String isDownload = null;
        private String modifiedFromDate = null;
        private String modifiedToDate = null;
        private String order = null;
        private String orderBy = null;
        private String searchFields = null;
        private String searchText = null;
        private String sharedByMe = null;
        private String startPosition = null;
        private String templateIds = null;
        private String toDate = null;
        private String usedFromDate = null;
        private String usedToDate = null;
        private String userFilter = null;
        private String userId = null;

        public void setCount(String count) {
            this.count = count;
        }

        public String getCount() {
            return this.count;
        }

        public void setCreatedFromDate(String createdFromDate) {
            this.createdFromDate = createdFromDate;
        }

        public String getCreatedFromDate() {
            return this.createdFromDate;
        }

        public void setCreatedToDate(String createdToDate) {
            this.createdToDate = createdToDate;
        }

        public String getCreatedToDate() {
            return this.createdToDate;
        }

        public void setFolderIds(String folderIds) {
            this.folderIds = folderIds;
        }

        public String getFolderIds() {
            return this.folderIds;
        }

        public void setFolderTypes(String folderTypes) {
            this.folderTypes = folderTypes;
        }

        public String getFolderTypes() {
            return this.folderTypes;
        }

        public void setFromDate(String fromDate) {
            this.fromDate = fromDate;
        }

        public String getFromDate() {
            return this.fromDate;
        }

        public void setInclude(String include) {
            this.include = include;
        }

        public String getInclude() {
            return this.include;
        }

        public void setIsDeletedTemplateOnly(String isDeletedTemplateOnly) {
            this.isDeletedTemplateOnly = isDeletedTemplateOnly;
        }

        public String getIsDeletedTemplateOnly() {
            return this.isDeletedTemplateOnly;
        }

        public void setIsDownload(String isDownload) {
            this.isDownload = isDownload;
        }

        public String getIsDownload() {
            return this.isDownload;
        }

        public void setModifiedFromDate(String modifiedFromDate) {
            this.modifiedFromDate = modifiedFromDate;
        }

        public String getModifiedFromDate() {
            return this.modifiedFromDate;
        }

        public void setModifiedToDate(String modifiedToDate) {
            this.modifiedToDate = modifiedToDate;
        }

        public String getModifiedToDate() {
            return this.modifiedToDate;
        }

        public void setOrder(String order) {
            this.order = order;
        }

        public String getOrder() {
            return this.order;
        }

        public void setOrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        public String getOrderBy() {
            return this.orderBy;
        }

        public void setSearchFields(String searchFields) {
            this.searchFields = searchFields;
        }

        public String getSearchFields() {
            return this.searchFields;
        }

        public void setSearchText(String searchText) {
            this.searchText = searchText;
        }

        public String getSearchText() {
            return this.searchText;
        }

        public void setSharedByMe(String sharedByMe) {
            this.sharedByMe = sharedByMe;
        }

        public String getSharedByMe() {
            return this.sharedByMe;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }

        public void setTemplateIds(String templateIds) {
            this.templateIds = templateIds;
        }

        public String getTemplateIds() {
            return this.templateIds;
        }

        public void setToDate(String toDate) {
            this.toDate = toDate;
        }

        public String getToDate() {
            return this.toDate;
        }

        public void setUsedFromDate(String usedFromDate) {
            this.usedFromDate = usedFromDate;
        }

        public String getUsedFromDate() {
            return this.usedFromDate;
        }

        public void setUsedToDate(String usedToDate) {
            this.usedToDate = usedToDate;
        }

        public String getUsedToDate() {
            return this.usedToDate;
        }

        public void setUserFilter(String userFilter) {
            this.userFilter = userFilter;
        }

        public String getUserFilter() {
            return this.userFilter;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getUserId() {
            return this.userId;
        }
    }

    public class ListTabsOptions {
        private String includeAnchorTabLocations = null;
        private String includeMetadata = null;

        public void setIncludeAnchorTabLocations(String includeAnchorTabLocations) {
            this.includeAnchorTabLocations = includeAnchorTabLocations;
        }

        public String getIncludeAnchorTabLocations() {
            return this.includeAnchorTabLocations;
        }

        public void setIncludeMetadata(String includeMetadata) {
            this.includeMetadata = includeMetadata;
        }

        public String getIncludeMetadata() {
            return this.includeMetadata;
        }
    }

    public class ListRecipientsOptions {
        private String includeAnchorTabLocations = null;
        private String includeExtended = null;
        private String includeTabs = null;

        public void setIncludeAnchorTabLocations(String includeAnchorTabLocations) {
            this.includeAnchorTabLocations = includeAnchorTabLocations;
        }

        public String getIncludeAnchorTabLocations() {
            return this.includeAnchorTabLocations;
        }

        public void setIncludeExtended(String includeExtended) {
            this.includeExtended = includeExtended;
        }

        public String getIncludeExtended() {
            return this.includeExtended;
        }

        public void setIncludeTabs(String includeTabs) {
            this.includeTabs = includeTabs;
        }

        public String getIncludeTabs() {
            return this.includeTabs;
        }
    }

    public class ListDocumentsOptions {
        private String includeTabs = null;

        public void setIncludeTabs(String includeTabs) {
            this.includeTabs = includeTabs;
        }

        public String getIncludeTabs() {
            return this.includeTabs;
        }
    }

    public class GetPagesOptions {
        private String count = null;
        private String dpi = null;
        private String maxHeight = null;
        private String maxWidth = null;
        private String nocache = null;
        private String showChanges = null;
        private String startPosition = null;

        public void setCount(String count) {
            this.count = count;
        }

        public String getCount() {
            return this.count;
        }

        public void setDpi(String dpi) {
            this.dpi = dpi;
        }

        public String getDpi() {
            return this.dpi;
        }

        public void setMaxHeight(String maxHeight) {
            this.maxHeight = maxHeight;
        }

        public String getMaxHeight() {
            return this.maxHeight;
        }

        public void setMaxWidth(String maxWidth) {
            this.maxWidth = maxWidth;
        }

        public String getMaxWidth() {
            return this.maxWidth;
        }

        public void setNocache(String nocache) {
            this.nocache = nocache;
        }

        public String getNocache() {
            return this.nocache;
        }

        public void setShowChanges(String showChanges) {
            this.showChanges = showChanges;
        }

        public String getShowChanges() {
            return this.showChanges;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }
    }

    public class GetDocumentTabsOptions {
        private String pageNumbers = null;

        public void setPageNumbers(String pageNumbers) {
            this.pageNumbers = pageNumbers;
        }

        public String getPageNumbers() {
            return this.pageNumbers;
        }
    }

    public class GetDocumentPageImageOptions {
        private String dpi = null;
        private String maxHeight = null;
        private String maxWidth = null;
        private String showChanges = null;

        public void setDpi(String dpi) {
            this.dpi = dpi;
        }

        public String getDpi() {
            return this.dpi;
        }

        public void setMaxHeight(String maxHeight) {
            this.maxHeight = maxHeight;
        }

        public String getMaxHeight() {
            return this.maxHeight;
        }

        public void setMaxWidth(String maxWidth) {
            this.maxWidth = maxWidth;
        }

        public String getMaxWidth() {
            return this.maxWidth;
        }

        public void setShowChanges(String showChanges) {
            this.showChanges = showChanges;
        }

        public String getShowChanges() {
            return this.showChanges;
        }
    }

    public class GetDocumentOptions {
        private String encrypt = null;
        private String fileType = null;
        private String showChanges = null;

        public void setEncrypt(String encrypt) {
            this.encrypt = encrypt;
        }

        public String getEncrypt() {
            return this.encrypt;
        }

        public void setFileType(String fileType) {
            this.fileType = fileType;
        }

        public String getFileType() {
            return this.fileType;
        }

        public void setShowChanges(String showChanges) {
            this.showChanges = showChanges;
        }

        public String getShowChanges() {
            return this.showChanges;
        }
    }

    public class GetOptions {
        private String include = null;

        public void setInclude(String include) {
            this.include = include;
        }

        public String getInclude() {
            return this.include;
        }
    }

    public class CreateRecipientsOptions {
        private String resendEnvelope = null;

        public void setResendEnvelope(String resendEnvelope) {
            this.resendEnvelope = resendEnvelope;
        }

        public String getResendEnvelope() {
            return this.resendEnvelope;
        }
    }
}

