/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.impl;

import com.browseengine.bobo.api.ShortFacetIterator;
import java.util.List;
import java.util.NoSuchElementException;

public class CombinedShortFacetIterator
extends ShortFacetIterator {
    public short facet;
    private final ShortFacetPriorityQueue _queue = new ShortFacetPriorityQueue();
    private List<ShortFacetIterator> _iterators;

    private CombinedShortFacetIterator(int length) {
        this._queue.initialize(length);
    }

    public CombinedShortFacetIterator(List<ShortFacetIterator> iterators) {
        this(iterators.size());
        this._iterators = iterators;
        for (ShortFacetIterator iterator : iterators) {
            ShortIteratorNode node = new ShortIteratorNode(iterator);
            if (!node.fetch(1)) continue;
            this._queue.add(node);
        }
        this.facet = (short)-1;
        this.count = 0;
    }

    public CombinedShortFacetIterator(List<ShortFacetIterator> iterators, int minHits) {
        this(iterators.size());
        this._iterators = iterators;
        for (ShortFacetIterator iterator : iterators) {
            ShortIteratorNode node = new ShortIteratorNode(iterator);
            if (!node.fetch(minHits)) continue;
            this._queue.add(node);
        }
        this.facet = (short)-1;
        this.count = 0;
    }

    public String getFacet() {
        return this.format(this.facet);
    }

    @Override
    public String format(short val) {
        return this._iterators.get(0).format(val);
    }

    @Override
    public String format(Object val) {
        return this._iterators.get(0).format(val);
    }

    public int getFacetCount() {
        return this.count;
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more facets in this iteration");
        }
        ShortIteratorNode node = this._queue.top();
        this.facet = node._curFacet;
        short next = -1;
        this.count = 0;
        while (this.hasNext()) {
            node = this._queue.top();
            next = node._curFacet;
            if (next != -1 && next != this.facet) break;
            this.count += node._curFacetCount;
            if (node.fetch(1)) {
                this._queue.updateTop();
                continue;
            }
            this._queue.pop();
        }
        return this.format(this.facet);
    }

    public String next(int minHits) {
        int qsize = this._queue.size();
        if (qsize == 0) {
            this.facet = (short)-1;
            this.count = 0;
            return null;
        }
        ShortIteratorNode node = this._queue.top();
        this.facet = node._curFacet;
        this.count = node._curFacetCount;
        while (true) {
            if (node.fetch(minHits)) {
                node = this._queue.updateTop();
            } else {
                this._queue.pop();
                if (--qsize > 0) {
                    node = this._queue.top();
                } else {
                    if (this.count >= minHits) break;
                    this.facet = (short)-1;
                    this.count = 0;
                    break;
                }
            }
            short next = node._curFacet;
            if (next != this.facet) {
                if (this.count >= minHits) break;
                this.facet = next;
                this.count = node._curFacetCount;
                continue;
            }
            this.count += node._curFacetCount;
        }
        return this.format(this.facet);
    }

    @Override
    public boolean hasNext() {
        return this._queue.size() > 0;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() method not supported for Facet Iterators");
    }

    @Override
    public short nextShort() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more facets in this iteration");
        }
        ShortIteratorNode node = this._queue.top();
        this.facet = node._curFacet;
        short next = -1;
        this.count = 0;
        while (this.hasNext()) {
            node = this._queue.top();
            next = node._curFacet;
            if (next != -1 && next != this.facet) break;
            this.count += node._curFacetCount;
            if (node.fetch(1)) {
                this._queue.updateTop();
                continue;
            }
            this._queue.pop();
        }
        return this.facet;
    }

    @Override
    public short nextShort(int minHits) {
        int qsize = this._queue.size();
        if (qsize == 0) {
            this.facet = (short)-1;
            this.count = 0;
            return -1;
        }
        ShortIteratorNode node = this._queue.top();
        this.facet = node._curFacet;
        this.count = node._curFacetCount;
        while (true) {
            if (node.fetch(minHits)) {
                node = this._queue.updateTop();
            } else {
                this._queue.pop();
                if (--qsize > 0) {
                    node = this._queue.top();
                } else {
                    if (this.count >= minHits) break;
                    this.facet = (short)-1;
                    this.count = 0;
                    break;
                }
            }
            short next = node._curFacet;
            if (next != this.facet) {
                if (this.count >= minHits) break;
                this.facet = next;
                this.count = node._curFacetCount;
                continue;
            }
            this.count += node._curFacetCount;
        }
        return this.facet;
    }

    public static class ShortFacetPriorityQueue {
        private int size;
        private int maxSize;
        protected ShortIteratorNode[] heap;

        protected final void initialize(int maxSize) {
            this.size = 0;
            int heapSize = 0 == maxSize ? 2 : maxSize + 1;
            this.heap = new ShortIteratorNode[heapSize];
            this.maxSize = maxSize;
        }

        public final void put(ShortIteratorNode element) {
            ++this.size;
            this.heap[this.size] = element;
            this.upHeap();
        }

        public final ShortIteratorNode add(ShortIteratorNode element) {
            ++this.size;
            this.heap[this.size] = element;
            this.upHeap();
            return this.heap[1];
        }

        public boolean insert(ShortIteratorNode element) {
            return this.insertWithOverflow(element) != element;
        }

        public ShortIteratorNode insertWithOverflow(ShortIteratorNode element) {
            if (this.size < this.maxSize) {
                this.put(element);
                return null;
            }
            if (this.size > 0 && element._curFacet >= this.heap[1]._curFacet) {
                ShortIteratorNode ret = this.heap[1];
                this.heap[1] = element;
                this.adjustTop();
                return ret;
            }
            return element;
        }

        public final ShortIteratorNode top() {
            return this.heap[1];
        }

        public final ShortIteratorNode pop() {
            if (this.size > 0) {
                ShortIteratorNode result = this.heap[1];
                this.heap[1] = this.heap[this.size];
                this.heap[this.size] = null;
                --this.size;
                this.downHeap();
                return result;
            }
            return null;
        }

        public final void adjustTop() {
            this.downHeap();
        }

        public final ShortIteratorNode updateTop() {
            this.downHeap();
            return this.heap[1];
        }

        public final int size() {
            return this.size;
        }

        public final void clear() {
            for (int i = 0; i <= this.size; ++i) {
                this.heap[i] = null;
            }
            this.size = 0;
        }

        private final void upHeap() {
            int i = this.size;
            ShortIteratorNode node = this.heap[i];
            for (int j = i >>> 1; j > 0 && node._curFacet < this.heap[j]._curFacet; j >>>= 1) {
                this.heap[i] = this.heap[j];
                i = j;
            }
            this.heap[i] = node;
        }

        private final void downHeap() {
            int i = 1;
            ShortIteratorNode node = this.heap[i];
            int j = i << 1;
            int k = j + 1;
            if (k <= this.size && this.heap[k]._curFacet < this.heap[j]._curFacet) {
                j = k;
            }
            while (j <= this.size && this.heap[j]._curFacet < node._curFacet) {
                this.heap[i] = this.heap[j];
                i = j;
                k = (j = i << 1) + 1;
                if (k > this.size || this.heap[k]._curFacet >= this.heap[j]._curFacet) continue;
                j = k;
            }
            this.heap[i] = node;
        }
    }

    private static class ShortIteratorNode {
        public ShortFacetIterator _iterator;
        public short _curFacet;
        public int _curFacetCount;

        public ShortIteratorNode(ShortFacetIterator iterator) {
            this._iterator = iterator;
            this._curFacet = (short)-1;
            this._curFacetCount = 0;
        }

        public boolean fetch(int minHits) {
            if (minHits > 0) {
                minHits = 1;
            }
            if ((this._curFacet = this._iterator.nextShort(minHits)) != -1) {
                this._curFacetCount = this._iterator.count;
                return true;
            }
            this._curFacet = (short)-1;
            this._curFacetCount = 0;
            return false;
        }

        public String peek() {
            throw new UnsupportedOperationException();
        }
    }
}

