/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.github.luben.zstd.ZstdInputStream;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;

public class ZstdInterceptor
implements Interceptor {
    @NotNull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        String acceptEncodingHeader = request.header("Accept-Encoding");
        String acceptEncoding = acceptEncodingHeader == null || acceptEncodingHeader.isEmpty() ? "zstd" : acceptEncodingHeader + ", zstd";
        Request compressedRequest = request.newBuilder().removeHeader("Accept-Encoding").addHeader("Accept-Encoding", acceptEncoding).build();
        Response response = chain.proceed(compressedRequest);
        String contentEncoding = response.header("Content-Encoding");
        if (contentEncoding == null || !contentEncoding.equalsIgnoreCase("zstd")) {
            return response;
        }
        ResponseBody originalBody = response.body();
        if (originalBody == null) {
            return response;
        }
        ResponseBody decompressedBody = this.createStreamingResponseBody(originalBody);
        return response.newBuilder().body(decompressedBody).addHeader("X-Content-Encoding", "zstd").removeHeader("Content-Encoding").removeHeader("Content-Length").build();
    }

    private ResponseBody createStreamingResponseBody(final ResponseBody originalBody) {
        return new ResponseBody(){

            public MediaType contentType() {
                return originalBody.contentType();
            }

            public long contentLength() {
                return -1L;
            }

            public BufferedSource source() {
                ZstdInputStream decompressedStream;
                try {
                    decompressedStream = new ZstdInputStream(originalBody.byteStream());
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to create ZstdInputStream", e);
                }
                Source source = Okio.source((InputStream)decompressedStream);
                return Okio.buffer((Source)source);
            }
        };
    }
}

