/*
 * Decompiled with CFR 0.152.
 */
package com.azure.xml.implementation.aalto.util;

import java.io.OutputStreamWriter;
import java.io.Writer;

public final class CharsetNames {
    public static final String CS_US_ASCII = "US-ASCII";
    public static final String CS_UTF8 = "UTF-8";
    public static final String CS_UTF16 = "UTF-16";
    public static final String CS_UTF16BE = "UTF-16BE";
    public static final String CS_UTF16LE = "UTF-16LE";
    public static final String CS_UTF32 = "UTF-32";
    public static final String CS_UTF32BE = "UTF-32BE";
    public static final String CS_UTF32LE = "UTF-32LE";
    public static final String CS_ISO_LATIN1 = "ISO-8859-1";
    public static final String CS_SHIFT_JIS = "Shift_JIS";
    public static final String CS_EBCDIC = "EBCDIC";
    private static final int EOS = 65536;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String normalize(String csName) {
        char d;
        if (csName == null || csName.length() < 3) {
            return csName;
        }
        boolean gotCsPrefix = false;
        char c = csName.charAt(0);
        if (!(c != 'c' && c != 'C' || (d = csName.charAt(1)) != 's' && d != 'S')) {
            csName = csName.substring(2);
            c = csName.charAt(0);
            gotCsPrefix = true;
        }
        switch (c) {
            case 'A': 
            case 'a': {
                if (!csName.equals("ASCII") && !CharsetNames.equalEncodings(csName, "ASCII")) return csName;
                return CS_US_ASCII;
            }
            case 'C': 
            case 'c': {
                CharsetNames.encodingStartsWith(csName, "cs");
                return csName;
            }
            case 'E': 
            case 'e': {
                if (!csName.startsWith(CS_EBCDIC) && !csName.startsWith("ebcdic")) return csName;
                return CS_EBCDIC;
            }
            case 'I': 
            case 'i': {
                if (csName.equals(CS_ISO_LATIN1) || CharsetNames.equalEncodings(csName, CS_ISO_LATIN1) || CharsetNames.equalEncodings(csName, "ISO-Latin1")) {
                    return CS_ISO_LATIN1;
                }
                if (!CharsetNames.encodingStartsWith(csName, "ISO-10646")) return csName;
                int ix = csName.indexOf("10646");
                String suffix = csName.substring(ix + 5);
                if (CharsetNames.equalEncodings(suffix, "UCS-Basic")) {
                    return CS_US_ASCII;
                }
                if (CharsetNames.equalEncodings(suffix, "Unicode-Latin1")) {
                    return CS_ISO_LATIN1;
                }
                if (CharsetNames.equalEncodings(suffix, "UCS-2")) {
                    return CS_UTF16;
                }
                if (CharsetNames.equalEncodings(suffix, "UCS-4")) {
                    return CS_UTF32;
                }
                if (CharsetNames.equalEncodings(suffix, "UTF-1")) {
                    return CS_US_ASCII;
                }
                if (CharsetNames.equalEncodings(suffix, "J-1")) {
                    return CS_US_ASCII;
                }
                if (!CharsetNames.equalEncodings(suffix, CS_US_ASCII)) return csName;
                return CS_US_ASCII;
            }
            case 'J': 
            case 'j': {
                if (!CharsetNames.equalEncodings(csName, "JIS_Encoding")) return csName;
                return CS_SHIFT_JIS;
            }
            case 'S': 
            case 's': {
                if (!CharsetNames.equalEncodings(csName, CS_SHIFT_JIS)) return csName;
                return CS_SHIFT_JIS;
            }
            case 'U': 
            case 'u': {
                if (csName.length() < 2) return csName;
                switch (csName.charAt(1)) {
                    case 'C': 
                    case 'c': {
                        if (CharsetNames.equalEncodings(csName, "UCS-2")) {
                            return CS_UTF16;
                        }
                        if (!CharsetNames.equalEncodings(csName, "UCS-4")) return csName;
                        return CS_UTF32;
                    }
                    case 'N': 
                    case 'n': {
                        if (!gotCsPrefix) return csName;
                        if (CharsetNames.equalEncodings(csName, "Unicode")) {
                            return CS_UTF16;
                        }
                        if (CharsetNames.equalEncodings(csName, "UnicodeAscii")) {
                            return CS_ISO_LATIN1;
                        }
                        if (!CharsetNames.equalEncodings(csName, "UnicodeAscii")) return csName;
                        return CS_US_ASCII;
                    }
                    case 'S': 
                    case 's': {
                        if (!CharsetNames.equalEncodings(csName, CS_US_ASCII)) return csName;
                        return CS_US_ASCII;
                    }
                    case 'T': 
                    case 't': {
                        if (csName.equals(CS_UTF8) || CharsetNames.equalEncodings(csName, CS_UTF8)) {
                            return CS_UTF8;
                        }
                        if (CharsetNames.equalEncodings(csName, CS_UTF16BE)) {
                            return CS_UTF16BE;
                        }
                        if (CharsetNames.equalEncodings(csName, CS_UTF16LE)) {
                            return CS_UTF16LE;
                        }
                        if (CharsetNames.equalEncodings(csName, CS_UTF16)) {
                            return CS_UTF16;
                        }
                        if (CharsetNames.equalEncodings(csName, CS_UTF32BE)) {
                            return CS_UTF32BE;
                        }
                        if (CharsetNames.equalEncodings(csName, CS_UTF32LE)) {
                            return CS_UTF32LE;
                        }
                        if (CharsetNames.equalEncodings(csName, CS_UTF32)) {
                            return CS_UTF32;
                        }
                        if (!CharsetNames.equalEncodings(csName, "UTF")) return csName;
                        return CS_UTF16;
                    }
                }
            }
        }
        return csName;
    }

    public static String findEncodingFor(Writer w) {
        if (w instanceof OutputStreamWriter) {
            String enc = ((OutputStreamWriter)w).getEncoding();
            return CharsetNames.normalize(enc);
        }
        return null;
    }

    public static boolean equalEncodings(String str1, String str2) {
        int len1 = str1.length();
        int len2 = str2.length();
        int i1 = 0;
        int i2 = 0;
        while (i1 < len1 || i2 < len2) {
            int c2;
            int c1 = i1 >= len1 ? 65536 : (int)str1.charAt(i1++);
            if (c1 == (c2 = i2 >= len2 ? 65536 : (int)str2.charAt(i2++))) continue;
            while (c1 <= 32 || c1 == 95 || c1 == 45) {
                c1 = i1 >= len1 ? 65536 : (int)str1.charAt(i1++);
            }
            while (c2 <= 32 || c2 == 95 || c2 == 45) {
                c2 = i2 >= len2 ? 65536 : (int)str2.charAt(i2++);
            }
            if (c1 == c2) continue;
            if (c1 == 65536 || c2 == 65536) {
                return false;
            }
            if (Character.toLowerCase((char)c1) == Character.toLowerCase((char)c2)) continue;
            return false;
        }
        return true;
    }

    public static boolean encodingStartsWith(String enc, String prefix) {
        int len1 = enc.length();
        int len2 = prefix.length();
        int i1 = 0;
        int i2 = 0;
        while (i1 < len1 || i2 < len2) {
            int c2;
            int c1 = i1 >= len1 ? 65536 : (int)enc.charAt(i1++);
            if (c1 == (c2 = i2 >= len2 ? 65536 : (int)prefix.charAt(i2++))) continue;
            while (c1 <= 32 || c1 == 95 || c1 == 45) {
                c1 = i1 >= len1 ? 65536 : (int)enc.charAt(i1++);
            }
            while (c2 <= 32 || c2 == 95 || c2 == 45) {
                c2 = i2 >= len2 ? 65536 : (int)prefix.charAt(i2++);
            }
            if (c1 == c2) continue;
            if (c2 == 65536) {
                return true;
            }
            if (c1 == 65536) {
                return false;
            }
            if (Character.toLowerCase((char)c1) == Character.toLowerCase((char)c2)) continue;
            return false;
        }
        return true;
    }
}

