/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.data.tables.implementation.ConnectionSettings;
import com.azure.data.tables.implementation.StorageAuthenticationSettings;
import com.azure.data.tables.implementation.StorageEmulatorConnectionString;
import com.azure.data.tables.implementation.StorageEndpoint;
import com.azure.data.tables.implementation.StorageServiceConnectionString;

public final class StorageConnectionString {
    private final String accountName;
    private final StorageAuthenticationSettings storageAuthSettings;
    private final StorageEndpoint blobEndpoint;
    private final StorageEndpoint fileEndpoint;
    private final StorageEndpoint queueEndpoint;
    private final StorageEndpoint tableEndpoint;

    public String getAccountName() {
        return this.accountName;
    }

    public StorageAuthenticationSettings getStorageAuthSettings() {
        return this.storageAuthSettings;
    }

    public StorageEndpoint getBlobEndpoint() {
        return this.blobEndpoint;
    }

    public StorageEndpoint getFileEndpoint() {
        return this.fileEndpoint;
    }

    public StorageEndpoint getQueueEndpoint() {
        return this.queueEndpoint;
    }

    public StorageEndpoint getTableEndpoint() {
        return this.tableEndpoint;
    }

    public static StorageConnectionString create(String connectionString, ClientLogger logger) {
        if (connectionString == null || connectionString.length() == 0) {
            throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Invalid connection string."));
        }
        ConnectionSettings settings = ConnectionSettings.fromConnectionString(connectionString, logger);
        StorageConnectionString emulatorConnString = StorageEmulatorConnectionString.tryCreate(settings, logger);
        if (emulatorConnString != null) {
            return emulatorConnString;
        }
        StorageConnectionString serviceConnString = StorageServiceConnectionString.tryCreate(settings, logger);
        if (serviceConnString != null) {
            return serviceConnString;
        }
        throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Invalid connection string."));
    }

    StorageConnectionString(StorageAuthenticationSettings storageAuthSettings, StorageEndpoint blobEndpoint, StorageEndpoint queueEndpoint, StorageEndpoint tableEndpoint, StorageEndpoint fileEndpoint, String accountName) {
        this.storageAuthSettings = storageAuthSettings;
        this.blobEndpoint = blobEndpoint;
        this.fileEndpoint = fileEndpoint;
        this.queueEndpoint = queueEndpoint;
        this.tableEndpoint = tableEndpoint;
        this.accountName = accountName;
    }
}

