/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation.models;

import com.azure.data.tables.implementation.models.TableResponseProperties;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class TableQueryResponse
implements JsonSerializable<TableQueryResponse> {
    private String odataMetadata;
    private List<TableResponseProperties> value;

    public String getOdataMetadata() {
        return this.odataMetadata;
    }

    public TableQueryResponse setOdataMetadata(String odataMetadata) {
        this.odataMetadata = odataMetadata;
        return this;
    }

    public List<TableResponseProperties> getValue() {
        return this.value;
    }

    public TableQueryResponse setValue(List<TableResponseProperties> value) {
        this.value = value;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("odata.metadata", this.odataMetadata);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static TableQueryResponse fromJson(JsonReader jsonReader) throws IOException {
        return (TableQueryResponse)jsonReader.readObject(reader -> {
            TableQueryResponse deserializedTableQueryResponse = new TableQueryResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("odata.metadata".equals(fieldName)) {
                    deserializedTableQueryResponse.odataMetadata = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedTableQueryResponse.value = value = reader.readArray(reader1 -> TableResponseProperties.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTableQueryResponse;
        });
    }
}

