/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration.implementation;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.logging.ClientLogger;
import com.azure.data.appconfiguration.models.ConfigurationAudience;
import reactor.core.publisher.Mono;

public class AudiencePolicy
implements HttpPipelinePolicy {
    private static final ClientLogger LOGGER = new ClientLogger(AudiencePolicy.class);
    private static final String NO_AUDIENCE_ERROR_MESSAGE = "Unable to authenticate to Azure App Configuration. No authentication token audience was provided. Please set an Audience in your ConfigurationClientBuilder for the target cloud. For details on how to configure the authentication token audience visit https://aka.ms/appconfig/client-token-audience.";
    private static final String INCORRECT_AUDIENCE_ERROR_MESSAGE = "Unable to authenticate to Azure App Configuration. An incorrect token audience was provided. Please set the Audience in your ConfigurationClientBuilder to the appropriate audience for this cloud. For details on how to configure the authentication token audience visit https://aka.ms/appconfig/client-token-audience.";
    private static final String AAD_AUDIENCE_ERROR_CODE = "AADSTS500011";
    private final ConfigurationAudience audience;

    public AudiencePolicy(ConfigurationAudience audience) {
        this.audience = audience;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        return next.process().onErrorMap(HttpResponseException.class, this::handleAudienceException);
    }

    public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
        try {
            return next.processSync();
        }
        catch (HttpResponseException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)this.handleAudienceException(ex)));
        }
    }

    private HttpResponseException handleAudienceException(HttpResponseException ex) {
        if (ex.getMessage() != null && ex.getMessage().contains(AAD_AUDIENCE_ERROR_CODE)) {
            String message = this.audience == null ? NO_AUDIENCE_ERROR_MESSAGE : INCORRECT_AUDIENCE_ERROR_MESSAGE;
            return new HttpResponseException(message, ex.getResponse(), (Throwable)ex);
        }
        return ex;
    }
}

