/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SecretReferenceConfigurationSetting
extends ConfigurationSetting {
    private static final ClientLogger LOGGER = new ClientLogger(SecretReferenceConfigurationSetting.class);
    private String secretId;
    private static final String SECRET_REFERENCE_CONTENT_TYPE = "application/vnd.microsoft.appconfig.keyvaultref+json;charset=utf-8";
    private boolean isValidSecretReferenceValue = true;
    private final Map<String, Object> parsedProperties = new LinkedHashMap<String, Object>(1);

    public SecretReferenceConfigurationSetting(String key, String secretId) {
        this.secretId = secretId;
        super.setKey(key);
        super.setValue("{\"uri\":\"" + secretId + "\"}");
        super.setContentType(SECRET_REFERENCE_CONTENT_TYPE);
    }

    public String getSecretId() {
        this.checkValid();
        return this.secretId;
    }

    public SecretReferenceConfigurationSetting setSecretId(String secretId) {
        this.checkValid();
        this.secretId = secretId;
        return this;
    }

    @Override
    public SecretReferenceConfigurationSetting setKey(String key) {
        super.setKey(key);
        return this;
    }

    @Override
    public String getValue() {
        String newValue = null;
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            JsonWriter writer = JsonProviders.createWriter((OutputStream)outputStream);
            boolean isUriWritten = false;
            writer.writeStartObject();
            for (Map.Entry<String, Object> entry : this.parsedProperties.entrySet()) {
                String name = entry.getKey();
                Object jsonValue = entry.getValue();
                try {
                    if ("uri".equals(name)) {
                        writer.writeStringField("uri", this.secretId);
                        isUriWritten = true;
                        continue;
                    }
                    writer.writeUntypedField(name, jsonValue);
                }
                catch (IOException e) {
                    throw LOGGER.logExceptionAsError(new RuntimeException(e));
                }
            }
            if (!isUriWritten) {
                writer.writeStringField("uri", this.secretId);
            }
            writer.writeEndObject();
            writer.flush();
            newValue = outputStream.toString(StandardCharsets.UTF_8.name());
            outputStream.close();
        }
        catch (IOException exception) {
            LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Can't parse Secret Reference configuration setting value.", exception));
        }
        super.setValue(newValue);
        return newValue;
    }

    @Override
    public SecretReferenceConfigurationSetting setValue(String value) {
        this.tryParseValue(value);
        this.isValidSecretReferenceValue = true;
        super.setValue(value);
        return this;
    }

    @Override
    public SecretReferenceConfigurationSetting setLabel(String label) {
        super.setLabel(label);
        return this;
    }

    @Override
    public SecretReferenceConfigurationSetting setContentType(String contentType) {
        super.setContentType(contentType);
        return this;
    }

    @Override
    public SecretReferenceConfigurationSetting setETag(String etag) {
        super.setETag(etag);
        return this;
    }

    @Override
    public SecretReferenceConfigurationSetting setTags(Map<String, String> tags) {
        super.setTags(tags);
        return this;
    }

    private void checkValid() {
        if (!this.isValidSecretReferenceValue) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("The content of the " + super.getValue() + " property do not represent a valid secret reference configuration setting."));
        }
    }

    private void tryParseValue(String value) {
        this.parsedProperties.clear();
        try (JsonReader jsonReader = JsonProviders.createReader((String)value);){
            jsonReader.readObject(reader -> {
                boolean isSecretIdUriValid = false;
                String secreteIdUri = this.secretId;
                while (reader.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = reader.getFieldName();
                    reader.nextToken();
                    if ("uri".equals(fieldName)) {
                        String secretIdClone;
                        secreteIdUri = secretIdClone = reader.getString();
                        this.parsedProperties.put("uri", secreteIdUri);
                        isSecretIdUriValid = true;
                        continue;
                    }
                    this.parsedProperties.put(fieldName, reader.readUntyped());
                }
                this.secretId = secreteIdUri;
                return isSecretIdUriValid;
            });
        }
        catch (IOException e) {
            this.isValidSecretReferenceValue = false;
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(e));
        }
    }
}

