/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration.implementation;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelineSyncPolicy;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.data.appconfiguration.implementation.SyncToken;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public final class SyncTokenPolicy
extends HttpPipelineSyncPolicy {
    private static final String COMMA = ",";
    private static final String EQUAL = "=";
    private static final String SYNC_TOKEN = "Sync-Token";
    private static final String SKIP_INVALID_TOKEN = "Skipping invalid sync token '{}'.";
    private final Map<String, SyncToken> syncTokenMap = new ConcurrentHashMap<String, SyncToken>();
    private final ClientLogger logger = new ClientLogger(SyncTokenPolicy.class);

    protected void beforeSendingRequest(HttpPipelineCallContext context) {
        context.getHttpRequest().setHeader(SYNC_TOKEN, this.getSyncTokenHeader());
    }

    protected HttpResponse afterReceivedResponse(HttpPipelineCallContext context, HttpResponse response) {
        if (response != null) {
            this.getUpdateSyncTokenHeaderValue(response);
        }
        return response;
    }

    private String getSyncTokenHeader() {
        return this.syncTokenMap.values().stream().map(syncToken -> syncToken.getId() + EQUAL + syncToken.getValue()).collect(Collectors.joining(COMMA));
    }

    public void updateSyncToken(String token) {
        String[] syncTokens;
        for (String syncTokenString : syncTokens = token.split(COMMA)) {
            SyncToken syncToken;
            if (CoreUtils.isNullOrEmpty((CharSequence)syncTokenString)) continue;
            try {
                syncToken = SyncToken.createSyncToken(syncTokenString);
            }
            catch (Exception ex) {
                this.logger.info(SKIP_INVALID_TOKEN, new Object[]{syncTokenString});
                continue;
            }
            String tokenId = syncToken.getId();
            this.syncTokenMap.compute(tokenId, (key, existingSyncToken) -> {
                if (existingSyncToken == null || syncToken.getSequenceNumber() > existingSyncToken.getSequenceNumber()) {
                    return syncToken;
                }
                return existingSyncToken;
            });
        }
    }

    private void getUpdateSyncTokenHeaderValue(HttpResponse httpResponse) {
        String syncTokenValue = httpResponse.getHeaders().getValue(SYNC_TOKEN);
        if (syncTokenValue != null) {
            this.updateSyncToken(syncTokenValue);
        }
    }
}

