/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.MatchConditions;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollOperationDetails;
import com.azure.core.util.polling.SyncPoller;
import com.azure.data.appconfiguration.ConfigurationClientBuilder;
import com.azure.data.appconfiguration.implementation.AzureAppConfigurationImpl;
import com.azure.data.appconfiguration.implementation.ConfigurationSettingDeserializationHelper;
import com.azure.data.appconfiguration.implementation.CreateSnapshotUtilClient;
import com.azure.data.appconfiguration.implementation.SyncTokenPolicy;
import com.azure.data.appconfiguration.implementation.Utility;
import com.azure.data.appconfiguration.implementation.models.DeleteKeyValueHeaders;
import com.azure.data.appconfiguration.implementation.models.GetKeyValueHeaders;
import com.azure.data.appconfiguration.implementation.models.GetSnapshotHeaders;
import com.azure.data.appconfiguration.implementation.models.KeyValue;
import com.azure.data.appconfiguration.implementation.models.PutKeyValueHeaders;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.ConfigurationSnapshot;
import com.azure.data.appconfiguration.models.ConfigurationSnapshotStatus;
import com.azure.data.appconfiguration.models.SettingFields;
import com.azure.data.appconfiguration.models.SettingLabel;
import com.azure.data.appconfiguration.models.SettingLabelFields;
import com.azure.data.appconfiguration.models.SettingLabelSelector;
import com.azure.data.appconfiguration.models.SettingSelector;
import com.azure.data.appconfiguration.models.SnapshotFields;
import com.azure.data.appconfiguration.models.SnapshotSelector;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

@ServiceClient(builder=ConfigurationClientBuilder.class, serviceInterfaces={AzureAppConfigurationImpl.AzureAppConfigurationService.class})
public final class ConfigurationClient {
    private static final ClientLogger LOGGER = new ClientLogger(ConfigurationClient.class);
    private final AzureAppConfigurationImpl serviceClient;
    private final SyncTokenPolicy syncTokenPolicy;
    final CreateSnapshotUtilClient createSnapshotUtilClient;

    ConfigurationClient(AzureAppConfigurationImpl serviceClient, SyncTokenPolicy syncTokenPolicy) {
        this.serviceClient = serviceClient;
        this.syncTokenPolicy = syncTokenPolicy;
        this.createSnapshotUtilClient = new CreateSnapshotUtilClient(serviceClient);
    }

    public String getEndpoint() {
        return this.serviceClient.getEndpoint();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConfigurationSetting addConfigurationSetting(String key, String label, String value) {
        return (ConfigurationSetting)this.addConfigurationSettingWithResponse(new ConfigurationSetting().setKey(key).setLabel(label).setValue(value), Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConfigurationSetting addConfigurationSetting(ConfigurationSetting setting) {
        return (ConfigurationSetting)this.addConfigurationSettingWithResponse(setting, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ConfigurationSetting> addConfigurationSettingWithResponse(ConfigurationSetting setting, Context context) {
        Utility.validateSetting(setting);
        ResponseBase<PutKeyValueHeaders, KeyValue> response = this.serviceClient.putKeyValueWithResponse(setting.getKey(), setting.getLabel(), null, "*", Utility.toKeyValue(setting), context);
        return ConfigurationSettingDeserializationHelper.toConfigurationSettingWithResponse(response);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConfigurationSetting setConfigurationSetting(String key, String label, String value) {
        return (ConfigurationSetting)this.setConfigurationSettingWithResponse(new ConfigurationSetting().setKey(key).setLabel(label).setValue(value), false, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConfigurationSetting setConfigurationSetting(ConfigurationSetting setting) {
        return (ConfigurationSetting)this.setConfigurationSettingWithResponse(setting, false, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ConfigurationSetting> setConfigurationSettingWithResponse(ConfigurationSetting setting, boolean ifUnchanged, Context context) {
        Utility.validateSetting(setting);
        ResponseBase<PutKeyValueHeaders, KeyValue> response = this.serviceClient.putKeyValueWithResponse(setting.getKey(), setting.getLabel(), Utility.getETag(ifUnchanged, setting), null, Utility.toKeyValue(setting), context);
        return ConfigurationSettingDeserializationHelper.toConfigurationSettingWithResponse(response);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConfigurationSetting getConfigurationSetting(String key, String label) {
        return this.getConfigurationSetting(key, label, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConfigurationSetting getConfigurationSetting(String key, String label, OffsetDateTime acceptDateTime) {
        return (ConfigurationSetting)this.getConfigurationSettingWithResponse(new ConfigurationSetting().setKey(key).setLabel(label), acceptDateTime, false, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConfigurationSetting getConfigurationSetting(ConfigurationSetting setting) {
        return (ConfigurationSetting)this.getConfigurationSettingWithResponse(setting, null, false, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ConfigurationSetting> getConfigurationSettingWithResponse(ConfigurationSetting setting, OffsetDateTime acceptDateTime, boolean ifChanged, Context context) {
        Utility.validateSetting(setting);
        try {
            ResponseBase<GetKeyValueHeaders, KeyValue> response = this.serviceClient.getKeyValueWithResponse(setting.getKey(), setting.getLabel(), acceptDateTime == null ? null : acceptDateTime.toString(), null, Utility.getETag(ifChanged, setting), null, context);
            return ConfigurationSettingDeserializationHelper.toConfigurationSettingWithResponse(response);
        }
        catch (HttpResponseException ex) {
            HttpResponse httpResponse = ex.getResponse();
            if (httpResponse.getStatusCode() == 304) {
                return new ResponseBase(httpResponse.getRequest(), httpResponse.getStatusCode(), httpResponse.getHeaders(), null, null);
            }
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)ex));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConfigurationSetting deleteConfigurationSetting(String key, String label) {
        return (ConfigurationSetting)this.deleteConfigurationSettingWithResponse(new ConfigurationSetting().setKey(key).setLabel(label), false, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConfigurationSetting deleteConfigurationSetting(ConfigurationSetting setting) {
        return (ConfigurationSetting)this.deleteConfigurationSettingWithResponse(setting, false, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ConfigurationSetting> deleteConfigurationSettingWithResponse(ConfigurationSetting setting, boolean ifUnchanged, Context context) {
        Utility.validateSetting(setting);
        ResponseBase<DeleteKeyValueHeaders, KeyValue> response = this.serviceClient.deleteKeyValueWithResponse(setting.getKey(), setting.getLabel(), Utility.getETag(ifUnchanged, setting), context);
        return ConfigurationSettingDeserializationHelper.toConfigurationSettingWithResponse(response);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConfigurationSetting setReadOnly(String key, String label, boolean isReadOnly) {
        return (ConfigurationSetting)this.setReadOnlyWithResponse(new ConfigurationSetting().setKey(key).setLabel(label), isReadOnly, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConfigurationSetting setReadOnly(ConfigurationSetting setting, boolean isReadOnly) {
        return (ConfigurationSetting)this.setReadOnlyWithResponse(setting, isReadOnly, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ConfigurationSetting> setReadOnlyWithResponse(ConfigurationSetting setting, boolean isReadOnly, Context context) {
        Utility.validateSetting(setting);
        String key = setting.getKey();
        String label = setting.getLabel();
        return isReadOnly ? ConfigurationSettingDeserializationHelper.toConfigurationSettingWithResponse(this.serviceClient.putLockWithResponse(key, label, null, null, context)) : ConfigurationSettingDeserializationHelper.toConfigurationSettingWithResponse(this.serviceClient.deleteLockWithResponse(key, label, null, null, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ConfigurationSetting> listConfigurationSettings(SettingSelector selector) {
        return this.listConfigurationSettings(selector, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ConfigurationSetting> listConfigurationSettings(SettingSelector selector, Context context) {
        String keyFilter = selector == null ? null : selector.getKeyFilter();
        String labelFilter = selector == null ? null : selector.getLabelFilter();
        String acceptDateTime = selector == null ? null : selector.getAcceptDateTime();
        List<SettingFields> settingFields = selector == null ? null : Utility.toSettingFieldsList(selector.getFields());
        List<MatchConditions> matchConditionsList = selector == null ? null : selector.getMatchConditions();
        List<String> tagsFilter = selector == null ? null : selector.getTagsFilter();
        AtomicInteger pageETagIndex = new AtomicInteger(0);
        return new PagedIterable(() -> {
            PagedResponse<KeyValue> pagedResponse;
            try {
                pagedResponse = this.serviceClient.getKeyValuesSinglePage(keyFilter, labelFilter, null, acceptDateTime, settingFields, null, null, Utility.getPageETag(matchConditionsList, pageETagIndex), tagsFilter, context);
            }
            catch (HttpResponseException ex) {
                return Utility.handleNotModifiedErrorToValidResponse(ex, LOGGER);
            }
            return ConfigurationSettingDeserializationHelper.toConfigurationSettingWithPagedResponse(pagedResponse);
        }, nextLink -> {
            PagedResponse<KeyValue> pagedResponse;
            try {
                pagedResponse = this.serviceClient.getKeyValuesNextSinglePage((String)nextLink, acceptDateTime, null, Utility.getPageETag(matchConditionsList, pageETagIndex), context);
            }
            catch (HttpResponseException ex) {
                return Utility.handleNotModifiedErrorToValidResponse(ex, LOGGER);
            }
            return ConfigurationSettingDeserializationHelper.toConfigurationSettingWithPagedResponse(pagedResponse);
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ConfigurationSetting> listConfigurationSettingsForSnapshot(String snapshotName) {
        return this.listConfigurationSettingsForSnapshot(snapshotName, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ConfigurationSetting> listConfigurationSettingsForSnapshot(String snapshotName, List<SettingFields> fields, Context context) {
        return new PagedIterable(() -> {
            PagedResponse<KeyValue> pagedResponse = this.serviceClient.getKeyValuesSinglePage(null, null, null, null, fields, snapshotName, null, null, null, context);
            return ConfigurationSettingDeserializationHelper.toConfigurationSettingWithPagedResponse(pagedResponse);
        }, nextLink -> {
            PagedResponse<KeyValue> pagedResponse = this.serviceClient.getKeyValuesNextSinglePage((String)nextLink, null, null, null, context);
            return ConfigurationSettingDeserializationHelper.toConfigurationSettingWithPagedResponse(pagedResponse);
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ConfigurationSetting> listRevisions(SettingSelector selector) {
        return this.listRevisions(selector, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ConfigurationSetting> listRevisions(SettingSelector selector, Context context) {
        String acceptDateTime = selector == null ? null : selector.getAcceptDateTime();
        return new PagedIterable(() -> {
            PagedResponse<KeyValue> pagedResponse = this.serviceClient.getRevisionsSinglePage(selector == null ? null : selector.getKeyFilter(), selector == null ? null : selector.getLabelFilter(), null, acceptDateTime, selector == null ? null : Utility.toSettingFieldsList(selector.getFields()), selector == null ? null : selector.getTagsFilter(), context);
            return ConfigurationSettingDeserializationHelper.toConfigurationSettingWithPagedResponse(pagedResponse);
        }, nextLink -> {
            PagedResponse<KeyValue> pagedResponse = this.serviceClient.getRevisionsNextSinglePage((String)nextLink, acceptDateTime, context);
            return ConfigurationSettingDeserializationHelper.toConfigurationSettingWithPagedResponse(pagedResponse);
        });
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollOperationDetails, ConfigurationSnapshot> beginCreateSnapshot(String snapshotName, ConfigurationSnapshot snapshot, Context context) {
        return this.createSnapshotUtilClient.beginCreateSnapshot(snapshotName, snapshot, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConfigurationSnapshot getSnapshot(String snapshotName) {
        return (ConfigurationSnapshot)this.getSnapshotWithResponse(snapshotName, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ConfigurationSnapshot> getSnapshotWithResponse(String snapshotName, List<SnapshotFields> fields, Context context) {
        ResponseBase<GetSnapshotHeaders, ConfigurationSnapshot> response = this.serviceClient.getSnapshotWithResponse(snapshotName, null, null, fields, context);
        return new SimpleResponse(response, (Object)((ConfigurationSnapshot)response.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConfigurationSnapshot archiveSnapshot(String snapshotName) {
        return (ConfigurationSnapshot)Utility.updateSnapshotSync(snapshotName, null, ConfigurationSnapshotStatus.ARCHIVED, this.serviceClient, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ConfigurationSnapshot> archiveSnapshotWithResponse(String snapshotName, MatchConditions matchConditions, Context context) {
        return Utility.updateSnapshotSync(snapshotName, matchConditions, ConfigurationSnapshotStatus.ARCHIVED, this.serviceClient, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConfigurationSnapshot recoverSnapshot(String snapshotName) {
        return (ConfigurationSnapshot)Utility.updateSnapshotSync(snapshotName, null, ConfigurationSnapshotStatus.READY, this.serviceClient, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ConfigurationSnapshot> recoverSnapshotWithResponse(String snapshotName, MatchConditions matchConditions, Context context) {
        return Utility.updateSnapshotSync(snapshotName, matchConditions, ConfigurationSnapshotStatus.READY, this.serviceClient, context);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ConfigurationSnapshot> listSnapshots(SnapshotSelector selector) {
        return this.listSnapshots(selector, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ConfigurationSnapshot> listSnapshots(SnapshotSelector selector, Context context) {
        return new PagedIterable(() -> this.serviceClient.getSnapshotsSinglePage(selector == null ? null : selector.getNameFilter(), null, selector == null ? null : selector.getFields(), selector == null ? null : selector.getStatus(), context), nextLink -> this.serviceClient.getSnapshotsNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SettingLabel> listLabels() {
        return this.listLabels(null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SettingLabel> listLabels(SettingLabelSelector selector) {
        return this.listLabels(selector, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SettingLabel> listLabels(SettingLabelSelector selector, Context context) {
        String labelNameFilter;
        String string = labelNameFilter = selector == null ? null : selector.getNameFilter();
        String acceptDatetime = selector == null ? null : (selector.getAcceptDateTime() == null ? null : selector.getAcceptDateTime().toString());
        List<SettingLabelFields> labelFields = selector == null ? null : selector.getFields();
        return this.serviceClient.getLabels(labelNameFilter, null, acceptDatetime, labelFields, context);
    }

    public void updateSyncToken(String token) {
        this.syncTokenPolicy.updateSyncToken(token);
    }
}

