/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.DescribedNode;
import lombok.ast.Expression;
import lombok.ast.ExpressionMixin;
import lombok.ast.Node;
import lombok.ast.Position;
import lombok.ast.UnaryExpressionTemplate;
import lombok.ast.UnaryOperator;

public class UnaryExpression
extends AbstractNode
implements Expression,
DescribedNode {
    private List<Position> parensPositions = new ArrayList<Position>();
    private UnaryOperator operator = null;
    private AbstractNode operand = null;

    @Override
    public List<Position> astParensPositions() {
        return this.parensPositions;
    }

    public UnaryOperator astOperator() {
        return this.operator;
    }

    public UnaryExpression astOperator(UnaryOperator operator) {
        if (operator == null) {
            throw new NullPointerException("operator is mandatory");
        }
        this.operator = operator;
        return this;
    }

    public Expression astOperand() {
        if (!(this.operand instanceof Expression)) {
            return null;
        }
        return (Expression)((Object)this.operand);
    }

    public UnaryExpression astOperand(Expression operand) {
        if (operand == null) {
            throw new NullPointerException("operand is mandatory");
        }
        return this.rawOperand(operand);
    }

    public Node rawOperand() {
        return this.operand;
    }

    public UnaryExpression rawOperand(Node operand) {
        if (operand == this.operand) {
            return this;
        }
        if (operand != null) {
            this.adopt((AbstractNode)operand);
        }
        if (this.operand != null) {
            this.disown(this.operand);
        }
        this.operand = (AbstractNode)operand;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.operand != null) {
            result.add(this.operand);
        }
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.operand == original) {
            this.rawOperand(replacement);
            return true;
        }
        return false;
    }

    @Override
    public boolean detach(Node child) {
        if (this.operand == child) {
            this.disown((AbstractNode)child);
            this.operand = null;
            return true;
        }
        return false;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitUnaryExpression(this)) {
            return;
        }
        if (this.operand != null) {
            this.operand.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public UnaryExpression copy() {
        UnaryExpression result = new UnaryExpression();
        result.parensPositions = new ArrayList<Position>(this.parensPositions);
        result.operator = this.operator;
        if (this.operand != null) {
            result.rawOperand(this.operand.copy());
        }
        return result;
    }

    @Override
    public String getDescription() {
        return UnaryExpressionTemplate.getDescription(this);
    }

    @Override
    public boolean needsParentheses() {
        return UnaryExpressionTemplate.needsParentheses(this);
    }

    @Override
    public int getParens() {
        return ExpressionMixin.getParens(this);
    }

    @Override
    public int getIntendedParens() {
        return ExpressionMixin.getIntendedParens(this);
    }

    @Override
    public boolean isStatementExpression() {
        return ExpressionMixin.isStatementExpression(this);
    }
}

