/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.internal.BuildConfigImpl;
import com.android.builder.model.ProductFlavor;
import com.android.builder.signing.SigningConfig;
import com.google.common.base.Objects;

public class DefaultProductFlavor
extends BuildConfigImpl
implements ProductFlavor {
    private static final long serialVersionUID = 1L;
    private final String mName;
    private int mMinSdkVersion = -1;
    private int mTargetSdkVersion = -1;
    private int mRenderscriptTargetApi = -1;
    private int mVersionCode = -1;
    private String mVersionName = null;
    private String mPackageName = null;
    private String mTestPackageName = null;
    private String mTestInstrumentationRunner = null;
    private SigningConfig mSigningConfig = null;

    public DefaultProductFlavor(@NonNull String name) {
        this.mName = name;
    }

    @NonNull
    public String getName() {
        return this.mName;
    }

    @NonNull
    public ProductFlavor setPackageName(String packageName) {
        this.mPackageName = packageName;
        return this;
    }

    @Nullable
    public String getPackageName() {
        return this.mPackageName;
    }

    @NonNull
    public ProductFlavor setVersionCode(int versionCode) {
        this.mVersionCode = versionCode;
        return this;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @NonNull
    public ProductFlavor setVersionName(String versionName) {
        this.mVersionName = versionName;
        return this;
    }

    @Nullable
    public String getVersionName() {
        return this.mVersionName;
    }

    @NonNull
    public ProductFlavor setMinSdkVersion(int minSdkVersion) {
        this.mMinSdkVersion = minSdkVersion;
        return this;
    }

    public int getMinSdkVersion() {
        return this.mMinSdkVersion;
    }

    @NonNull
    public ProductFlavor setTargetSdkVersion(int targetSdkVersion) {
        this.mTargetSdkVersion = targetSdkVersion;
        return this;
    }

    public int getTargetSdkVersion() {
        return this.mTargetSdkVersion;
    }

    public int getRenderscriptTargetApi() {
        return this.mRenderscriptTargetApi;
    }

    public void setRenderscriptTargetApi(int renderscriptTargetApi) {
        this.mRenderscriptTargetApi = renderscriptTargetApi;
    }

    @NonNull
    public ProductFlavor setTestPackageName(String testPackageName) {
        this.mTestPackageName = testPackageName;
        return this;
    }

    @Nullable
    public String getTestPackageName() {
        return this.mTestPackageName;
    }

    @NonNull
    public ProductFlavor setTestInstrumentationRunner(String testInstrumentationRunner) {
        this.mTestInstrumentationRunner = testInstrumentationRunner;
        return this;
    }

    @Nullable
    public String getTestInstrumentationRunner() {
        return this.mTestInstrumentationRunner;
    }

    @Nullable
    public SigningConfig getSigningConfig() {
        return this.mSigningConfig;
    }

    @NonNull
    public ProductFlavor setSigningConfig(SigningConfig signingConfig) {
        this.mSigningConfig = signingConfig;
        return this;
    }

    @NonNull
    DefaultProductFlavor mergeOver(@NonNull DefaultProductFlavor base) {
        DefaultProductFlavor flavor = new DefaultProductFlavor("");
        flavor.mMinSdkVersion = this.chooseInt(this.mMinSdkVersion, base.mMinSdkVersion);
        flavor.mTargetSdkVersion = this.chooseInt(this.mTargetSdkVersion, base.mTargetSdkVersion);
        flavor.mRenderscriptTargetApi = this.chooseInt(this.mRenderscriptTargetApi, base.mRenderscriptTargetApi);
        flavor.mVersionCode = this.chooseInt(this.mVersionCode, base.mVersionCode);
        flavor.mVersionName = this.chooseString(this.mVersionName, base.mVersionName);
        flavor.mPackageName = this.chooseString(this.mPackageName, base.mPackageName);
        flavor.mTestPackageName = this.chooseString(this.mTestPackageName, base.mTestPackageName);
        flavor.mTestInstrumentationRunner = this.chooseString(this.mTestInstrumentationRunner, base.mTestInstrumentationRunner);
        flavor.mSigningConfig = this.mSigningConfig != null ? this.mSigningConfig : base.mSigningConfig;
        return flavor;
    }

    private int chooseInt(int overlay, int base) {
        return overlay != -1 ? overlay : base;
    }

    @Nullable
    private String chooseString(String overlay, String base) {
        return overlay != null ? overlay : base;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultProductFlavor that = (DefaultProductFlavor)o;
        if (!this.mName.equals(that.mName)) {
            return false;
        }
        if (this.mMinSdkVersion != that.mMinSdkVersion) {
            return false;
        }
        if (this.mTargetSdkVersion != that.mTargetSdkVersion) {
            return false;
        }
        if (this.mRenderscriptTargetApi != that.mRenderscriptTargetApi) {
            return false;
        }
        if (this.mVersionCode != that.mVersionCode) {
            return false;
        }
        if (this.mPackageName != null ? !this.mPackageName.equals(that.mPackageName) : that.mPackageName != null) {
            return false;
        }
        if (this.mTestInstrumentationRunner != null ? !this.mTestInstrumentationRunner.equals(that.mTestInstrumentationRunner) : that.mTestInstrumentationRunner != null) {
            return false;
        }
        if (this.mTestPackageName != null ? !this.mTestPackageName.equals(that.mTestPackageName) : that.mTestPackageName != null) {
            return false;
        }
        if (this.mVersionName != null ? !this.mVersionName.equals(that.mVersionName) : that.mVersionName != null) {
            return false;
        }
        return !(this.mSigningConfig != null ? !this.mSigningConfig.equals(that.mSigningConfig) : that.mSigningConfig != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.mName.hashCode();
        result = 31 * result + this.mMinSdkVersion;
        result = 31 * result + this.mTargetSdkVersion;
        result = 31 * result + this.mRenderscriptTargetApi;
        result = 31 * result + this.mVersionCode;
        result = 31 * result + (this.mVersionName != null ? this.mVersionName.hashCode() : 0);
        result = 31 * result + (this.mPackageName != null ? this.mPackageName.hashCode() : 0);
        result = 31 * result + (this.mTestPackageName != null ? this.mTestPackageName.hashCode() : 0);
        result = 31 * result + (this.mTestInstrumentationRunner != null ? this.mTestInstrumentationRunner.hashCode() : 0);
        result = 31 * result + (this.mSigningConfig != null ? this.mSigningConfig.hashCode() : 0);
        return result;
    }

    @NonNull
    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.mName).add("minSdkVersion", this.mMinSdkVersion).add("targetSdkVersion", this.mTargetSdkVersion).add("renderscriptTargetApi", this.mRenderscriptTargetApi).add("versionCode", this.mVersionCode).add("versionName", (Object)this.mVersionName).add("packageName", (Object)this.mPackageName).add("testPackageName", (Object)this.mTestPackageName).add("testInstrumentationRunner", (Object)this.mTestInstrumentationRunner).add("signingConfig", (Object)this.mSigningConfig).toString();
    }
}

