/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.worker.DecisionId;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionState;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionStateMachineBase;
import com.amazonaws.services.simpleworkflow.model.Decision;
import com.amazonaws.services.simpleworkflow.model.DecisionType;
import com.amazonaws.services.simpleworkflow.model.HistoryEvent;
import com.amazonaws.services.simpleworkflow.model.RequestCancelActivityTaskDecisionAttributes;
import com.amazonaws.services.simpleworkflow.model.ScheduleActivityTaskDecisionAttributes;

class ActivityDecisionStateMachine
extends DecisionStateMachineBase {
    private ScheduleActivityTaskDecisionAttributes scheduleAttributes;

    public ActivityDecisionStateMachine(DecisionId id, ScheduleActivityTaskDecisionAttributes scheduleAttributes) {
        super(id);
        this.scheduleAttributes = scheduleAttributes;
    }

    ActivityDecisionStateMachine(DecisionId id, ScheduleActivityTaskDecisionAttributes scheduleAttributes, DecisionState state) {
        super(id, state);
        this.scheduleAttributes = scheduleAttributes;
    }

    public Decision getDecision() {
        switch (this.state) {
            case CREATED: {
                return this.createScheduleActivityTaskDecision();
            }
            case CANCELED_AFTER_INITIATED: {
                return this.createRequestCancelActivityTaskDecision();
            }
        }
        return null;
    }

    public void handleDecisionTaskStartedEvent() {
        switch (this.state) {
            case CANCELED_AFTER_INITIATED: {
                this.stateHistory.add("handleDecisionTaskStartedEvent");
                this.state = DecisionState.CANCELLATION_DECISION_SENT;
                this.stateHistory.add(this.state.toString());
                break;
            }
            default: {
                super.handleDecisionTaskStartedEvent();
            }
        }
    }

    public void handleCancellationFailureEvent(HistoryEvent event) {
        switch (this.state) {
            case CANCELLATION_DECISION_SENT: {
                this.stateHistory.add("handleCancellationFailureEvent");
                this.state = DecisionState.INITIATED;
                this.stateHistory.add(this.state.toString());
                break;
            }
            default: {
                super.handleCancellationFailureEvent(event);
            }
        }
    }

    private Decision createRequestCancelActivityTaskDecision() {
        RequestCancelActivityTaskDecisionAttributes tryCancel = new RequestCancelActivityTaskDecisionAttributes();
        tryCancel.setActivityId(this.scheduleAttributes.getActivityId());
        Decision decision = new Decision();
        decision.setRequestCancelActivityTaskDecisionAttributes(tryCancel);
        decision.setDecisionType(DecisionType.RequestCancelActivityTask.toString());
        return decision;
    }

    private Decision createScheduleActivityTaskDecision() {
        Decision decision = new Decision();
        decision.setScheduleActivityTaskDecisionAttributes(this.scheduleAttributes);
        decision.setDecisionType(DecisionType.ScheduleActivityTask.toString());
        return decision;
    }
}

