/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddInstanceGroupsRequest
extends AmazonWebServiceRequest
implements Serializable {
    private List<InstanceGroupConfig> instanceGroups;
    private String jobFlowId;

    public AddInstanceGroupsRequest() {
    }

    public AddInstanceGroupsRequest(List<InstanceGroupConfig> instanceGroups, String jobFlowId) {
        this.instanceGroups = instanceGroups;
        this.jobFlowId = jobFlowId;
    }

    public List<InstanceGroupConfig> getInstanceGroups() {
        if (this.instanceGroups == null) {
            this.instanceGroups = new ArrayList<InstanceGroupConfig>();
        }
        return this.instanceGroups;
    }

    public void setInstanceGroups(Collection<InstanceGroupConfig> instanceGroups) {
        if (instanceGroups == null) {
            this.instanceGroups = null;
            return;
        }
        ArrayList<InstanceGroupConfig> instanceGroupsCopy = new ArrayList<InstanceGroupConfig>(instanceGroups.size());
        instanceGroupsCopy.addAll(instanceGroups);
        this.instanceGroups = instanceGroupsCopy;
    }

    public AddInstanceGroupsRequest withInstanceGroups(InstanceGroupConfig ... instanceGroups) {
        if (this.getInstanceGroups() == null) {
            this.setInstanceGroups(new ArrayList<InstanceGroupConfig>(instanceGroups.length));
        }
        for (InstanceGroupConfig value : instanceGroups) {
            this.getInstanceGroups().add(value);
        }
        return this;
    }

    public AddInstanceGroupsRequest withInstanceGroups(Collection<InstanceGroupConfig> instanceGroups) {
        if (instanceGroups == null) {
            this.instanceGroups = null;
        } else {
            ArrayList<InstanceGroupConfig> instanceGroupsCopy = new ArrayList<InstanceGroupConfig>(instanceGroups.size());
            instanceGroupsCopy.addAll(instanceGroups);
            this.instanceGroups = instanceGroupsCopy;
        }
        return this;
    }

    public String getJobFlowId() {
        return this.jobFlowId;
    }

    public void setJobFlowId(String jobFlowId) {
        this.jobFlowId = jobFlowId;
    }

    public AddInstanceGroupsRequest withJobFlowId(String jobFlowId) {
        this.jobFlowId = jobFlowId;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceGroups() != null) {
            sb.append("InstanceGroups: " + this.getInstanceGroups() + ",");
        }
        if (this.getJobFlowId() != null) {
            sb.append("JobFlowId: " + this.getJobFlowId());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceGroups() == null ? 0 : ((Object)this.getInstanceGroups()).hashCode());
        hashCode = 31 * hashCode + (this.getJobFlowId() == null ? 0 : this.getJobFlowId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddInstanceGroupsRequest)) {
            return false;
        }
        AddInstanceGroupsRequest other = (AddInstanceGroupsRequest)obj;
        if (other.getInstanceGroups() == null ^ this.getInstanceGroups() == null) {
            return false;
        }
        if (other.getInstanceGroups() != null && !((Object)other.getInstanceGroups()).equals(this.getInstanceGroups())) {
            return false;
        }
        if (other.getJobFlowId() == null ^ this.getJobFlowId() == null) {
            return false;
        }
        return other.getJobFlowId() == null || other.getJobFlowId().equals(this.getJobFlowId());
    }
}

