/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.services.ec2.model.NetworkAclAssociation;
import com.amazonaws.services.ec2.model.NetworkAclEntry;
import com.amazonaws.services.ec2.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkAcl
implements Serializable {
    private String networkAclId;
    private String vpcId;
    private Boolean isDefault;
    private List<NetworkAclEntry> entries;
    private List<NetworkAclAssociation> associations;
    private List<Tag> tags;

    public String getNetworkAclId() {
        return this.networkAclId;
    }

    public void setNetworkAclId(String networkAclId) {
        this.networkAclId = networkAclId;
    }

    public NetworkAcl withNetworkAclId(String networkAclId) {
        this.networkAclId = networkAclId;
        return this;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public NetworkAcl withVpcId(String vpcId) {
        this.vpcId = vpcId;
        return this;
    }

    public Boolean isDefault() {
        return this.isDefault;
    }

    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public NetworkAcl withIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public List<NetworkAclEntry> getEntries() {
        if (this.entries == null) {
            this.entries = new ArrayList<NetworkAclEntry>();
        }
        return this.entries;
    }

    public void setEntries(Collection<NetworkAclEntry> entries) {
        if (entries == null) {
            this.entries = null;
            return;
        }
        ArrayList<NetworkAclEntry> entriesCopy = new ArrayList<NetworkAclEntry>(entries.size());
        entriesCopy.addAll(entries);
        this.entries = entriesCopy;
    }

    public NetworkAcl withEntries(NetworkAclEntry ... entries) {
        if (this.getEntries() == null) {
            this.setEntries(new ArrayList<NetworkAclEntry>(entries.length));
        }
        for (NetworkAclEntry value : entries) {
            this.getEntries().add(value);
        }
        return this;
    }

    public NetworkAcl withEntries(Collection<NetworkAclEntry> entries) {
        if (entries == null) {
            this.entries = null;
        } else {
            ArrayList<NetworkAclEntry> entriesCopy = new ArrayList<NetworkAclEntry>(entries.size());
            entriesCopy.addAll(entries);
            this.entries = entriesCopy;
        }
        return this;
    }

    public List<NetworkAclAssociation> getAssociations() {
        if (this.associations == null) {
            this.associations = new ArrayList<NetworkAclAssociation>();
        }
        return this.associations;
    }

    public void setAssociations(Collection<NetworkAclAssociation> associations) {
        if (associations == null) {
            this.associations = null;
            return;
        }
        ArrayList<NetworkAclAssociation> associationsCopy = new ArrayList<NetworkAclAssociation>(associations.size());
        associationsCopy.addAll(associations);
        this.associations = associationsCopy;
    }

    public NetworkAcl withAssociations(NetworkAclAssociation ... associations) {
        if (this.getAssociations() == null) {
            this.setAssociations(new ArrayList<NetworkAclAssociation>(associations.length));
        }
        for (NetworkAclAssociation value : associations) {
            this.getAssociations().add(value);
        }
        return this;
    }

    public NetworkAcl withAssociations(Collection<NetworkAclAssociation> associations) {
        if (associations == null) {
            this.associations = null;
        } else {
            ArrayList<NetworkAclAssociation> associationsCopy = new ArrayList<NetworkAclAssociation>(associations.size());
            associationsCopy.addAll(associations);
            this.associations = associationsCopy;
        }
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ArrayList<Tag> tagsCopy = new ArrayList<Tag>(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public NetworkAcl withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public NetworkAcl withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ArrayList<Tag> tagsCopy = new ArrayList<Tag>(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNetworkAclId() != null) {
            sb.append("NetworkAclId: " + this.getNetworkAclId() + ",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: " + this.getVpcId() + ",");
        }
        if (this.isDefault() != null) {
            sb.append("IsDefault: " + this.isDefault() + ",");
        }
        if (this.getEntries() != null) {
            sb.append("Entries: " + this.getEntries() + ",");
        }
        if (this.getAssociations() != null) {
            sb.append("Associations: " + this.getAssociations() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNetworkAclId() == null ? 0 : this.getNetworkAclId().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.isDefault() == null ? 0 : this.isDefault().hashCode());
        hashCode = 31 * hashCode + (this.getEntries() == null ? 0 : ((Object)this.getEntries()).hashCode());
        hashCode = 31 * hashCode + (this.getAssociations() == null ? 0 : ((Object)this.getAssociations()).hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : ((Object)this.getTags()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkAcl)) {
            return false;
        }
        NetworkAcl other = (NetworkAcl)obj;
        if (other.getNetworkAclId() == null ^ this.getNetworkAclId() == null) {
            return false;
        }
        if (other.getNetworkAclId() != null && !other.getNetworkAclId().equals(this.getNetworkAclId())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.isDefault() == null ^ this.isDefault() == null) {
            return false;
        }
        if (other.isDefault() != null && !other.isDefault().equals(this.isDefault())) {
            return false;
        }
        if (other.getEntries() == null ^ this.getEntries() == null) {
            return false;
        }
        if (other.getEntries() != null && !((Object)other.getEntries()).equals(this.getEntries())) {
            return false;
        }
        if (other.getAssociations() == null ^ this.getAssociations() == null) {
            return false;
        }
        if (other.getAssociations() != null && !((Object)other.getAssociations()).equals(this.getAssociations())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || ((Object)other.getTags()).equals(this.getTags());
    }
}

