/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchGetItemRequestMarshaller
implements Marshaller<Request<BatchGetItemRequest>, BatchGetItemRequest> {
    @Override
    public Request<BatchGetItemRequest> marshall(BatchGetItemRequest batchGetItemRequest) {
        if (batchGetItemRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<BatchGetItemRequest> request = new DefaultRequest<BatchGetItemRequest>(batchGetItemRequest, "AmazonDynamoDBv2");
        String target = "DynamoDB_20120810.BatchGetItem";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "";
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (batchGetItemRequest.getRequestItems() != null) {
                jsonWriter.key("RequestItems");
                jsonWriter.object();
                for (Map.Entry<String, KeysAndAttributes> requestItemsListValue : batchGetItemRequest.getRequestItems().entrySet()) {
                    List<String> attributesToGetList;
                    if (requestItemsListValue.getValue() == null) continue;
                    jsonWriter.key(requestItemsListValue.getKey());
                    jsonWriter.object();
                    List<Map<String, AttributeValue>> keysList = requestItemsListValue.getValue().getKeys();
                    if (keysList != null && keysList.size() > 0) {
                        jsonWriter.key("Keys");
                        jsonWriter.array();
                        for (Map<String, AttributeValue> keysListValue : keysList) {
                            if (keysListValue == null) continue;
                            jsonWriter.object();
                            for (Map.Entry<String, AttributeValue> memberListValue : keysListValue.entrySet()) {
                                List<ByteBuffer> bSList;
                                List<String> nSList;
                                List<String> sSList;
                                if (memberListValue.getValue() == null) continue;
                                jsonWriter.key(memberListValue.getKey());
                                jsonWriter.object();
                                if (memberListValue.getValue().getS() != null) {
                                    jsonWriter.key("S").value(memberListValue.getValue().getS());
                                }
                                if (memberListValue.getValue().getN() != null) {
                                    jsonWriter.key("N").value(memberListValue.getValue().getN());
                                }
                                if (memberListValue.getValue().getB() != null) {
                                    jsonWriter.key("B").value(memberListValue.getValue().getB());
                                }
                                if ((sSList = memberListValue.getValue().getSS()) != null && sSList.size() > 0) {
                                    jsonWriter.key("SS");
                                    jsonWriter.array();
                                    for (String sSListValue : sSList) {
                                        if (sSListValue == null) continue;
                                        jsonWriter.value(sSListValue);
                                    }
                                    jsonWriter.endArray();
                                }
                                if ((nSList = memberListValue.getValue().getNS()) != null && nSList.size() > 0) {
                                    jsonWriter.key("NS");
                                    jsonWriter.array();
                                    for (String nSListValue : nSList) {
                                        if (nSListValue == null) continue;
                                        jsonWriter.value(nSListValue);
                                    }
                                    jsonWriter.endArray();
                                }
                                if ((bSList = memberListValue.getValue().getBS()) != null && bSList.size() > 0) {
                                    jsonWriter.key("BS");
                                    jsonWriter.array();
                                    for (ByteBuffer bSListValue : bSList) {
                                        if (bSListValue == null) continue;
                                        jsonWriter.value(bSListValue);
                                    }
                                    jsonWriter.endArray();
                                }
                                jsonWriter.endObject();
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    if ((attributesToGetList = requestItemsListValue.getValue().getAttributesToGet()) != null && attributesToGetList.size() > 0) {
                        jsonWriter.key("AttributesToGet");
                        jsonWriter.array();
                        for (String attributesToGetListValue : attributesToGetList) {
                            if (attributesToGetListValue == null) continue;
                            jsonWriter.value(attributesToGetListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if (requestItemsListValue.getValue().isConsistentRead() != null) {
                        jsonWriter.key("ConsistentRead").value(requestItemsListValue.getValue().isConsistentRead());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (batchGetItemRequest.getReturnConsumedCapacity() != null) {
                jsonWriter.key("ReturnConsumedCapacity").value(batchGetItemRequest.getReturnConsumedCapacity());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

