/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemCollectionMetrics
implements Serializable {
    private Map<String, AttributeValue> itemCollectionKey;
    private List<Double> sizeEstimateRangeGB;

    public Map<String, AttributeValue> getItemCollectionKey() {
        return this.itemCollectionKey;
    }

    public void setItemCollectionKey(Map<String, AttributeValue> itemCollectionKey) {
        this.itemCollectionKey = itemCollectionKey;
    }

    public ItemCollectionMetrics withItemCollectionKey(Map<String, AttributeValue> itemCollectionKey) {
        this.setItemCollectionKey(itemCollectionKey);
        return this;
    }

    public List<Double> getSizeEstimateRangeGB() {
        return this.sizeEstimateRangeGB;
    }

    public void setSizeEstimateRangeGB(Collection<Double> sizeEstimateRangeGB) {
        if (sizeEstimateRangeGB == null) {
            this.sizeEstimateRangeGB = null;
            return;
        }
        ArrayList<Double> sizeEstimateRangeGBCopy = new ArrayList<Double>(sizeEstimateRangeGB.size());
        sizeEstimateRangeGBCopy.addAll(sizeEstimateRangeGB);
        this.sizeEstimateRangeGB = sizeEstimateRangeGBCopy;
    }

    public ItemCollectionMetrics withSizeEstimateRangeGB(Double ... sizeEstimateRangeGB) {
        if (this.getSizeEstimateRangeGB() == null) {
            this.setSizeEstimateRangeGB(new ArrayList<Double>(sizeEstimateRangeGB.length));
        }
        for (Double value : sizeEstimateRangeGB) {
            this.getSizeEstimateRangeGB().add(value);
        }
        return this;
    }

    public ItemCollectionMetrics withSizeEstimateRangeGB(Collection<Double> sizeEstimateRangeGB) {
        if (sizeEstimateRangeGB == null) {
            this.sizeEstimateRangeGB = null;
        } else {
            ArrayList<Double> sizeEstimateRangeGBCopy = new ArrayList<Double>(sizeEstimateRangeGB.size());
            sizeEstimateRangeGBCopy.addAll(sizeEstimateRangeGB);
            this.sizeEstimateRangeGB = sizeEstimateRangeGBCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getItemCollectionKey() != null) {
            sb.append("ItemCollectionKey: " + this.getItemCollectionKey() + ",");
        }
        if (this.getSizeEstimateRangeGB() != null) {
            sb.append("SizeEstimateRangeGB: " + this.getSizeEstimateRangeGB());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getItemCollectionKey() == null ? 0 : ((Object)this.getItemCollectionKey()).hashCode());
        hashCode = 31 * hashCode + (this.getSizeEstimateRangeGB() == null ? 0 : ((Object)this.getSizeEstimateRangeGB()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ItemCollectionMetrics)) {
            return false;
        }
        ItemCollectionMetrics other = (ItemCollectionMetrics)obj;
        if (other.getItemCollectionKey() == null ^ this.getItemCollectionKey() == null) {
            return false;
        }
        if (other.getItemCollectionKey() != null && !((Object)other.getItemCollectionKey()).equals(this.getItemCollectionKey())) {
            return false;
        }
        if (other.getSizeEstimateRangeGB() == null ^ this.getSizeEstimateRangeGB() == null) {
            return false;
        }
        return other.getSizeEstimateRangeGB() == null || ((Object)other.getSizeEstimateRangeGB()).equals(this.getSizeEstimateRangeGB());
    }
}

