/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflowAsync;
import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflowAsyncClientBuilder;
import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflowClient;
import com.amazonaws.services.simpleworkflow.model.ActivityTask;
import com.amazonaws.services.simpleworkflow.model.ActivityTaskStatus;
import com.amazonaws.services.simpleworkflow.model.ActivityTypeDetail;
import com.amazonaws.services.simpleworkflow.model.ActivityTypeInfos;
import com.amazonaws.services.simpleworkflow.model.CountClosedWorkflowExecutionsRequest;
import com.amazonaws.services.simpleworkflow.model.CountOpenWorkflowExecutionsRequest;
import com.amazonaws.services.simpleworkflow.model.CountPendingActivityTasksRequest;
import com.amazonaws.services.simpleworkflow.model.CountPendingDecisionTasksRequest;
import com.amazonaws.services.simpleworkflow.model.DecisionTask;
import com.amazonaws.services.simpleworkflow.model.DeprecateActivityTypeRequest;
import com.amazonaws.services.simpleworkflow.model.DeprecateDomainRequest;
import com.amazonaws.services.simpleworkflow.model.DeprecateWorkflowTypeRequest;
import com.amazonaws.services.simpleworkflow.model.DescribeActivityTypeRequest;
import com.amazonaws.services.simpleworkflow.model.DescribeDomainRequest;
import com.amazonaws.services.simpleworkflow.model.DescribeWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.DescribeWorkflowTypeRequest;
import com.amazonaws.services.simpleworkflow.model.DomainDetail;
import com.amazonaws.services.simpleworkflow.model.DomainInfos;
import com.amazonaws.services.simpleworkflow.model.GetWorkflowExecutionHistoryRequest;
import com.amazonaws.services.simpleworkflow.model.History;
import com.amazonaws.services.simpleworkflow.model.ListActivityTypesRequest;
import com.amazonaws.services.simpleworkflow.model.ListClosedWorkflowExecutionsRequest;
import com.amazonaws.services.simpleworkflow.model.ListDomainsRequest;
import com.amazonaws.services.simpleworkflow.model.ListOpenWorkflowExecutionsRequest;
import com.amazonaws.services.simpleworkflow.model.ListTagsForResourceOutput;
import com.amazonaws.services.simpleworkflow.model.ListTagsForResourceRequest;
import com.amazonaws.services.simpleworkflow.model.ListWorkflowTypesRequest;
import com.amazonaws.services.simpleworkflow.model.PendingTaskCount;
import com.amazonaws.services.simpleworkflow.model.PollForActivityTaskRequest;
import com.amazonaws.services.simpleworkflow.model.PollForDecisionTaskRequest;
import com.amazonaws.services.simpleworkflow.model.RecordActivityTaskHeartbeatRequest;
import com.amazonaws.services.simpleworkflow.model.RegisterActivityTypeRequest;
import com.amazonaws.services.simpleworkflow.model.RegisterDomainRequest;
import com.amazonaws.services.simpleworkflow.model.RegisterWorkflowTypeRequest;
import com.amazonaws.services.simpleworkflow.model.RequestCancelWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.RespondActivityTaskCanceledRequest;
import com.amazonaws.services.simpleworkflow.model.RespondActivityTaskCompletedRequest;
import com.amazonaws.services.simpleworkflow.model.RespondActivityTaskFailedRequest;
import com.amazonaws.services.simpleworkflow.model.RespondDecisionTaskCompletedRequest;
import com.amazonaws.services.simpleworkflow.model.Run;
import com.amazonaws.services.simpleworkflow.model.SignalWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.StartWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.TagResourceRequest;
import com.amazonaws.services.simpleworkflow.model.TerminateWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.UndeprecateActivityTypeRequest;
import com.amazonaws.services.simpleworkflow.model.UndeprecateDomainRequest;
import com.amazonaws.services.simpleworkflow.model.UndeprecateWorkflowTypeRequest;
import com.amazonaws.services.simpleworkflow.model.UntagResourceRequest;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionCount;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionDetail;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionInfos;
import com.amazonaws.services.simpleworkflow.model.WorkflowTypeDetail;
import com.amazonaws.services.simpleworkflow.model.WorkflowTypeInfos;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonSimpleWorkflowAsyncClient
extends AmazonSimpleWorkflowClient
implements AmazonSimpleWorkflowAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonSimpleWorkflowAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonSimpleWorkflowAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonSimpleWorkflowAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonSimpleWorkflowAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonSimpleWorkflowAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonSimpleWorkflowAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonSimpleWorkflowAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonSimpleWorkflowAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonSimpleWorkflowAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AmazonSimpleWorkflowAsyncClientBuilder asyncBuilder() {
        return AmazonSimpleWorkflowAsyncClientBuilder.standard();
    }

    AmazonSimpleWorkflowAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<WorkflowExecutionCount> countClosedWorkflowExecutionsAsync(CountClosedWorkflowExecutionsRequest request) {
        return this.countClosedWorkflowExecutionsAsync(request, null);
    }

    @Override
    public Future<WorkflowExecutionCount> countClosedWorkflowExecutionsAsync(CountClosedWorkflowExecutionsRequest request, final AsyncHandler<CountClosedWorkflowExecutionsRequest, WorkflowExecutionCount> asyncHandler) {
        final CountClosedWorkflowExecutionsRequest finalRequest = (CountClosedWorkflowExecutionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<WorkflowExecutionCount>(){

            @Override
            public WorkflowExecutionCount call() throws Exception {
                WorkflowExecutionCount result = null;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.executeCountClosedWorkflowExecutions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<WorkflowExecutionCount> countOpenWorkflowExecutionsAsync(CountOpenWorkflowExecutionsRequest request) {
        return this.countOpenWorkflowExecutionsAsync(request, null);
    }

    @Override
    public Future<WorkflowExecutionCount> countOpenWorkflowExecutionsAsync(CountOpenWorkflowExecutionsRequest request, final AsyncHandler<CountOpenWorkflowExecutionsRequest, WorkflowExecutionCount> asyncHandler) {
        final CountOpenWorkflowExecutionsRequest finalRequest = (CountOpenWorkflowExecutionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<WorkflowExecutionCount>(){

            @Override
            public WorkflowExecutionCount call() throws Exception {
                WorkflowExecutionCount result = null;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.executeCountOpenWorkflowExecutions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PendingTaskCount> countPendingActivityTasksAsync(CountPendingActivityTasksRequest request) {
        return this.countPendingActivityTasksAsync(request, null);
    }

    @Override
    public Future<PendingTaskCount> countPendingActivityTasksAsync(CountPendingActivityTasksRequest request, final AsyncHandler<CountPendingActivityTasksRequest, PendingTaskCount> asyncHandler) {
        final CountPendingActivityTasksRequest finalRequest = (CountPendingActivityTasksRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PendingTaskCount>(){

            @Override
            public PendingTaskCount call() throws Exception {
                PendingTaskCount result = null;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.executeCountPendingActivityTasks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PendingTaskCount> countPendingDecisionTasksAsync(CountPendingDecisionTasksRequest request) {
        return this.countPendingDecisionTasksAsync(request, null);
    }

    @Override
    public Future<PendingTaskCount> countPendingDecisionTasksAsync(CountPendingDecisionTasksRequest request, final AsyncHandler<CountPendingDecisionTasksRequest, PendingTaskCount> asyncHandler) {
        final CountPendingDecisionTasksRequest finalRequest = (CountPendingDecisionTasksRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PendingTaskCount>(){

            @Override
            public PendingTaskCount call() throws Exception {
                PendingTaskCount result = null;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.executeCountPendingDecisionTasks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> deprecateActivityTypeAsync(DeprecateActivityTypeRequest request) {
        return this.deprecateActivityTypeAsync(request, null);
    }

    @Override
    public Future<Void> deprecateActivityTypeAsync(DeprecateActivityTypeRequest request, final AsyncHandler<DeprecateActivityTypeRequest, Void> asyncHandler) {
        final DeprecateActivityTypeRequest finalRequest = (DeprecateActivityTypeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result = null;
                try {
                    AmazonSimpleWorkflowAsyncClient.this.executeDeprecateActivityType(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> deprecateDomainAsync(DeprecateDomainRequest request) {
        return this.deprecateDomainAsync(request, null);
    }

    @Override
    public Future<Void> deprecateDomainAsync(DeprecateDomainRequest request, final AsyncHandler<DeprecateDomainRequest, Void> asyncHandler) {
        final DeprecateDomainRequest finalRequest = (DeprecateDomainRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result = null;
                try {
                    AmazonSimpleWorkflowAsyncClient.this.executeDeprecateDomain(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> deprecateWorkflowTypeAsync(DeprecateWorkflowTypeRequest request) {
        return this.deprecateWorkflowTypeAsync(request, null);
    }

    @Override
    public Future<Void> deprecateWorkflowTypeAsync(DeprecateWorkflowTypeRequest request, final AsyncHandler<DeprecateWorkflowTypeRequest, Void> asyncHandler) {
        final DeprecateWorkflowTypeRequest finalRequest = (DeprecateWorkflowTypeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result = null;
                try {
                    AmazonSimpleWorkflowAsyncClient.this.executeDeprecateWorkflowType(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ActivityTypeDetail> describeActivityTypeAsync(DescribeActivityTypeRequest request) {
        return this.describeActivityTypeAsync(request, null);
    }

    @Override
    public Future<ActivityTypeDetail> describeActivityTypeAsync(DescribeActivityTypeRequest request, final AsyncHandler<DescribeActivityTypeRequest, ActivityTypeDetail> asyncHandler) {
        final DescribeActivityTypeRequest finalRequest = (DescribeActivityTypeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ActivityTypeDetail>(){

            @Override
            public ActivityTypeDetail call() throws Exception {
                ActivityTypeDetail result = null;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.executeDescribeActivityType(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DomainDetail> describeDomainAsync(DescribeDomainRequest request) {
        return this.describeDomainAsync(request, null);
    }

    @Override
    public Future<DomainDetail> describeDomainAsync(DescribeDomainRequest request, final AsyncHandler<DescribeDomainRequest, DomainDetail> asyncHandler) {
        final DescribeDomainRequest finalRequest = (DescribeDomainRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DomainDetail>(){

            @Override
            public DomainDetail call() throws Exception {
                DomainDetail result = null;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.executeDescribeDomain(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<WorkflowExecutionDetail> describeWorkflowExecutionAsync(DescribeWorkflowExecutionRequest request) {
        return this.describeWorkflowExecutionAsync(request, null);
    }

    @Override
    public Future<WorkflowExecutionDetail> describeWorkflowExecutionAsync(DescribeWorkflowExecutionRequest request, final AsyncHandler<DescribeWorkflowExecutionRequest, WorkflowExecutionDetail> asyncHandler) {
        final DescribeWorkflowExecutionRequest finalRequest = (DescribeWorkflowExecutionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<WorkflowExecutionDetail>(){

            @Override
            public WorkflowExecutionDetail call() throws Exception {
                WorkflowExecutionDetail result = null;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.executeDescribeWorkflowExecution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<WorkflowTypeDetail> describeWorkflowTypeAsync(DescribeWorkflowTypeRequest request) {
        return this.describeWorkflowTypeAsync(request, null);
    }

    @Override
    public Future<WorkflowTypeDetail> describeWorkflowTypeAsync(DescribeWorkflowTypeRequest request, final AsyncHandler<DescribeWorkflowTypeRequest, WorkflowTypeDetail> asyncHandler) {
        final DescribeWorkflowTypeRequest finalRequest = (DescribeWorkflowTypeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<WorkflowTypeDetail>(){

            @Override
            public WorkflowTypeDetail call() throws Exception {
                WorkflowTypeDetail result = null;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.executeDescribeWorkflowType(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<History> getWorkflowExecutionHistoryAsync(GetWorkflowExecutionHistoryRequest request) {
        return this.getWorkflowExecutionHistoryAsync(request, null);
    }

    @Override
    public Future<History> getWorkflowExecutionHistoryAsync(GetWorkflowExecutionHistoryRequest request, final AsyncHandler<GetWorkflowExecutionHistoryRequest, History> asyncHandler) {
        final GetWorkflowExecutionHistoryRequest finalRequest = (GetWorkflowExecutionHistoryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<History>(){

            @Override
            public History call() throws Exception {
                History result = null;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.executeGetWorkflowExecutionHistory(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ActivityTypeInfos> listActivityTypesAsync(ListActivityTypesRequest request) {
        return this.listActivityTypesAsync(request, null);
    }

    @Override
    public Future<ActivityTypeInfos> listActivityTypesAsync(ListActivityTypesRequest request, final AsyncHandler<ListActivityTypesRequest, ActivityTypeInfos> asyncHandler) {
        final ListActivityTypesRequest finalRequest = (ListActivityTypesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ActivityTypeInfos>(){

            @Override
            public ActivityTypeInfos call() throws Exception {
                ActivityTypeInfos result = null;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.executeListActivityTypes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<WorkflowExecutionInfos> listClosedWorkflowExecutionsAsync(ListClosedWorkflowExecutionsRequest request) {
        return this.listClosedWorkflowExecutionsAsync(request, null);
    }

    @Override
    public Future<WorkflowExecutionInfos> listClosedWorkflowExecutionsAsync(ListClosedWorkflowExecutionsRequest request, final AsyncHandler<ListClosedWorkflowExecutionsRequest, WorkflowExecutionInfos> asyncHandler) {
        final ListClosedWorkflowExecutionsRequest finalRequest = (ListClosedWorkflowExecutionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<WorkflowExecutionInfos>(){

            @Override
            public WorkflowExecutionInfos call() throws Exception {
                WorkflowExecutionInfos result = null;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.executeListClosedWorkflowExecutions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DomainInfos> listDomainsAsync(ListDomainsRequest request) {
        return this.listDomainsAsync(request, null);
    }

    @Override
    public Future<DomainInfos> listDomainsAsync(ListDomainsRequest request, final AsyncHandler<ListDomainsRequest, DomainInfos> asyncHandler) {
        final ListDomainsRequest finalRequest = (ListDomainsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DomainInfos>(){

            @Override
            public DomainInfos call() throws Exception {
                DomainInfos result = null;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.executeListDomains(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<WorkflowExecutionInfos> listOpenWorkflowExecutionsAsync(ListOpenWorkflowExecutionsRequest request) {
        return this.listOpenWorkflowExecutionsAsync(request, null);
    }

    @Override
    public Future<WorkflowExecutionInfos> listOpenWorkflowExecutionsAsync(ListOpenWorkflowExecutionsRequest request, final AsyncHandler<ListOpenWorkflowExecutionsRequest, WorkflowExecutionInfos> asyncHandler) {
        final ListOpenWorkflowExecutionsRequest finalRequest = (ListOpenWorkflowExecutionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<WorkflowExecutionInfos>(){

            @Override
            public WorkflowExecutionInfos call() throws Exception {
                WorkflowExecutionInfos result = null;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.executeListOpenWorkflowExecutions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceOutput> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceOutput> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceOutput> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceOutput>(){

            @Override
            public ListTagsForResourceOutput call() throws Exception {
                ListTagsForResourceOutput result = null;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<WorkflowTypeInfos> listWorkflowTypesAsync(ListWorkflowTypesRequest request) {
        return this.listWorkflowTypesAsync(request, null);
    }

    @Override
    public Future<WorkflowTypeInfos> listWorkflowTypesAsync(ListWorkflowTypesRequest request, final AsyncHandler<ListWorkflowTypesRequest, WorkflowTypeInfos> asyncHandler) {
        final ListWorkflowTypesRequest finalRequest = (ListWorkflowTypesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<WorkflowTypeInfos>(){

            @Override
            public WorkflowTypeInfos call() throws Exception {
                WorkflowTypeInfos result = null;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.executeListWorkflowTypes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ActivityTask> pollForActivityTaskAsync(PollForActivityTaskRequest request) {
        return this.pollForActivityTaskAsync(request, null);
    }

    @Override
    public Future<ActivityTask> pollForActivityTaskAsync(PollForActivityTaskRequest request, final AsyncHandler<PollForActivityTaskRequest, ActivityTask> asyncHandler) {
        final PollForActivityTaskRequest finalRequest = (PollForActivityTaskRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ActivityTask>(){

            @Override
            public ActivityTask call() throws Exception {
                ActivityTask result = null;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.executePollForActivityTask(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DecisionTask> pollForDecisionTaskAsync(PollForDecisionTaskRequest request) {
        return this.pollForDecisionTaskAsync(request, null);
    }

    @Override
    public Future<DecisionTask> pollForDecisionTaskAsync(PollForDecisionTaskRequest request, final AsyncHandler<PollForDecisionTaskRequest, DecisionTask> asyncHandler) {
        final PollForDecisionTaskRequest finalRequest = (PollForDecisionTaskRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DecisionTask>(){

            @Override
            public DecisionTask call() throws Exception {
                DecisionTask result = null;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.executePollForDecisionTask(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ActivityTaskStatus> recordActivityTaskHeartbeatAsync(RecordActivityTaskHeartbeatRequest request) {
        return this.recordActivityTaskHeartbeatAsync(request, null);
    }

    @Override
    public Future<ActivityTaskStatus> recordActivityTaskHeartbeatAsync(RecordActivityTaskHeartbeatRequest request, final AsyncHandler<RecordActivityTaskHeartbeatRequest, ActivityTaskStatus> asyncHandler) {
        final RecordActivityTaskHeartbeatRequest finalRequest = (RecordActivityTaskHeartbeatRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ActivityTaskStatus>(){

            @Override
            public ActivityTaskStatus call() throws Exception {
                ActivityTaskStatus result = null;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.executeRecordActivityTaskHeartbeat(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> registerActivityTypeAsync(RegisterActivityTypeRequest request) {
        return this.registerActivityTypeAsync(request, null);
    }

    @Override
    public Future<Void> registerActivityTypeAsync(RegisterActivityTypeRequest request, final AsyncHandler<RegisterActivityTypeRequest, Void> asyncHandler) {
        final RegisterActivityTypeRequest finalRequest = (RegisterActivityTypeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result = null;
                try {
                    AmazonSimpleWorkflowAsyncClient.this.executeRegisterActivityType(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> registerDomainAsync(RegisterDomainRequest request) {
        return this.registerDomainAsync(request, null);
    }

    @Override
    public Future<Void> registerDomainAsync(RegisterDomainRequest request, final AsyncHandler<RegisterDomainRequest, Void> asyncHandler) {
        final RegisterDomainRequest finalRequest = (RegisterDomainRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result = null;
                try {
                    AmazonSimpleWorkflowAsyncClient.this.executeRegisterDomain(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> registerWorkflowTypeAsync(RegisterWorkflowTypeRequest request) {
        return this.registerWorkflowTypeAsync(request, null);
    }

    @Override
    public Future<Void> registerWorkflowTypeAsync(RegisterWorkflowTypeRequest request, final AsyncHandler<RegisterWorkflowTypeRequest, Void> asyncHandler) {
        final RegisterWorkflowTypeRequest finalRequest = (RegisterWorkflowTypeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result = null;
                try {
                    AmazonSimpleWorkflowAsyncClient.this.executeRegisterWorkflowType(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> requestCancelWorkflowExecutionAsync(RequestCancelWorkflowExecutionRequest request) {
        return this.requestCancelWorkflowExecutionAsync(request, null);
    }

    @Override
    public Future<Void> requestCancelWorkflowExecutionAsync(RequestCancelWorkflowExecutionRequest request, final AsyncHandler<RequestCancelWorkflowExecutionRequest, Void> asyncHandler) {
        final RequestCancelWorkflowExecutionRequest finalRequest = (RequestCancelWorkflowExecutionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result = null;
                try {
                    AmazonSimpleWorkflowAsyncClient.this.executeRequestCancelWorkflowExecution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> respondActivityTaskCanceledAsync(RespondActivityTaskCanceledRequest request) {
        return this.respondActivityTaskCanceledAsync(request, null);
    }

    @Override
    public Future<Void> respondActivityTaskCanceledAsync(RespondActivityTaskCanceledRequest request, final AsyncHandler<RespondActivityTaskCanceledRequest, Void> asyncHandler) {
        final RespondActivityTaskCanceledRequest finalRequest = (RespondActivityTaskCanceledRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result = null;
                try {
                    AmazonSimpleWorkflowAsyncClient.this.executeRespondActivityTaskCanceled(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> respondActivityTaskCompletedAsync(RespondActivityTaskCompletedRequest request) {
        return this.respondActivityTaskCompletedAsync(request, null);
    }

    @Override
    public Future<Void> respondActivityTaskCompletedAsync(RespondActivityTaskCompletedRequest request, final AsyncHandler<RespondActivityTaskCompletedRequest, Void> asyncHandler) {
        final RespondActivityTaskCompletedRequest finalRequest = (RespondActivityTaskCompletedRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result = null;
                try {
                    AmazonSimpleWorkflowAsyncClient.this.executeRespondActivityTaskCompleted(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> respondActivityTaskFailedAsync(RespondActivityTaskFailedRequest request) {
        return this.respondActivityTaskFailedAsync(request, null);
    }

    @Override
    public Future<Void> respondActivityTaskFailedAsync(RespondActivityTaskFailedRequest request, final AsyncHandler<RespondActivityTaskFailedRequest, Void> asyncHandler) {
        final RespondActivityTaskFailedRequest finalRequest = (RespondActivityTaskFailedRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result = null;
                try {
                    AmazonSimpleWorkflowAsyncClient.this.executeRespondActivityTaskFailed(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> respondDecisionTaskCompletedAsync(RespondDecisionTaskCompletedRequest request) {
        return this.respondDecisionTaskCompletedAsync(request, null);
    }

    @Override
    public Future<Void> respondDecisionTaskCompletedAsync(RespondDecisionTaskCompletedRequest request, final AsyncHandler<RespondDecisionTaskCompletedRequest, Void> asyncHandler) {
        final RespondDecisionTaskCompletedRequest finalRequest = (RespondDecisionTaskCompletedRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result = null;
                try {
                    AmazonSimpleWorkflowAsyncClient.this.executeRespondDecisionTaskCompleted(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> signalWorkflowExecutionAsync(SignalWorkflowExecutionRequest request) {
        return this.signalWorkflowExecutionAsync(request, null);
    }

    @Override
    public Future<Void> signalWorkflowExecutionAsync(SignalWorkflowExecutionRequest request, final AsyncHandler<SignalWorkflowExecutionRequest, Void> asyncHandler) {
        final SignalWorkflowExecutionRequest finalRequest = (SignalWorkflowExecutionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result = null;
                try {
                    AmazonSimpleWorkflowAsyncClient.this.executeSignalWorkflowExecution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Run> startWorkflowExecutionAsync(StartWorkflowExecutionRequest request) {
        return this.startWorkflowExecutionAsync(request, null);
    }

    @Override
    public Future<Run> startWorkflowExecutionAsync(StartWorkflowExecutionRequest request, final AsyncHandler<StartWorkflowExecutionRequest, Run> asyncHandler) {
        final StartWorkflowExecutionRequest finalRequest = (StartWorkflowExecutionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<Run>(){

            @Override
            public Run call() throws Exception {
                Run result = null;
                try {
                    result = AmazonSimpleWorkflowAsyncClient.this.executeStartWorkflowExecution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<Void> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, Void> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result = null;
                try {
                    AmazonSimpleWorkflowAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> terminateWorkflowExecutionAsync(TerminateWorkflowExecutionRequest request) {
        return this.terminateWorkflowExecutionAsync(request, null);
    }

    @Override
    public Future<Void> terminateWorkflowExecutionAsync(TerminateWorkflowExecutionRequest request, final AsyncHandler<TerminateWorkflowExecutionRequest, Void> asyncHandler) {
        final TerminateWorkflowExecutionRequest finalRequest = (TerminateWorkflowExecutionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result = null;
                try {
                    AmazonSimpleWorkflowAsyncClient.this.executeTerminateWorkflowExecution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> undeprecateActivityTypeAsync(UndeprecateActivityTypeRequest request) {
        return this.undeprecateActivityTypeAsync(request, null);
    }

    @Override
    public Future<Void> undeprecateActivityTypeAsync(UndeprecateActivityTypeRequest request, final AsyncHandler<UndeprecateActivityTypeRequest, Void> asyncHandler) {
        final UndeprecateActivityTypeRequest finalRequest = (UndeprecateActivityTypeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result = null;
                try {
                    AmazonSimpleWorkflowAsyncClient.this.executeUndeprecateActivityType(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> undeprecateDomainAsync(UndeprecateDomainRequest request) {
        return this.undeprecateDomainAsync(request, null);
    }

    @Override
    public Future<Void> undeprecateDomainAsync(UndeprecateDomainRequest request, final AsyncHandler<UndeprecateDomainRequest, Void> asyncHandler) {
        final UndeprecateDomainRequest finalRequest = (UndeprecateDomainRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result = null;
                try {
                    AmazonSimpleWorkflowAsyncClient.this.executeUndeprecateDomain(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> undeprecateWorkflowTypeAsync(UndeprecateWorkflowTypeRequest request) {
        return this.undeprecateWorkflowTypeAsync(request, null);
    }

    @Override
    public Future<Void> undeprecateWorkflowTypeAsync(UndeprecateWorkflowTypeRequest request, final AsyncHandler<UndeprecateWorkflowTypeRequest, Void> asyncHandler) {
        final UndeprecateWorkflowTypeRequest finalRequest = (UndeprecateWorkflowTypeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result = null;
                try {
                    AmazonSimpleWorkflowAsyncClient.this.executeUndeprecateWorkflowType(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<Void> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, Void> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result = null;
                try {
                    AmazonSimpleWorkflowAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

