/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53recoveryreadiness.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.route53recoveryreadiness.model.DNSTargetResource;
import com.amazonaws.services.route53recoveryreadiness.model.transform.ResourceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Resource
implements Serializable,
Cloneable,
StructuredPojo {
    private String componentId;
    private DNSTargetResource dnsTargetResource;
    private List<String> readinessScopes;
    private String resourceArn;

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public Resource withComponentId(String componentId) {
        this.setComponentId(componentId);
        return this;
    }

    public void setDnsTargetResource(DNSTargetResource dnsTargetResource) {
        this.dnsTargetResource = dnsTargetResource;
    }

    public DNSTargetResource getDnsTargetResource() {
        return this.dnsTargetResource;
    }

    public Resource withDnsTargetResource(DNSTargetResource dnsTargetResource) {
        this.setDnsTargetResource(dnsTargetResource);
        return this;
    }

    public List<String> getReadinessScopes() {
        return this.readinessScopes;
    }

    public void setReadinessScopes(Collection<String> readinessScopes) {
        if (readinessScopes == null) {
            this.readinessScopes = null;
            return;
        }
        this.readinessScopes = new ArrayList<String>(readinessScopes);
    }

    public Resource withReadinessScopes(String ... readinessScopes) {
        if (this.readinessScopes == null) {
            this.setReadinessScopes(new ArrayList<String>(readinessScopes.length));
        }
        for (String ele : readinessScopes) {
            this.readinessScopes.add(ele);
        }
        return this;
    }

    public Resource withReadinessScopes(Collection<String> readinessScopes) {
        this.setReadinessScopes(readinessScopes);
        return this;
    }

    public void setResourceArn(String resourceArn) {
        this.resourceArn = resourceArn;
    }

    public String getResourceArn() {
        return this.resourceArn;
    }

    public Resource withResourceArn(String resourceArn) {
        this.setResourceArn(resourceArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getComponentId() != null) {
            sb.append("ComponentId: ").append(this.getComponentId()).append(",");
        }
        if (this.getDnsTargetResource() != null) {
            sb.append("DnsTargetResource: ").append(this.getDnsTargetResource()).append(",");
        }
        if (this.getReadinessScopes() != null) {
            sb.append("ReadinessScopes: ").append(this.getReadinessScopes()).append(",");
        }
        if (this.getResourceArn() != null) {
            sb.append("ResourceArn: ").append(this.getResourceArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)obj;
        if (other.getComponentId() == null ^ this.getComponentId() == null) {
            return false;
        }
        if (other.getComponentId() != null && !other.getComponentId().equals(this.getComponentId())) {
            return false;
        }
        if (other.getDnsTargetResource() == null ^ this.getDnsTargetResource() == null) {
            return false;
        }
        if (other.getDnsTargetResource() != null && !other.getDnsTargetResource().equals(this.getDnsTargetResource())) {
            return false;
        }
        if (other.getReadinessScopes() == null ^ this.getReadinessScopes() == null) {
            return false;
        }
        if (other.getReadinessScopes() != null && !other.getReadinessScopes().equals(this.getReadinessScopes())) {
            return false;
        }
        if (other.getResourceArn() == null ^ this.getResourceArn() == null) {
            return false;
        }
        return other.getResourceArn() == null || other.getResourceArn().equals(this.getResourceArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getComponentId() == null ? 0 : this.getComponentId().hashCode());
        hashCode = 31 * hashCode + (this.getDnsTargetResource() == null ? 0 : this.getDnsTargetResource().hashCode());
        hashCode = 31 * hashCode + (this.getReadinessScopes() == null ? 0 : this.getReadinessScopes().hashCode());
        hashCode = 31 * hashCode + (this.getResourceArn() == null ? 0 : this.getResourceArn().hashCode());
        return hashCode;
    }

    public Resource clone() {
        try {
            return (Resource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

